/*
 * Decompiled with CFR 0.152.
 */
package by.legan.library.netengine.network.client;

import by.legan.library.netengine.controller.NetClientController;
import by.legan.library.netengine.interfaces.Logs;
import by.legan.library.netengine.network.Network;
import by.legan.library.netengine.network.client.AbstractClient;
import by.legan.library.netengine.network.client.ClientInfo;
import by.legan.library.netengine.network.packeges.serverTOclient.ServerMessage;
import com.esotericsoftware.kryonet.Client;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.EndPoint;
import com.esotericsoftware.kryonet.Listener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class NetClient
extends AbstractClient {
    ClientInfo info;
    Client client = new Client(256000, 256000);

    public NetClient(final NetClientController clientNetController) {
        super(clientNetController);
        this.client.start();
        Network.register((EndPoint)this.client, clientNetController.classArrayList);
        this.client.addListener(new Listener(){

            public void connected(Connection connection) {
                NetClient.this.info = new ClientInfo();
                NetClient.this.info.UserID = NetClient.this.client.getID();
                NetClient.this.status = AbstractClient.NetClientStatus.online;
                clientNetController.netClientMessage(new ServerMessage.AcceptConnected());
            }

            public void received(Connection connection, Object object) {
                NetClient.this.netClientListener.netClientMessage(object);
            }

            public void disconnected(Connection connection) {
                NetClient.this.status = AbstractClient.NetClientStatus.offline;
                clientNetController.netClientMessage(new ServerMessage.ServerDisconnect());
            }
        });
        if (((NetClientController)this.programController).getName() == null) {
            try {
                InetAddress inet = InetAddress.getLocalHost();
                InetAddress[] ips = InetAddress.getAllByName(inet.getCanonicalHostName());
                if (ips != null) {
                    ((NetClientController)this.programController).setName(inet.toString());
                    this.name = ((NetClientController)this.programController).getName();
                }
            }
            catch (UnknownHostException e) {
                this.name = "UnknownHost";
                ((NetClientController)this.programController).setName(this.name);
            }
        }
        this.name = "Client : " + this.name;
        ((NetClientController)this.programController).setName(this.name);
    }

    public void connect() {
        new Thread("Connect"){

            @Override
            public void run() {
                try {
                    NetClient.this.client.connect(50000, ((NetClientController)NetClient.this.programController).host, Network.portTCP, Network.portUDP);
                }
                catch (IOException ex) {
                    ((NetClientController)NetClient.this.programController).netClientMessage(new ServerMessage.ServerDisconnect());
                    Logs.out(ex.toString());
                }
            }
        }.start();
    }

    @Override
    public void sendToTCP(Object message) {
        this.sendMessage(message);
    }

    @Override
    public void sendMessage(Object message) {
        try {
            this.client.sendTCP(message);
        }
        catch (Exception e) {
            Logs.out(e.toString());
        }
    }

    @Override
    public void dispose() {
        this.client.stop();
        Logs.out("NetClient disconnected from the server and dispose");
    }
}

