/*
 * Decompiled with CFR 0.152.
 */
package by.legan.library.netengine.controller;

import by.legan.library.netengine.controller.eventManager.ServerEventManager;
import by.legan.library.netengine.interfaces.Logs;
import by.legan.library.netengine.interfaces.Manager;
import by.legan.library.netengine.interfaces.ProgramController;
import by.legan.library.netengine.interfaces.WorkData;
import by.legan.library.netengine.network.packeges.clientTOserver.ClientMessage;
import by.legan.library.netengine.network.packeges.serverTOclient.ServerMessage;
import by.legan.library.netengine.network.server.AbstractServer;
import by.legan.library.netengine.network.server.NetServer;
import com.esotericsoftware.kryonet.Connection;
import java.util.ArrayList;

public class NetServerController
extends ProgramController<WorkData>
implements AbstractServer.NetServerListener,
Manager.ManagerListener {
    NetServer server;
    ServerEventManager serverEventManager;
    ArrayList<ServerMessage> sendQuery;
    GUIListener guiListener;
    public ArrayList<Class> classArrayList;

    public GUIListener getGuiListener() {
        return this.guiListener;
    }

    public void setGuiListener(GUIListener guiListener) {
        this.guiListener = guiListener;
    }

    public NetServerController(String name, ArrayList<Class> classArrayList) {
        super(name);
        this.classArrayList = classArrayList;
        this.server = new NetServer(this);
        this.server.setGameServerListener(this);
        this.serverEventManager = new ServerEventManager(this);
        this.serverEventManager.setListener(this);
        this.sendQuery = new ArrayList();
    }

    public boolean start() {
        this.startUpdateThread();
        return this.server.start();
    }

    public void stop() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerMessageToQuery(ServerMessage msg) {
        ArrayList<ServerMessage> arrayList = this.sendQuery;
        synchronized (arrayList) {
            this.sendQuery.add(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAllQueryToClient() {
        ArrayList<ServerMessage> arrayList = this.sendQuery;
        synchronized (arrayList) {
            if (this.sendQuery.size() > 0) {
                for (int i = 0; i < this.sendQuery.size(); ++i) {
                    if (this.sendQuery.get(i).getId() == -1) {
                        this.server.sendToAllTCP(this.sendQuery.get(i));
                        continue;
                    }
                    this.server.sendtoTCP(this.sendQuery.get(i).getId(), this.sendQuery.get(i));
                }
                this.sendQuery.clear();
            }
        }
    }

    public Connection[] getConnections() {
        return this.server.getConnections();
    }

    @Override
    public void update() {
        this.sendAllQueryToClient();
        if (this.status == ProgramController.Status.Dispose) {
            this.dispose();
        }
        if (this.serverEventManager != null) {
            this.serverEventManager.process();
        }
    }

    @Override
    public void netServerMessage(int connectionID, Object event) {
        if (event instanceof ClientMessage) {
            Logs.out("Server : \u041f\u0440\u0438\u043d\u044f\u0442\u043e \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0442 \u043a\u043b\u0438\u0435\u043d\u0442\u0430 - " + event);
            ClientMessage ev = (ClientMessage)event;
            ev.setId(connectionID);
            this.serverEventManager.addEventToQueue(ev);
        }
    }

    @Override
    public void ListenerMessage(Object msg) {
        if (this.guiListener != null) {
            this.guiListener.GUIMessage(msg);
        }
        if (msg instanceof ServerMessage) {
            Logs.out("Server : \u0421\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d \u043e\u0442\u0432\u0435\u0442 \u0434\u043b\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u0430, \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c - " + msg);
            this.addServerMessageToQuery((ServerMessage)msg);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.server.dispose();
    }

    public static interface GUIListener {
        public void GUIMessage(Object var1);
    }
}

