/*
 * Decompiled with CFR 0.152.
 */
package by.legan.library.netengine.controller;

import by.legan.library.netengine.controller.eventManager.ClientEventManager;
import by.legan.library.netengine.interfaces.Manager;
import by.legan.library.netengine.interfaces.ProgramController;
import by.legan.library.netengine.interfaces.WorkData;
import by.legan.library.netengine.network.client.AbstractClient;
import by.legan.library.netengine.network.client.NetClient;
import by.legan.library.netengine.network.packeges.clientTOserver.ClientMessage;
import by.legan.library.netengine.network.packeges.serverTOclient.ServerMessage;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;

public class NetClientController
extends ProgramController<WorkData>
implements AbstractClient.NetClientListener,
Manager.ManagerListener {
    public NetClient client;
    public String host;
    ClientEventManager clientEventManager;
    ArrayList<ClientMessage> sendQuery;
    GUIListener guiListener;
    public ArrayList<Class> classArrayList;

    public GUIListener getGuiListener() {
        return this.guiListener;
    }

    public void setGuiListener(GUIListener guiListener) {
        this.guiListener = guiListener;
    }

    public NetClientController(String IP) {
        this(null, IP, null);
    }

    public NetClientController(String name, String IP, ArrayList<Class> classArrayList) {
        super(name);
        this.host = IP;
        this.classArrayList = classArrayList;
        this.client = new NetClient(this);
        this.client.setNetClientListener(this);
        this.clientEventManager = new ClientEventManager(this);
        this.clientEventManager.setListener(this);
        this.sendQuery = new ArrayList();
    }

    public void start() {
        this.client.connect();
        this.startUpdateThread();
    }

    public void stop() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientMessageToQuery(ClientMessage msg) {
        ArrayList<ClientMessage> arrayList = this.sendQuery;
        synchronized (arrayList) {
            this.sendQuery.add(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAllQueryToServer() {
        ArrayList<ClientMessage> arrayList = this.sendQuery;
        synchronized (arrayList) {
            if (this.sendQuery.size() > 0) {
                for (int i = 0; i < this.sendQuery.size(); ++i) {
                    this.client.sendToTCP(this.sendQuery.get(i));
                }
                this.sendQuery.clear();
            }
        }
    }

    @Override
    public void update() {
        this.sendAllQueryToServer();
        if (this.clientEventManager != null) {
            this.clientEventManager.process();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.client.dispose();
    }

    @Override
    public void netClientMessage(Object event) {
        if (event instanceof ServerMessage) {
            ServerMessage ev = (ServerMessage)event;
            this.clientEventManager.addEventToQueue(ev);
        }
    }

    @Override
    public void ListenerMessage(Object msg) {
        if (this.guiListener != null) {
            this.guiListener.GUIMessage(msg);
        }
        if (msg instanceof ClientMessage) {
            this.addClientMessageToQuery((ClientMessage)msg);
        }
    }

    public static interface GUIListener {
        public void GUIMessage(Object var1);
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface PortUDP {
        public int portUDP();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NetworkPrameters {
        public Protocol protocol();

        public int port();

        public String host();

        public static enum Protocol {
            TCP,
            UDP;

        }
    }
}

