/*
 * Decompiled with CFR 0.152.
 */
package by.legan.library.netengine.network.server;

import by.legan.library.netengine.controller.NetServerController;
import by.legan.library.netengine.interfaces.Logs;
import by.legan.library.netengine.network.Network;
import by.legan.library.netengine.network.server.AbstractServer;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.EndPoint;
import com.esotericsoftware.kryonet.Listener;
import com.esotericsoftware.kryonet.Server;

public class NetServer
extends AbstractServer {
    Server server = new Server(256000, 256000){

        protected Connection newConnection() {
            NetServer.this.status = AbstractServer.NetServerStatus.online;
            return new SConnection();
        }
    };

    public NetServer(NetServerController netServerController) {
        super(netServerController);
        Network.register((EndPoint)this.server);
        this.server.addListener(new Listener(){

            public void received(Connection c, Object object) {
                SConnection connection = (SConnection)c;
                NetServer.this.netServerListener.netServerMessage(connection.getID(), object);
            }

            public void disconnected(Connection c) {
                SConnection connection = (SConnection)c;
                if (connection.name != null) {
                    Logs.out("User : " + c.getID() + " disconnected");
                }
            }
        });
        try {
            this.server.bind(8900, 8902);
            this.server.start();
        }
        catch (Exception e) {
            Logs.out("ERROR Server already running");
            System.exit(0);
        }
    }

    @Override
    public int getCollClient() {
        return this.server.getConnections().length;
    }

    @Override
    public void dispose() {
        this.server.stop();
        Logs.out("Server stop");
    }

    @Override
    public void sendToAllUDP(Object message) {
        this.server.sendToAllUDP(message);
    }

    @Override
    public void sendToAllTCP(Object message) {
        this.server.sendToAllTCP(message);
    }

    @Override
    public void sendtoTCP(int connectionID, Object message) {
        this.server.sendToTCP(connectionID, message);
    }

    @Override
    public void sendtoUDP(int connectionID, Object message) {
        this.server.sendToUDP(connectionID, message);
    }

    static class SConnection
    extends Connection {
        public String name;

        SConnection() {
        }
    }
}

