/*
 * Decompiled with CFR 0.152.
 */
package by.legan.library.netengine.network.client;

import by.legan.library.netengine.controller.NetClientController;
import by.legan.library.netengine.interfaces.Logs;
import by.legan.library.netengine.network.Network;
import by.legan.library.netengine.network.client.AbstractClient;
import by.legan.library.netengine.network.client.ClientInfo;
import com.esotericsoftware.kryonet.Client;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.EndPoint;
import com.esotericsoftware.kryonet.Listener;
import java.io.IOException;

public class NetClient
extends AbstractClient {
    ClientInfo info;
    Client client = new Client(256000, 256000);

    public NetClient(NetClientController clientGameController) {
        super(clientGameController);
        this.client.start();
        Network.register((EndPoint)this.client);
        this.client.addListener(new Listener(){

            public void connected(Connection connection) {
                NetClient.this.info = new ClientInfo();
                NetClient.this.info.UserID = NetClient.this.client.getID();
                NetClient.this.status = AbstractClient.NetClientStatus.online;
            }

            public void received(Connection connection, Object object) {
                NetClient.this.netClientListener.netClientMessage(object);
            }

            public void disconnected(Connection connection) {
                Logs.out("netClient disconnected");
            }
        });
        String input = clientGameController.host;
        final String host = input.trim();
        input = "ClientName";
        this.name = input.trim();
        new Thread("Connect"){

            @Override
            public void run() {
                try {
                    NetClient.this.client.connect(50000, host, 8900, 8902);
                }
                catch (IOException ex) {
                    System.exit(0);
                }
            }
        }.start();
    }

    @Override
    public void sendToTCP(Object message) {
        this.sendMessage(message);
    }

    @Override
    public void sendMessage(Object message) {
        try {
            this.client.sendTCP(message);
        }
        catch (Exception e) {
            Logs.out(e.toString());
        }
    }

    @Override
    public void dispose() {
        this.client.stop();
        Logs.out("netClient disconnected from the server and dispose");
    }
}

