/*
 * Decompiled with CFR 0.152.
 */
package by.legan.library.netengine.interfaces;

import by.legan.library.netengine.interfaces.Disposable;
import by.legan.library.netengine.interfaces.Logs;

public abstract class ProgramController<T>
implements Disposable {
    String name;
    protected Status status = Status.Stop;
    long sleepMillis = 0L;
    int sleepNano = 500;
    boolean updateRun = false;
    private T items;
    Thread threadUpdate;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public long getSleepMillis() {
        return this.sleepMillis;
    }

    public void setSleepMillis(long sleepMillis) {
        this.sleepMillis = sleepMillis;
    }

    public int getSleepNano() {
        return this.sleepNano;
    }

    public void setSleepNano(int sleepNano) {
        this.sleepNano = sleepNano;
    }

    public void startUpdateThread() {
        Logs.out("Thread " + this.threadUpdate.getName() + " run");
        this.threadUpdate = new Thread(new Update());
        this.threadUpdate.setName("Update" + this.name);
        this.updateRun = true;
        this.threadUpdate.start();
        this.status = Status.Run;
    }

    public void stopUpdateThread() {
        this.status = Status.Stop;
        this.updateRun = false;
    }

    public ProgramController(String name) {
        this.name = name;
        this.status = Status.Init;
    }

    public T getItems() {
        return this.items;
    }

    public void setItems(T items) {
        this.items = items;
    }

    public abstract void update();

    @Override
    public void dispose() {
        this.stopUpdateThread();
        this.status = Status.Dispose;
    }

    private class Update
    implements Runnable {
        private Update() {
        }

        @Override
        public void run() {
            while (ProgramController.this.updateRun) {
                ProgramController.this.update();
                try {
                    Thread.sleep(ProgramController.this.sleepMillis, ProgramController.this.sleepNano);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Logs.out("Thread " + ProgramController.this.threadUpdate.getName() + " stop");
            if (ProgramController.this.status == Status.Dispose) {
                System.exit(0);
            }
        }
    }

    public static enum Status {
        Stop,
        Init,
        Start,
        Run,
        Dispose;

    }
}

