/*
 * Decompiled with CFR 0.152.
 */
package by.bulba.android.environments.parser;

import by.bulba.android.environments.config.ConfigType;
import by.bulba.android.environments.parser.ConfigTypeParser;

public class StringConfigTypeParser
implements ConfigTypeParser<String> {
    @Override
    public ConfigType parse(String value) {
        if (value == null) {
            throw new NullPointerException("Missing configuration value");
        }
        if (value.matches("-?\\d+L")) {
            return ConfigType.LONG;
        }
        if (value.matches("-?\\d+")) {
            return ConfigType.INTEGER;
        }
        if (value.matches("[+-]?(\\d+\\.)?\\d+[f]?$")) {
            return ConfigType.FLOAT;
        }
        if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
            return ConfigType.BOOLEAN;
        }
        return ConfigType.STRING;
    }
}

