/*
 * Decompiled with CFR 0.152.
 */
package by.bulba.android.environments.file;

import by.bulba.android.environments.ConfigFormat;
import by.bulba.android.environments.exceptions.DirectoryExpectedException;
import by.bulba.android.environments.exceptions.DirectoryNotFoundException;
import by.bulba.android.environments.file.ConfigFileProvider;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class ConfigFileProviderImpl
implements ConfigFileProvider {
    private final File rootConfigPath;
    private final ConfigFormat configFormat;

    public ConfigFileProviderImpl(File rootConfigPath, ConfigFormat configFormat) {
        this.rootConfigPath = rootConfigPath;
        this.configFormat = configFormat;
    }

    @Override
    public Collection<File> getConfigFiles(String subfolder) {
        File applicationVariantDir = new File(this.rootConfigPath, subfolder);
        if (!applicationVariantDir.exists()) {
            throw new DirectoryNotFoundException();
        }
        if (!applicationVariantDir.isDirectory()) {
            throw new DirectoryExpectedException(applicationVariantDir);
        }
        File[] configFiles = this.getFilteredConfigFiles(applicationVariantDir);
        if (configFiles != null && configFiles.length > 0) {
            return Arrays.asList(configFiles);
        }
        return Collections.emptyList();
    }

    private File[] getFilteredConfigFiles(File dir) {
        return dir.listFiles(pathname -> pathname.isFile() && pathname.getName().endsWith(this.configFormat.getExtension()));
    }
}

