/*
 * Decompiled with CFR 0.152.
 */
package by.bulba.android.environments.config;

import by.bulba.android.environments.config.BaseConfigReader;
import by.bulba.android.environments.config.ConfigType;
import by.bulba.android.environments.config.ConfigValue;
import by.bulba.android.environments.parser.ConfigTypeParser;
import by.bulba.android.environments.parser.StringConfigTypeParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;

public class YamlConfigReader
extends BaseConfigReader<String> {
    private Map<String, String> map;

    public YamlConfigReader(Map<String, String> model) {
        this.map = model;
    }

    @Override
    public Collection<ConfigValue> getConfigValues() {
        ArrayList<ConfigValue> collection = new ArrayList<ConfigValue>();
        this.map.forEach((key, value) -> {
            ConfigType valueType = this.parseConfigType(value);
            ConfigValue configValue = new ConfigValue.Builder().key(this.toConfigKey((String)key)).value(this.parseValue(value, valueType)).type(valueType).build();
            collection.add(configValue);
        });
        return collection;
    }

    @VisibleForTesting
    String parseValue(Object value, ConfigType valueType) {
        switch (valueType) {
            case FLOAT: {
                return String.format("%sf", String.valueOf(value));
            }
        }
        return String.valueOf(value);
    }

    @Override
    ConfigTypeParser<String> getConfigTypeParser() {
        return new StringConfigTypeParser();
    }
}

