/*
 * Decompiled with CFR 0.152.
 */
package by.bulba.android.environments.config;

import by.bulba.android.environments.config.BaseConfigReader;
import by.bulba.android.environments.config.ConfigType;
import by.bulba.android.environments.config.ConfigValue;
import by.bulba.android.environments.parser.ConfigTypeParser;
import by.bulba.android.environments.parser.ObjectConfigTypeParser;
import java.util.ArrayList;
import java.util.Collection;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.json.simple.JSONObject;

public class JsonConfigReader
extends BaseConfigReader<Object> {
    private final JSONObject jsonObject;

    public JsonConfigReader(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    @Override
    public Collection<ConfigValue> getConfigValues() {
        ArrayList<ConfigValue> collection = new ArrayList<ConfigValue>();
        this.jsonObject.forEach((key, value) -> {
            ConfigType valueType = this.parseConfigType(value);
            ConfigValue configValue = new ConfigValue.Builder().key(this.toConfigKey((String)key)).value(this.parseValue(value, valueType)).type(valueType).build();
            collection.add(configValue);
        });
        return collection;
    }

    @VisibleForTesting
    String parseValue(Object value, ConfigType valueType) {
        switch (valueType) {
            case STRING: {
                return String.format("\"%s\"", String.valueOf(value));
            }
            case FLOAT: {
                return String.format("%sf", String.valueOf(value));
            }
        }
        return String.valueOf(value);
    }

    @Override
    ConfigTypeParser<Object> getConfigTypeParser() {
        return new ObjectConfigTypeParser();
    }
}

