/*
 * Decompiled with CFR 0.152.
 */
package by.bulba.android.environments.config;

import by.bulba.android.environments.ConfigFormat;
import by.bulba.android.environments.config.ConfigReader;
import by.bulba.android.environments.config.ConfigReaderFactory;
import by.bulba.android.environments.config.JsonConfigReader;
import by.bulba.android.environments.config.PropertyConfigReader;
import by.bulba.android.environments.config.YamlConfigReader;
import by.bulba.android.environments.parser.YamlParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Properties;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ConfigReaderFactoryImpl
implements ConfigReaderFactory {
    private final ConfigFormat configFormat;

    public ConfigReaderFactoryImpl(ConfigFormat configFormat) {
        this.configFormat = configFormat;
    }

    @Override
    public ConfigReader create(File file) {
        switch (this.configFormat) {
            case JSON: {
                return this.createJsonConfigReader(file);
            }
            case YML: {
                return this.createYamlConfigReader(file);
            }
        }
        return this.createPropertyConfigReader(file);
    }

    @VisibleForTesting
    ConfigReader createJsonConfigReader(File file) {
        JSONObject jsonObject;
        try {
            if (file.exists()) {
                JSONParser jsonParser = new JSONParser();
                jsonObject = (JSONObject)jsonParser.parse((Reader)new FileReader(file));
            } else {
                jsonObject = new JSONObject();
            }
        }
        catch (IOException | ParseException e) {
            throw new RuntimeException(e);
        }
        return new JsonConfigReader(jsonObject);
    }

    @VisibleForTesting
    ConfigReader createYamlConfigReader(File file) {
        HashMap<String, String> yamlModel = null;
        try {
            if (file.exists()) {
                YamlParser parser = new YamlParser(file);
                yamlModel = parser.parse();
            } else {
                yamlModel = new HashMap();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new YamlConfigReader(yamlModel);
    }

    @VisibleForTesting
    ConfigReader createPropertyConfigReader(File propertiesFile) {
        Properties properties = new Properties();
        if (propertiesFile.exists()) {
            try {
                properties.load(new FileInputStream(propertiesFile));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new PropertyConfigReader(properties);
    }
}

