/*
 * Decompiled with CFR 0.152.
 */
package by.bulba.android.environments.config;

import by.bulba.android.environments.config.ApplicationVariantConfigValueReader;
import by.bulba.android.environments.config.ConfigReaderFactory;
import by.bulba.android.environments.config.ConfigValue;
import by.bulba.android.environments.exceptions.UniqueKeyException;
import by.bulba.android.environments.file.ConfigFileProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;

public class ApplicationVariantConfigValueReaderImpl
implements ApplicationVariantConfigValueReader {
    private final ConfigFileProvider configFileProvider;
    private final ConfigReaderFactory configReaderFactory;

    public ApplicationVariantConfigValueReaderImpl(ConfigFileProvider configFileProvider, ConfigReaderFactory configReaderFactory) {
        this.configFileProvider = configFileProvider;
        this.configReaderFactory = configReaderFactory;
    }

    @Override
    public Collection<ConfigValue> getConfigValues(String appVariant) {
        ArrayList<ConfigValue> totalConfigValues = new ArrayList<ConfigValue>();
        HashSet keySet = new HashSet();
        this.configFileProvider.getConfigFiles(appVariant).forEach(file -> totalConfigValues.addAll(this.collectConfigValues((File)file, keySet)));
        keySet.clear();
        return totalConfigValues;
    }

    @VisibleForTesting
    Collection<ConfigValue> collectConfigValues(File file, Set<String> keySet) {
        ArrayList<ConfigValue> list = new ArrayList<ConfigValue>();
        this.configReaderFactory.create(file).getConfigValues().forEach(configValue -> {
            if (keySet.contains(configValue.getKey())) {
                throw new UniqueKeyException(file, configValue.getKey());
            }
            keySet.add(configValue.getKey());
            list.add((ConfigValue)configValue);
        });
        return list;
    }
}

