/*
 * Decompiled with CFR 0.152.
 */
package by.bulba.android.environments;

public enum ConfigFormat {
    PROPERTIES("properties"),
    JSON("json"),
    YML("yml");

    private final String extension;

    private ConfigFormat(String extension) {
        this.extension = extension;
    }

    public static ConfigFormat parse(String format) {
        if (ConfigFormat.JSON.extension.equals(format)) {
            return JSON;
        }
        if (ConfigFormat.YML.extension.equals(format)) {
            return YML;
        }
        if (ConfigFormat.PROPERTIES.extension.equals(format)) {
            return PROPERTIES;
        }
        throw new IllegalArgumentException("Unknown configuration format: " + format);
    }

    public String getExtension() {
        return this.extension;
    }
}

