/*
 * Decompiled with CFR 0.152.
 */
package by.bulba.android.environments;

import by.bulba.android.environments.AndroidEnvironmentsExtension;
import by.bulba.android.environments.config.ApplicationVariantConfigReaderFactory;
import by.bulba.android.environments.config.ApplicationVariantConfigValueReader;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.jetbrains.annotations.NotNull;

class AndroidEnvironmentsPlugin
implements Plugin<Project> {
    @VisibleForTesting
    AndroidEnvironmentsExtension ext;
    ApplicationVariantConfigReaderFactory configReaderFactory = new ApplicationVariantConfigReaderFactory();

    AndroidEnvironmentsPlugin() {
    }

    public void apply(@NotNull Project project) {
        project.getExtensions().create("environments", AndroidEnvironmentsExtension.class, new Object[0]);
        project.afterEvaluate(project1 -> {
            this.ext = (AndroidEnvironmentsExtension)project1.getExtensions().findByType(AndroidEnvironmentsExtension.class);
            if (this.ext == null) {
                this.ext = new AndroidEnvironmentsExtension();
            }
            this.executeTask(project);
        });
    }

    @VisibleForTesting
    void executeTask(Project project) {
        ApplicationVariantConfigValueReader reader = this.configReaderFactory.create(project, this.ext);
        try {
            Object androidExtension = project.getExtensions().getByName("android");
            if (this.ext.useBuildTypes && androidExtension instanceof BaseExtension) {
                this.processBuildTypes(reader, (BaseExtension)androidExtension);
            }
            if (this.ext.useProductFlavors && androidExtension instanceof AppExtension) {
                this.processApplicationVariants(reader, (AppExtension)androidExtension);
            }
        }
        catch (UnknownDomainObjectException udoe) {
            throw new RuntimeException(udoe);
        }
    }

    @VisibleForTesting
    void processBuildTypes(ApplicationVariantConfigValueReader reader, BaseExtension extension) {
        extension.getBuildTypes().forEach(buildType -> reader.getConfigValues(buildType.getName()).forEach(configValue -> buildType.buildConfigField(configValue.getType().getConfigString(), configValue.getKey(), configValue.getValue())));
    }

    @VisibleForTesting
    void processApplicationVariants(ApplicationVariantConfigValueReader reader, AppExtension extension) {
        extension.getApplicationVariants().forEach(applicationVariant -> reader.getConfigValues(applicationVariant.getFlavorName()).forEach(configValue -> applicationVariant.buildConfigField(configValue.getType().getConfigString(), configValue.getKey(), configValue.getValue())));
    }
}

