/*
 * Decompiled with CFR 0.152.
 */
package burrows.api.finance.core;

import burrows.api.finance.model.RequestURLData;
import org.apache.commons.lang3.StringUtils;

public class RequestURLSerializer {
    private static final String YAHOO_FINANCE_BASE_URL = "http://download.finance.yahoo.com/d/quotes.csv?s=";
    private RequestURLData requestURLData;
    private StringBuilder requestURL = new StringBuilder();

    public RequestURLSerializer(RequestURLData requestURLData) {
        this.requestURLData = requestURLData;
    }

    public String getURL() {
        return this.requestURL.append(this.getCompany()).append(this.getFormat()).append(this.getQuotes()).toString();
    }

    private String getCompany() {
        switch (this.requestURLData.getCompany()) {
            default: {
                return YAHOO_FINANCE_BASE_URL;
            }
            case GOOGLE: 
        }
        throw new UnsupportedOperationException("Not supported.");
    }

    private String getFormat() {
        switch (this.requestURLData.getFormat()) {
            default: {
                break;
            }
            case XML: 
            case JSON: {
                throw new UnsupportedOperationException("Not supported.");
            }
        }
        return "";
    }

    private String getQuotes() {
        return StringUtils.join((Iterable)this.requestURLData.getQuotes(), (String)",");
    }
}

