/*
 * Decompiled with CFR 0.152.
 */
package burrows.api.finance.core;

import burrows.api.finance.core.RequestURLSerializer;
import burrows.api.finance.model.Company;
import burrows.api.finance.model.Format;
import burrows.api.finance.model.RequestURLData;
import java.util.Collection;

public class RequestURL {
    private RequestURL() {
    }

    public static ICompany Builder() {
        return new RequestBuilder();
    }

    private static class RequestBuilder
    implements ICompany,
    IFormat,
    IQuote,
    IBuild {
        final RequestURLData requestURLData = new RequestURLData();

        private RequestBuilder() {
        }

        @Override
        public IFormat withCompany(Company company) {
            this.requestURLData.setCompany(company);
            return this;
        }

        @Override
        public IQuote withFormat(Format format) {
            this.requestURLData.setFormat(format);
            return this;
        }

        @Override
        public IBuild addQuote(String quotes) {
            this.requestURLData.addQuote(quotes);
            return this;
        }

        @Override
        public IBuild addQuotes(Collection<String> quotes) {
            this.requestURLData.addQuotes(quotes);
            return this;
        }

        @Override
        public RequestURLData build() {
            return this.requestURLData;
        }

        @Override
        public String buildURL() {
            return new RequestURLSerializer(this.requestURLData).getURL();
        }
    }

    public static interface IBuild {
        public RequestURLData build();

        public String buildURL();
    }

    public static interface IQuote {
        public IBuild addQuote(String var1);

        public IBuild addQuotes(Collection<String> var1);
    }

    public static interface IFormat {
        public IQuote withFormat(Format var1);
    }

    public static interface ICompany {
        public IFormat withCompany(Company var1);
    }
}

