/*
 * Decompiled with CFR 0.152.
 */
package burrows.api.finance.core;

import burrows.api.finance.core.RequestURL;
import burrows.api.finance.model.Company;
import burrows.api.finance.model.Format;
import burrows.api.finance.model.RequestURLData;
import java.util.LinkedHashSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class RequestURLTest {
    private static final String YAHOO_FINANCE_BASE_URL = "http://download.finance.yahoo.com/d/quotes.csv?s=";

    @Test
    public void testYahooJSONQuote() {
        LinkedHashSet<String> quotes = new LinkedHashSet<String>();
        quotes.add("YHOO");
        RequestURLData requestURLData = RequestURL.Builder().withCompany(Company.YAHOO).withFormat(Format.JSON).addQuote("YHOO").build();
        MatcherAssert.assertThat((Object)requestURLData.getCompany(), (Matcher)Matchers.is((Object)Company.YAHOO));
        MatcherAssert.assertThat((Object)requestURLData.getFormat(), (Matcher)Matchers.is((Object)Format.JSON));
        MatcherAssert.assertThat((Object)requestURLData.getQuotes(), (Matcher)Matchers.is(quotes));
    }

    @Test
    public void testYahooJSONQuotes() {
        LinkedHashSet<String> quotes = new LinkedHashSet<String>();
        quotes.add("YHOO");
        quotes.add("GOOG");
        RequestURLData requestURLData = RequestURL.Builder().withCompany(Company.YAHOO).withFormat(Format.JSON).addQuotes(quotes).build();
        MatcherAssert.assertThat((Object)requestURLData.getCompany(), (Matcher)Matchers.is((Object)Company.YAHOO));
        MatcherAssert.assertThat((Object)requestURLData.getFormat(), (Matcher)Matchers.is((Object)Format.JSON));
        MatcherAssert.assertThat((Object)requestURLData.getQuotes(), (Matcher)Matchers.is(quotes));
    }

    @Test
    public void testYahooDefaultQuoteURL() {
        String requestURL = RequestURL.Builder().withCompany(Company.YAHOO).withFormat(Format.DEFAULT).addQuote("YHOO").buildURL();
        MatcherAssert.assertThat((Object)requestURL, (Matcher)Matchers.is((Object)"http://download.finance.yahoo.com/d/quotes.csv?s=YHOO"));
    }

    @Test
    public void testYahooDefaultQuotesURL() {
        LinkedHashSet<String> quotes = new LinkedHashSet<String>();
        quotes.add("YHOO");
        quotes.add("GOOG");
        String requestURL = RequestURL.Builder().withCompany(Company.YAHOO).withFormat(Format.DEFAULT).addQuotes(quotes).buildURL();
        MatcherAssert.assertThat((Object)requestURL, (Matcher)Matchers.is((Object)"http://download.finance.yahoo.com/d/quotes.csv?s=YHOO,GOOG"));
    }
}

