/*
 * Decompiled with CFR 0.152.
 */
package burrows.api.finance.core;

import burrows.api.finance.core.RequestURL;
import burrows.api.finance.core.RequestURLSerializer;
import burrows.api.finance.model.Company;
import burrows.api.finance.model.Format;
import burrows.api.finance.model.RequestURLData;
import java.util.LinkedHashSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class RequestURLSerializerTest {
    private static final String YAHOO_FINANCE_BASE_URL = "http://download.finance.yahoo.com/d/quotes.csv?s=";

    @Test
    public void testYahooJSONQuote() {
        RequestURLData requestURLData = RequestURL.Builder().withCompany(Company.YAHOO).withFormat(Format.DEFAULT).addQuote("YHOO").build();
        RequestURLSerializer requestURLSerializer = new RequestURLSerializer(requestURLData);
        MatcherAssert.assertThat((Object)requestURLSerializer.getURL(), (Matcher)Matchers.is((Object)"http://download.finance.yahoo.com/d/quotes.csv?s=YHOO"));
    }

    @Test
    public void testYahooJSONQuotes() {
        LinkedHashSet<String> quotes = new LinkedHashSet<String>();
        quotes.add("YHOO");
        quotes.add("GOOG");
        RequestURLData requestURLData = RequestURL.Builder().withCompany(Company.YAHOO).withFormat(Format.DEFAULT).addQuotes(quotes).build();
        RequestURLSerializer requestURLSerializer = new RequestURLSerializer(requestURLData);
        MatcherAssert.assertThat((Object)requestURLSerializer.getURL(), (Matcher)Matchers.is((Object)"http://download.finance.yahoo.com/d/quotes.csv?s=YHOO,GOOG"));
    }
}

