/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.builder.google;

import builders.dsl.spreadsheet.builder.api.SpreadsheetBuilder;
import builders.dsl.spreadsheet.builder.api.WorkbookDefinition;
import builders.dsl.spreadsheet.builder.poi.PoiSpreadsheetBuilder;
import builders.dsl.spreadsheet.google.GoogleSpreadsheets;
import com.google.api.client.http.HttpRequestInitializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;

public class GoogleSpreadsheetBuilder
implements SpreadsheetBuilder {
    private final String name;
    private final GoogleSpreadsheets spreadsheets;
    private final InputStream template;
    private String webLink;
    private String id;

    public static Builder builder(String name, HttpRequestInitializer credentials) {
        return GoogleSpreadsheetBuilder.builder(name, GoogleSpreadsheets.create(credentials));
    }

    public static Builder builder(String name, GoogleSpreadsheets spreadsheets) {
        return new Builder(name, spreadsheets);
    }

    private GoogleSpreadsheetBuilder(String id, String name, InputStream template, GoogleSpreadsheets spreadsheets) {
        this.id = id;
        this.name = name;
        this.template = template;
        this.spreadsheets = spreadsheets;
    }

    public void build(Consumer<WorkbookDefinition> workbookDefinition) {
        com.google.api.services.drive.model.File file = this.buildInternal(workbookDefinition);
        this.webLink = file.getWebViewLink();
        this.id = file.getId();
    }

    private com.google.api.services.drive.model.File buildInternal(Consumer<WorkbookDefinition> workbookDefinition) {
        if (this.template == null) {
            return this.spreadsheets.updateAndConvert(this.id, this.name, out -> PoiSpreadsheetBuilder.create((OutputStream)out).build(workbookDefinition));
        }
        return this.spreadsheets.updateAndConvert(this.id, this.name, out -> {
            try {
                PoiSpreadsheetBuilder.create((OutputStream)out, (InputStream)this.template).build(workbookDefinition);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Problem reading file's template from " + this.template, e);
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public String getWebLink() {
        return this.webLink;
    }

    public String getId() {
        return this.id;
    }

    public static class Builder {
        private final String name;
        private final GoogleSpreadsheets spreadsheets;
        private String id;
        private InputStream template;

        private Builder(String name, GoogleSpreadsheets spreadsheets) {
            this.name = name;
            this.spreadsheets = spreadsheets;
        }

        public Builder update(String spreadsheetID) {
            return this.id(spreadsheetID).template(spreadsheetID);
        }

        public Builder id(String spreadsheetID) {
            this.id = spreadsheetID;
            return this;
        }

        public Builder template(InputStream template) {
            this.template = template;
            return this;
        }

        public Builder template(String spreadsheetId) {
            this.template = this.spreadsheets.convertAndDownload(spreadsheetId);
            return this;
        }

        public Builder template(File file) throws FileNotFoundException {
            this.template = new FileInputStream(file);
            return this;
        }

        public GoogleSpreadsheetBuilder build() {
            return new GoogleSpreadsheetBuilder(this.id, this.name, this.template, this.spreadsheets);
        }
    }
}

