/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.builder.data;

import builders.dsl.spreadsheet.builder.api.LinkDefinition;
import builders.dsl.spreadsheet.builder.data.CellNode;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;

class LinkHelper
implements LinkDefinition {
    private final CellNode cell;

    LinkHelper(CellNode cell) {
        this.cell = cell;
    }

    public CellNode name(String name) {
        this.cell.node.set("link", name);
        return this.cell;
    }

    public CellNode email(String email) {
        this.cell.node.set("link", "mailto:" + email);
        return this.cell;
    }

    public CellNode email(Map<String, ?> parameters, String email) {
        try {
            ArrayList<String> params = new ArrayList<String>();
            for (Map.Entry<String, ?> parameter : parameters.entrySet()) {
                if (parameter.getValue() != null) {
                    params.add(URLEncoder.encode(parameter.getKey(), "UTF-8") + "=" + URLEncoder.encode(parameter.getValue().toString(), "UTF-8"));
                    continue;
                }
                params.add(URLEncoder.encode(parameter.getKey(), "UTF-8"));
            }
            this.cell.node.set("link", "mailto:" + email + "?" + String.join((CharSequence)"&", params));
            return this.cell;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public CellNode url(String url) {
        this.cell.node.set("link", url);
        return this.cell;
    }

    public CellNode file(String path) {
        this.cell.node.set("link", "file:" + path);
        return this.cell;
    }
}

