/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.builder.data;

import builders.dsl.spreadsheet.builder.api.CellDefinition;
import builders.dsl.spreadsheet.builder.api.ImageCreator;
import builders.dsl.spreadsheet.builder.data.CellNode;
import builders.dsl.spreadsheet.builder.data.MapNode;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;

class ImageHelper
implements ImageCreator {
    private final CellNode cellNode;
    private final String format;

    public ImageHelper(CellNode cellNode, String format) {
        this.cellNode = cellNode;
        this.format = format;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CellDefinition from(String fileOrUrl) {
        if (!fileOrUrl.startsWith("file://")) {
            MapNode mapNode = new MapNode();
            mapNode.set("type", this.format);
            mapNode.set("url", fileOrUrl);
            this.cellNode.node.set("image", mapNode);
            return this.cellNode;
        }
        try (FileInputStream fis = new FileInputStream(new File(new URI(fileOrUrl)));){
            CellDefinition cellDefinition = this.from(fis);
            return cellDefinition;
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException("Exception reading file: " + fileOrUrl, e);
        }
    }

    public CellDefinition from(InputStream stream) {
        return this.from(this.streamToBytes(stream));
    }

    public CellDefinition from(byte[] imageData) {
        return this.from("data:image/" + this.format + ";base64," + Base64.getEncoder().encodeToString(imageData));
    }

    private byte[] streamToBytes(InputStream is) {
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Exception reading image stream: " + is, e);
        }
    }
}

