/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.builder.data;

import builders.dsl.spreadsheet.api.Keywords;
import builders.dsl.spreadsheet.builder.api.PageDefinition;
import builders.dsl.spreadsheet.builder.api.RowDefinition;
import builders.dsl.spreadsheet.builder.api.SheetDefinition;
import builders.dsl.spreadsheet.builder.data.AbstractNode;
import builders.dsl.spreadsheet.builder.data.MapNode;
import builders.dsl.spreadsheet.builder.data.PageNode;
import builders.dsl.spreadsheet.builder.data.RowNode;
import java.util.Collections;
import java.util.function.Consumer;

class SheetNode
extends AbstractNode
implements SheetDefinition {
    public SheetNode(String name) {
        this.node.set("name", name);
    }

    public SheetNode() {
    }

    public SheetDefinition row(Consumer<RowDefinition> rowDefinition) {
        RowNode row = new RowNode();
        rowDefinition.accept(row);
        this.node.add("rows", row);
        return this;
    }

    public SheetDefinition row(int row, Consumer<RowDefinition> rowDefinition) {
        RowNode rowNode = new RowNode();
        rowNode.setNumber(row);
        rowDefinition.accept(rowNode);
        this.node.add("rows", rowNode);
        return this;
    }

    public SheetDefinition freeze(int column, int row) {
        MapNode freeze = new MapNode();
        freeze.set("column", column);
        freeze.set("row", row);
        this.node.set("freeze", freeze);
        return this;
    }

    public SheetDefinition group(Consumer<SheetDefinition> insideGroupDefinition) {
        SheetNode groupNode = new SheetNode();
        insideGroupDefinition.accept(groupNode);
        this.node.add("rows", Collections.singletonMap("group", groupNode.getContent().get("rows")));
        return this;
    }

    public SheetDefinition collapse(Consumer<SheetDefinition> insideGroupDefinition) {
        SheetNode collapse = new SheetNode();
        insideGroupDefinition.accept(collapse);
        this.node.add("rows", Collections.singletonMap("collapse", collapse.getContent().get("rows")));
        return this;
    }

    public SheetDefinition state(Keywords.SheetState state) {
        this.node.set("state", state);
        return this;
    }

    public SheetDefinition password(String password) {
        this.node.set("password", password);
        return this;
    }

    public SheetDefinition filter(Keywords.Auto auto) {
        this.node.set("filter", true);
        return this;
    }

    public SheetDefinition page(Consumer<PageDefinition> pageDefinition) {
        PageNode page = new PageNode();
        pageDefinition.accept(page);
        this.node.set("page", page);
        return this;
    }
}

