/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.builder.data;

import builders.dsl.spreadsheet.api.Color;
import builders.dsl.spreadsheet.api.ForegroundFill;
import builders.dsl.spreadsheet.api.Keywords;
import builders.dsl.spreadsheet.builder.api.BorderDefinition;
import builders.dsl.spreadsheet.builder.api.CellStyleDefinition;
import builders.dsl.spreadsheet.builder.api.FontDefinition;
import builders.dsl.spreadsheet.builder.data.AbstractNode;
import builders.dsl.spreadsheet.builder.data.BorderNode;
import builders.dsl.spreadsheet.builder.data.FontNode;
import builders.dsl.spreadsheet.builder.data.MapNode;
import java.util.Arrays;
import java.util.function.Consumer;

class CellStyleNode
extends AbstractNode
implements CellStyleDefinition {
    public CellStyleNode() {
    }

    public CellStyleNode(String name) {
        this.node.set("name", name);
    }

    public CellStyleDefinition base(String stylename) {
        this.node.set("base", stylename);
        return this;
    }

    public CellStyleDefinition background(String hexColor) {
        this.node.set("background", hexColor);
        return this;
    }

    public CellStyleDefinition background(Color color) {
        this.node.set("background", color.getHex());
        return this;
    }

    public CellStyleDefinition foreground(String hexColor) {
        this.node.set("foreground", hexColor);
        return this;
    }

    public CellStyleDefinition foreground(Color color) {
        this.node.set("foreground", color.getHex());
        return this;
    }

    public CellStyleDefinition fill(ForegroundFill fill) {
        this.node.set("fill", fill.name());
        return this;
    }

    public CellStyleDefinition font(Consumer<FontDefinition> fontConfiguration) {
        FontNode font = new FontNode();
        fontConfiguration.accept(font);
        this.node.set("font", font);
        return this;
    }

    public CellStyleDefinition indent(int indent) {
        this.node.set("indent", indent);
        return this;
    }

    public CellStyleDefinition wrap(Keywords.Text text) {
        this.node.set("wrap", true);
        return this;
    }

    public CellStyleDefinition rotation(int rotation) {
        this.node.set("rotation", rotation);
        return this;
    }

    public CellStyleDefinition format(String format) {
        this.node.set("format", format);
        return this;
    }

    public CellStyleDefinition align(Keywords.VerticalAlignment verticalAlignment, Keywords.HorizontalAlignment horizontalAlignment) {
        MapNode alignment = new MapNode();
        if (verticalAlignment != null) {
            alignment.set("vertical", verticalAlignment);
        }
        if (horizontalAlignment != null) {
            alignment.set("horizontal", horizontalAlignment);
        }
        this.node.set("align", alignment);
        return this;
    }

    public CellStyleDefinition border(Consumer<BorderDefinition> borderConfiguration) {
        return this.borders(borderConfiguration, new Keywords.BorderSide[0]);
    }

    public CellStyleDefinition border(Keywords.BorderSide location, Consumer<BorderDefinition> borderConfiguration) {
        return this.borders(borderConfiguration, location);
    }

    public CellStyleDefinition border(Keywords.BorderSide first, Keywords.BorderSide second, Consumer<BorderDefinition> borderConfiguration) {
        return this.borders(borderConfiguration, first, second);
    }

    public CellStyleDefinition border(Keywords.BorderSide first, Keywords.BorderSide second, Keywords.BorderSide third, Consumer<BorderDefinition> borderConfiguration) {
        return this.borders(borderConfiguration, first, second, third);
    }

    private CellStyleDefinition borders(Consumer<BorderDefinition> borderDefinition, Keywords.BorderSide ... borders) {
        BorderNode borderNode = new BorderNode();
        borderDefinition.accept(borderNode);
        if (borders.length > 0) {
            borderNode.setSide(Arrays.asList(borders));
        }
        this.node.add("borders", borderNode);
        return this;
    }
}

