/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.builder.data;

import builders.dsl.spreadsheet.api.Keywords;
import builders.dsl.spreadsheet.builder.api.CellDefinition;
import builders.dsl.spreadsheet.builder.api.CellStyleDefinition;
import builders.dsl.spreadsheet.builder.api.CommentDefinition;
import builders.dsl.spreadsheet.builder.api.DimensionModifier;
import builders.dsl.spreadsheet.builder.api.FontDefinition;
import builders.dsl.spreadsheet.builder.api.ImageCreator;
import builders.dsl.spreadsheet.builder.api.LinkDefinition;
import builders.dsl.spreadsheet.builder.data.AbstractNode;
import builders.dsl.spreadsheet.builder.data.CellStyleNode;
import builders.dsl.spreadsheet.builder.data.CommentNode;
import builders.dsl.spreadsheet.builder.data.FontNode;
import builders.dsl.spreadsheet.builder.data.ImageHelper;
import builders.dsl.spreadsheet.builder.data.LinkHelper;
import builders.dsl.spreadsheet.builder.data.LiteralDimensionModifier;
import builders.dsl.spreadsheet.builder.data.MapNode;
import java.util.Date;
import java.util.function.Consumer;

class CellNode
extends AbstractNode
implements CellDefinition {
    CellNode() {
    }

    public CellDefinition value(Object value) {
        if (value instanceof Date) {
            this.node.set("value", ((Date)value).toInstant().toString());
            return this;
        }
        this.node.set("value", value);
        return this;
    }

    public CellDefinition name(String name) {
        this.node.set("name", name);
        return this;
    }

    public CellDefinition formula(String formula) {
        this.node.set("formula", formula);
        return this;
    }

    public CellDefinition comment(Consumer<CommentDefinition> commentDefinition) {
        CommentNode commentNode = new CommentNode();
        commentDefinition.accept(commentNode);
        this.node.set("comment", commentNode);
        return this;
    }

    public LinkDefinition link(Keywords.To to) {
        return new LinkHelper(this);
    }

    public CellDefinition colspan(int span) {
        this.node.set("colspan", span);
        return this;
    }

    public CellDefinition rowspan(int span) {
        this.node.set("rowspan", span);
        return this;
    }

    public DimensionModifier width(double width) {
        this.node.set("width", width);
        return new LiteralDimensionModifier(this, width, "width");
    }

    public DimensionModifier height(double height) {
        this.node.set("height", height);
        return new LiteralDimensionModifier(this, height, "height");
    }

    public CellDefinition width(Keywords.Auto auto) {
        this.node.set("width", "auto");
        return this;
    }

    public CellDefinition text(String text) {
        this.node.add("text", text);
        return this;
    }

    public CellDefinition text(String text, Consumer<FontDefinition> fontConfiguration) {
        FontNode fontNode = new FontNode();
        fontConfiguration.accept(fontNode);
        MapNode mapNode = new MapNode();
        mapNode.set("content", text);
        mapNode.set("font", fontNode);
        this.node.add("text", mapNode);
        return this;
    }

    public ImageCreator png(Keywords.Image image) {
        return new ImageHelper(this, "png");
    }

    public ImageCreator jpeg(Keywords.Image image) {
        return new ImageHelper(this, "jpeg");
    }

    public ImageCreator pict(Keywords.Image image) {
        return new ImageHelper(this, "pict");
    }

    public ImageCreator emf(Keywords.Image image) {
        return new ImageHelper(this, "emf");
    }

    public ImageCreator wmf(Keywords.Image image) {
        return new ImageHelper(this, "wmf");
    }

    public ImageCreator dib(Keywords.Image image) {
        return new ImageHelper(this, "dib");
    }

    public CellDefinition styles(Iterable<String> styles, Iterable<Consumer<CellStyleDefinition>> styleDefinitions) {
        for (String string : styles) {
            this.node.add("styles", string);
        }
        for (Consumer consumer : styleDefinitions) {
            CellStyleNode cellStyleNode = new CellStyleNode();
            consumer.accept(cellStyleNode);
            this.node.add("styles", cellStyleNode);
        }
        return this;
    }

    public void setColumn(int column) {
        this.node.set("column", column);
    }
}

