/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.parser.data;

import builders.dsl.spreadsheet.api.BorderStyle;
import builders.dsl.spreadsheet.api.Color;
import builders.dsl.spreadsheet.api.FontStyle;
import builders.dsl.spreadsheet.api.ForegroundFill;
import builders.dsl.spreadsheet.api.Keywords;
import builders.dsl.spreadsheet.builder.api.BorderDefinition;
import builders.dsl.spreadsheet.builder.api.CellDefinition;
import builders.dsl.spreadsheet.builder.api.CellStyleDefinition;
import builders.dsl.spreadsheet.builder.api.CommentDefinition;
import builders.dsl.spreadsheet.builder.api.DimensionModifier;
import builders.dsl.spreadsheet.builder.api.FontDefinition;
import builders.dsl.spreadsheet.builder.api.HasStyle;
import builders.dsl.spreadsheet.builder.api.ImageCreator;
import builders.dsl.spreadsheet.builder.api.PageDefinition;
import builders.dsl.spreadsheet.builder.api.RowDefinition;
import builders.dsl.spreadsheet.builder.api.SheetDefinition;
import builders.dsl.spreadsheet.builder.api.SpreadsheetBuilder;
import builders.dsl.spreadsheet.builder.api.WorkbookDefinition;
import builders.dsl.spreadsheet.parser.data.InvalidPropertyException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataSpreadsheetParser {
    private static final List<String> REQUIRES_NAME = Collections.singletonList("name");
    private static final Pattern DIMENSION_IN_POINTS = Pattern.compile("(\\d+)\\s?(p(oin)?ts?)?");
    private static final Pattern DIMENSION_IN_CM = Pattern.compile("(\\d+)\\s?cm");
    private static final Pattern DIMENSION_IN_INCHES = Pattern.compile("(\\d+)\\s?in(ch(es)?)?");
    private static final Pattern ISO_DATE_PATTERN = Pattern.compile("^(?:[1-9]\\d{3}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1\\d|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[1-9]\\d(?:0[48]|[2468][048]|[13579][26])|(?:[2468][048]|[13579][26])00)-02-29)T(?:[01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(?:\\.\\d{1,9})?(?:Z|[+-][01]\\d:[0-5]\\d)$");
    private final SpreadsheetBuilder builder;

    public DataSpreadsheetParser(SpreadsheetBuilder builder) {
        this.builder = builder;
    }

    private static <T> void doSafe(String entryPath, T value, Consumer<T> operation) {
        try {
            operation.accept(value);
        }
        catch (InvalidPropertyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidPropertyException(e, entryPath, value);
        }
    }

    private void handleNumber(String path, Object value, Consumer<Number> consumer) {
        if (value instanceof Number) {
            consumer.accept((Number)value);
            return;
        }
        throw new InvalidPropertyException("Value must be number", path, value);
    }

    private void handleBoolean(String path, Object value, Consumer<Boolean> consumer) {
        if (value instanceof Boolean) {
            consumer.accept((Boolean)value);
            return;
        }
        throw new InvalidPropertyException("Value must be boolean", path, value);
    }

    private void ifTrue(String path, Object value, Runnable runnable) {
        this.handleBoolean(path, value, bool -> {
            if (bool.booleanValue()) {
                runnable.run();
            }
        });
    }

    private static void eachItemWithIndex(Object value, String path, BiConsumer<Object, Integer> consumer) {
        if (!(value instanceof Iterable)) {
            throw new InvalidPropertyException("Value must be iterable!", path, value);
        }
        Iterable iterable = (Iterable)value;
        int index = 0;
        for (Object item : iterable) {
            consumer.accept(item, index++);
        }
    }

    private static void eachItemWithPath(Object value, String path, BiConsumer<Object, String> consumer) {
        DataSpreadsheetParser.eachItemWithIndex(value, path, (item, index) -> {
            String itemPath = path + "[" + index + "]";
            consumer.accept(item, itemPath);
        });
    }

    private static void withMap(Object value, String path, Consumer<Map<String, Object>> consumer) {
        DataSpreadsheetParser.withMap(value, path, Collections.emptyList(), consumer);
    }

    private static void withMap(Object value, String path, Iterable<String> requiredProperties, Consumer<Map<String, Object>> consumer) {
        DataSpreadsheetParser.withMap(value, path, requiredProperties, (Map<String, Object> map, String localPath) -> consumer.accept((Map<String, Object>)map));
    }

    private static void withMap(Object value, String path, Iterable<String> requiredProperties, BiConsumer<Map<String, Object>, String> consumer) {
        if (!(value instanceof Map)) {
            throw new InvalidPropertyException("Definition must be map", path, value);
        }
        Map map = (Map)value;
        for (String requiredProperty : requiredProperties) {
            if (map.containsKey(requiredProperty)) continue;
            throw new InvalidPropertyException("Definition is missing '" + requiredProperty + "' property", path, value);
        }
        DataSpreadsheetParser.doSafe(path, map, v -> consumer.accept(DataSpreadsheetParser.checkedMap(v), path));
    }

    private static void handleMap(String path, Map<String, Object> map, MapEntryHandler handler) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String entryPath = path + "." + entry.getKey();
            DataSpreadsheetParser.doSafe(entryPath, entry.getValue(), value -> handler.handle(entryPath, (String)entry.getKey(), entry.getValue()));
        }
    }

    private static Map<String, Object> checkedMap(Map map) {
        return Collections.checkedMap(map, String.class, Object.class);
    }

    private static void eachItemAsMap(Object value, String path, Iterable<String> requiredProperties, BiConsumer<Map<String, Object>, String> consumer) {
        DataSpreadsheetParser.eachItemWithPath(value, path, (item, itemPath) -> DataSpreadsheetParser.withMap(item, itemPath, requiredProperties, (Map<String, Object> map) -> consumer.accept((Map<String, Object>)map, (String)itemPath)));
    }

    public void build(Iterable<Map<String, Object>> value) {
        this.build(Collections.singletonMap("sheets", value));
    }

    public void build(Map<String, Object> definitionMap) {
        this.builder.build(w -> this.handleWorkbook((WorkbookDefinition)w, definitionMap));
    }

    public void build(Object value) {
        if (value == null) {
            throw new InvalidPropertyException("No Data", "", null);
        }
        if (value instanceof Map) {
            this.build((Map)value);
        } else if (value instanceof Iterable) {
            this.build((Iterable)value);
        } else {
            throw new InvalidPropertyException("Unsupported definition type (" + value.getClass() + "): ", "", value);
        }
    }

    private void handleWorkbook(WorkbookDefinition w, Map<String, Object> definitionMap) {
        block8: for (Map.Entry<String, Object> entry : definitionMap.entrySet()) {
            switch (entry.getKey()) {
                case "styles": {
                    DataSpreadsheetParser.eachItemAsMap(entry.getValue(), entry.getKey(), REQUIRES_NAME, (map, localPath) -> w.style(String.valueOf(map.get("name")), s -> this.handleStyle((CellStyleDefinition)s, (String)localPath, (Map<String, Object>)map)));
                    continue block8;
                }
                case "sheets": {
                    DataSpreadsheetParser.eachItemWithPath(entry.getValue(), entry.getKey(), (item, itemPath) -> {
                        if (item instanceof Map) {
                            DataSpreadsheetParser.withMap(item, itemPath, REQUIRES_NAME, (Map<String, Object> sheet) -> this.handleSheet(w, (String)itemPath, (Map<String, Object>)sheet));
                        } else {
                            HashMap<String, Object> sheet2 = new HashMap<String, Object>();
                            sheet2.put("rows", item);
                            sheet2.put("name", "Sheet1");
                            this.handleSheet(w, (String)itemPath, (Map<String, Object>)sheet2);
                        }
                    });
                    continue block8;
                }
            }
            throw new InvalidPropertyException("Unknown property: " + entry.getKey(), entry.getKey(), entry.getValue());
        }
    }

    private void handleSheet(WorkbookDefinition w, String localPath, Map<String, Object> map) {
        w.sheet(String.valueOf(map.get("name")), s -> this.handleSheet((SheetDefinition)s, localPath, map));
    }

    private void handleSheet(SheetDefinition s, String path, Map<String, Object> map) {
        DataSpreadsheetParser.handleMap(path, map, (entryPath, key, value) -> {
            switch (key) {
                case "rows": {
                    this.handleRows(s, path, value);
                    break;
                }
                case "filter": {
                    this.ifTrue(entryPath, value, () -> s.filter(Keywords.Auto.AUTO));
                    break;
                }
                case "freeze": {
                    this.handleFreeze(s, entryPath, value);
                    break;
                }
                case "page": {
                    DataSpreadsheetParser.withMap(value, entryPath, page -> s.page(p -> this.handlePage((PageDefinition)p, entryPath, (Map<String, Object>)page)));
                    break;
                }
                case "password": {
                    s.password(String.valueOf(value));
                    break;
                }
                case "state": {
                    this.handleState(s, value);
                    break;
                }
                case "name": {
                    break;
                }
                default: {
                    throw new InvalidPropertyException("Unknown property: " + key, path, value);
                }
            }
        });
    }

    private void handleState(SheetDefinition s, Object value) {
        s.state(Keywords.SheetState.valueOf((String)this.asEnumName(value)));
    }

    private void handleRows(SheetDefinition s, String path, Object value) {
        DataSpreadsheetParser.eachItemWithPath(value, path, (item, itemPath) -> {
            if (item instanceof Map) {
                DataSpreadsheetParser.withMap(item, itemPath, Collections.emptyList(), (Map<String, Object> row) -> this.handleRow(s, (String)itemPath, (Map<String, Object>)row));
            } else if (item instanceof Iterable) {
                this.handleRow(s, (String)itemPath, Collections.singletonMap("cells", item));
            }
        });
    }

    private void handlePage(PageDefinition p, String path, Map<String, Object> page) {
        DataSpreadsheetParser.handleMap(path, page, (entryPath, key, value) -> {
            switch (key) {
                case "fit": {
                    DataSpreadsheetParser.withMap(value, entryPath, fit -> this.handlePageFit(p, entryPath, (Map<String, Object>)fit));
                    break;
                }
                case "orientation": {
                    this.handlePageOrientation(p, value);
                    break;
                }
                case "paper": {
                    this.handlePagePaper(p, value);
                    break;
                }
                default: {
                    throw new InvalidPropertyException("Unknown property: " + key, path, value);
                }
            }
        });
    }

    private void handlePagePaper(PageDefinition p, Object value) {
        p.paper(Keywords.Paper.valueOf((String)this.asEnumName(value)));
    }

    private void handlePageOrientation(PageDefinition p, Object value) {
        p.orientation(Keywords.Orientation.valueOf((String)this.asEnumName(value)));
    }

    private void handlePageFit(PageDefinition p, String path, Map<String, Object> fit) {
        DataSpreadsheetParser.handleMap(path, fit, (entryPath, key, value) -> {
            switch (key) {
                case "width": {
                    this.handleNumber(entryPath, value, number -> p.fit(Keywords.Fit.WIDTH).to(number.intValue()));
                    break;
                }
                case "height": {
                    this.handleNumber(entryPath, value, number -> p.fit(Keywords.Fit.HEIGHT).to(number.intValue()));
                    break;
                }
                default: {
                    throw new InvalidPropertyException("Unknown property: " + key, path, value);
                }
            }
        });
    }

    private void handleFreeze(SheetDefinition s, String path, Object freeze) {
        AtomicInteger row = new AtomicInteger(0);
        AtomicInteger column = new AtomicInteger(0);
        AtomicReference columnAsString = new AtomicReference();
        DataSpreadsheetParser.withMap(freeze, path, map -> DataSpreadsheetParser.handleMap(path, map, (entryPath, key, value) -> {
            switch (key) {
                case "row": {
                    this.handleNumber(entryPath, value, number -> row.set(number.intValue()));
                    break;
                }
                case "column": {
                    if (value instanceof Number) {
                        this.handleNumber(entryPath, value, number -> column.set(number.intValue()));
                        break;
                    }
                    columnAsString.set(String.valueOf(value));
                    break;
                }
                default: {
                    throw new InvalidPropertyException("Unknown property: " + key, path, value);
                }
            }
        }));
        if (columnAsString.get() != null) {
            s.freeze((String)columnAsString.get(), row.get());
        } else {
            s.freeze(column.get(), row.get());
        }
    }

    private void handleRow(SheetDefinition s, String path, Map<String, Object> row) {
        if (row.containsKey("group") && row.size() == 1) {
            s.group(group -> DataSpreadsheetParser.eachItemAsMap(row.get("group"), path + ".group", Collections.emptyList(), (item, itemPath) -> this.handleRow((SheetDefinition)group, (String)itemPath, (Map<String, Object>)item)));
        } else if (row.containsKey("collapse") && row.size() == 1) {
            s.collapse(collapse -> DataSpreadsheetParser.eachItemAsMap(row.get("collapse"), path + ".collapse", Collections.emptyList(), (item, itemPath) -> this.handleRow((SheetDefinition)collapse, (String)itemPath, (Map<String, Object>)item)));
        } else if (row.containsKey("number")) {
            this.handleNumber(path, row.get("number"), number -> s.row(number.intValue(), r -> this.handleRow((RowDefinition)r, path, row)));
        } else {
            s.row(r -> this.handleRow((RowDefinition)r, path, row));
        }
    }

    private void handleRow(RowDefinition r, String path, Map<String, Object> map) {
        DataSpreadsheetParser.handleMap(path, map, (entryPath, key, value) -> {
            switch (key) {
                case "styles": {
                    this.handleStyles((HasStyle)r, entryPath, value);
                    break;
                }
                case "cells": {
                    DataSpreadsheetParser.eachItemWithPath(value, entryPath, (item, itemPath) -> this.handleCell(r, (String)itemPath, item));
                    break;
                }
                case "number": {
                    break;
                }
                default: {
                    throw new InvalidPropertyException("Unknown property: " + key, path, value);
                }
            }
        });
    }

    private void handleCell(RowDefinition r, String itemPath, Object item) {
        if (item instanceof Map) {
            DataSpreadsheetParser.withMap(item, itemPath, map -> this.handleCellFromMap(r, itemPath, (Map<String, Object>)map));
        } else {
            r.cell(c -> this.handleCellValue((CellDefinition)c, item));
        }
    }

    private void handleCellFromMap(RowDefinition r, String path, Map<String, Object> map) {
        if (map.containsKey("group") && map.size() == 1) {
            r.group(group -> DataSpreadsheetParser.eachItemWithPath(map.get("group"), path + ".group", (item, itemPath) -> this.handleCell((RowDefinition)group, (String)itemPath, item)));
        } else if (map.containsKey("collapse") && map.size() == 1) {
            r.collapse(collapse -> DataSpreadsheetParser.eachItemWithPath(map.get("collapse"), path + ".collapse", (item, itemPath) -> this.handleCell((RowDefinition)collapse, (String)itemPath, item)));
        } else if (map.containsKey("column")) {
            Object column = map.get("column");
            if (column instanceof Number) {
                this.handleNumber(path, column, number -> r.cell(number.intValue(), c -> this.handleCell((CellDefinition)c, path, map)));
            } else {
                r.cell(String.valueOf(column), c -> this.handleCell((CellDefinition)c, path, map));
            }
        } else {
            r.cell(c -> this.handleCell((CellDefinition)c, path, map));
        }
    }

    private void handleCell(CellDefinition c, String path, Map<String, Object> map) {
        DataSpreadsheetParser.handleMap(path, map, (entryPath, key, value) -> {
            switch (key) {
                case "value": {
                    this.handleCellValue(c, value);
                    break;
                }
                case "name": {
                    this.handleCellName(c, value);
                    break;
                }
                case "formula": {
                    this.handleCellFormula(c, value);
                    break;
                }
                case "comment": {
                    this.handleCellComment(c, entryPath, value);
                    break;
                }
                case "link": {
                    this.handleCellLink(c, entryPath, value);
                    break;
                }
                case "colspan": {
                    this.handleCellColspan(c, entryPath, value);
                    break;
                }
                case "rowspan": {
                    this.handleCellRowspan(c, entryPath, value);
                    break;
                }
                case "width": {
                    this.handleCellWidth(c, entryPath, value);
                    break;
                }
                case "height": {
                    this.handleCellHeight(c, entryPath, value);
                    break;
                }
                case "text": {
                    this.handleCellText(c, entryPath, value);
                    break;
                }
                case "styles": {
                    this.handleStyles((HasStyle)c, entryPath, value);
                    break;
                }
                case "image": {
                    this.handleCellImage(c, entryPath, value);
                    break;
                }
                case "column": {
                    break;
                }
                default: {
                    throw new InvalidPropertyException("Unknown property: " + key, path, value);
                }
            }
        });
    }

    private void handleCellText(CellDefinition c, String entryPath, Object value) {
        if (value instanceof Iterable) {
            DataSpreadsheetParser.eachItemWithPath(value, entryPath, (item, itemPath) -> {
                if (item instanceof Map) {
                    DataSpreadsheetParser.withMap(item, itemPath, Collections.singletonList("content"), (Map<String, Object> map) -> {
                        Object font = map.get("font");
                        String content = String.valueOf(map.get("content"));
                        if (font == null) {
                            c.text(content);
                        } else {
                            String fontPath = itemPath + ".font";
                            DataSpreadsheetParser.withMap(font, fontPath, fontMap -> c.text(content, f -> this.handleFont((FontDefinition)f, fontPath, (Map<String, Object>)fontMap)));
                        }
                    });
                } else {
                    c.text(String.valueOf(item));
                }
            });
        } else {
            c.value(value);
        }
    }

    private void handleCellImage(CellDefinition c, String path, Object image) {
        LinkedHashMap<String, Function<Keywords.Image, ImageCreator>> imageCreators = new LinkedHashMap<String, Function<Keywords.Image, ImageCreator>>();
        imageCreators.put("png", arg_0 -> ((CellDefinition)c).png(arg_0));
        imageCreators.put("jpeg", arg_0 -> ((CellDefinition)c).jpeg(arg_0));
        imageCreators.put("jpg", arg_0 -> ((CellDefinition)c).jpeg(arg_0));
        imageCreators.put("pict", arg_0 -> ((CellDefinition)c).pict(arg_0));
        imageCreators.put("emf", arg_0 -> ((CellDefinition)c).emf(arg_0));
        imageCreators.put("wmf", arg_0 -> ((CellDefinition)c).wmf(arg_0));
        imageCreators.put("dib", arg_0 -> ((CellDefinition)c).dib(arg_0));
        if (image instanceof Map) {
            DataSpreadsheetParser.withMap(image, path, Arrays.asList("url", "type"), (Map<String, Object> map) -> {
                String type = String.valueOf(map.get("type")).toLowerCase();
                String url = String.valueOf(map.get("url"));
                if (!imageCreators.containsKey(type)) {
                    throw new InvalidPropertyException("Unknown image type", path + ".type", (Object)type);
                }
                try {
                    new URL(url);
                }
                catch (MalformedURLException e) {
                    throw new InvalidPropertyException("Malformed image URL", path + ".url", (Object)url);
                }
                ((ImageCreator)((Function)imageCreators.get(type)).apply(Keywords.Image.IMAGE)).from(url);
            });
            return;
        }
        String url = String.valueOf(image);
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            throw new InvalidPropertyException("Malformed image URL", path, (Object)url);
        }
        String lowerCase = url.toLowerCase();
        boolean linkCreated = false;
        for (String extension : imageCreators.keySet()) {
            if (!lowerCase.endsWith(extension)) continue;
            ((ImageCreator)((Function)imageCreators.get(extension)).apply(Keywords.Image.IMAGE)).from(url);
            linkCreated = true;
            break;
        }
        if (!linkCreated) {
            throw new InvalidPropertyException("Could not determine image type. Please be sure that the URL ends with one of following extensions: " + String.join((CharSequence)",", imageCreators.keySet()), path, (Object)url);
        }
    }

    private void handleCellLink(CellDefinition c, String path, Object value) {
        String link = String.valueOf(value);
        try {
            URI uri = new URI(link);
            if ("http".equals(uri.getScheme()) || "https".equals(uri.getScheme())) {
                c.link(Keywords.To.TO).url(link);
            } else if ("mailto".equals(uri.getScheme())) {
                c.link(Keywords.To.TO).email(link.substring(7));
            } else if ("file".equals(uri.getScheme())) {
                c.link(Keywords.To.TO).file(link.substring(5));
            } else {
                c.link(Keywords.To.TO).name(link);
            }
        }
        catch (URISyntaxException e) {
            throw new InvalidPropertyException("Invalid link format", (Throwable)e, path, value);
        }
    }

    private void handleCellComment(CellDefinition c, String entryPath, Object value) {
        if (value instanceof String) {
            c.comment((String)value);
        } else {
            c.comment(comment -> DataSpreadsheetParser.withMap(value, entryPath, map -> this.handleCellComment((CommentDefinition)comment, entryPath, (Map<String, Object>)map)));
        }
    }

    private void handleCellComment(CommentDefinition c, String path, Map<String, Object> map) {
        DataSpreadsheetParser.handleMap(path, map, (entryPath, key, value) -> {
            switch (key) {
                case "author": {
                    c.author(String.valueOf(value));
                    break;
                }
                case "text": {
                    c.text(String.valueOf(value));
                    break;
                }
                default: {
                    throw new InvalidPropertyException("Unknown property: " + key, path, value);
                }
            }
        });
    }

    private void handleCellWidth(CellDefinition c, String path, Object value) {
        if ("auto".equals(value)) {
            c.width(Keywords.Auto.AUTO);
        } else {
            this.handleDimension(value, path, arg_0 -> ((CellDefinition)c).width(arg_0));
        }
    }

    private void handleDimension(Object value, String path, Function<Double, DimensionModifier> dimensionSetter) {
        if (value instanceof Number) {
            dimensionSetter.apply(((Number)value).doubleValue());
        } else {
            String dimension = String.valueOf(value);
            Matcher cmMatcher = DIMENSION_IN_CM.matcher(dimension);
            Matcher inchMatcher = DIMENSION_IN_INCHES.matcher(dimension);
            Matcher pointMatcher = DIMENSION_IN_POINTS.matcher(dimension);
            if (cmMatcher.matches()) {
                dimensionSetter.apply(Double.valueOf(cmMatcher.group(1))).cm();
            } else if (inchMatcher.matches()) {
                dimensionSetter.apply(Double.valueOf(inchMatcher.group(1))).inch();
            } else if (pointMatcher.matches()) {
                dimensionSetter.apply(Double.valueOf(pointMatcher.group(1)));
            } else {
                throw new InvalidPropertyException("Invalid dimension format", path, value);
            }
        }
    }

    private void handleCellHeight(CellDefinition c, String path, Object value) {
        this.handleDimension(value, path, arg_0 -> ((CellDefinition)c).height(arg_0));
    }

    private void handleCellColspan(CellDefinition c, String path, Object value) {
        this.handleNumber(path, value, number -> c.colspan(number.intValue()));
    }

    private void handleCellRowspan(CellDefinition c, String path, Object value) {
        this.handleNumber(path, value, number -> c.rowspan(number.intValue()));
    }

    private void handleCellFormula(CellDefinition c, Object value) {
        c.formula(String.valueOf(value));
    }

    private void handleCellName(CellDefinition c, Object value) {
        c.name(String.valueOf(value));
    }

    private void handleCellValue(CellDefinition c, Object value) {
        if (value instanceof String && ISO_DATE_PATTERN.matcher((String)value).matches()) {
            c.value((Object)Date.from(ZonedDateTime.parse((String)value, DateTimeFormatter.ISO_DATE_TIME).toInstant()));
            return;
        }
        c.value(value);
    }

    private void handleStyles(HasStyle r, String path, Object value) {
        ArrayList styles = new ArrayList();
        ArrayList stylesDefinitions = new ArrayList();
        DataSpreadsheetParser.eachItemWithPath(value, path, (item, itemPath) -> {
            if (item instanceof String) {
                styles.add((String)item);
            } else {
                DataSpreadsheetParser.withMap(item, itemPath, map -> stylesDefinitions.add(style -> this.handleStyle((CellStyleDefinition)style, (String)itemPath, (Map<String, Object>)map)));
            }
        });
        r.styles(styles, stylesDefinitions);
    }

    private void handleFont(FontDefinition f, String path, Map<String, Object> map) {
        DataSpreadsheetParser.handleMap(path, map, (entryPath, key, value) -> {
            switch (key) {
                case "color": {
                    this.handleFontColor(entryPath, f, value);
                    break;
                }
                case "size": {
                    this.handleFontSize(f, entryPath, value);
                    break;
                }
                case "style": {
                    this.handleFontStyle(f, value);
                    break;
                }
                case "styles": {
                    DataSpreadsheetParser.eachItemWithPath(value, entryPath, (item, itemPath) -> this.handleFontStyle(f, item));
                    break;
                }
                case "name": {
                    this.handleFontName(f, value);
                    break;
                }
                case "content": {
                    break;
                }
                default: {
                    throw new InvalidPropertyException("Unknown property: " + key, path, value);
                }
            }
        });
    }

    private void handleFontStyle(FontDefinition f, Object value) {
        f.style(FontStyle.valueOf((String)this.asEnumName(value)), new FontStyle[0]);
    }

    private void handleFontName(FontDefinition f, Object value) {
        f.name(String.valueOf(value));
    }

    private void handleFontSize(FontDefinition f, String path, Object value) {
        this.handleNumber(path, value, number -> f.size(number.intValue()));
    }

    private void handleFontColor(String path, FontDefinition f, Object value) {
        this.handleColor(path, value, arg_0 -> ((FontDefinition)f).color(arg_0), arg_0 -> ((FontDefinition)f).color(arg_0));
    }

    private void handleColor(String path, Object value, Consumer<String> hexColorConsumer, Consumer<Color> colorConsumer) {
        String color = String.valueOf(value);
        if (color.startsWith("#")) {
            hexColorConsumer.accept(color);
        } else {
            colorConsumer.accept(this.readFakeEnumValue(path, color, Color.class, true));
        }
    }

    private void handleBorder(BorderDefinition b, String path, Map<String, Object> map) {
        DataSpreadsheetParser.handleMap(path, map, (entryPath, key, value) -> {
            switch (key) {
                case "style": {
                    this.handleBorderStyle(b, value);
                    break;
                }
                case "color": {
                    this.handleBorderColor(entryPath, b, value);
                    break;
                }
                case "side": {
                    break;
                }
                default: {
                    throw new InvalidPropertyException("Unknown property: " + key, path, value);
                }
            }
        });
    }

    private void handleBorderColor(String path, BorderDefinition b, Object value) {
        this.handleColor(path, value, arg_0 -> ((BorderDefinition)b).color(arg_0), arg_0 -> ((BorderDefinition)b).color(arg_0));
    }

    private void handleBorderStyle(BorderDefinition b, Object value) {
        b.style(BorderStyle.valueOf((String)this.asEnumName(value)));
    }

    private void handleBorder(CellStyleDefinition s, String path, Map<String, Object> map) {
        String key = "side";
        if (!map.containsKey(key)) {
            s.border(b -> this.handleBorder((BorderDefinition)b, path, map));
            return;
        }
        ArrayList sides = new ArrayList();
        List<Object> value = map.get(key);
        if (!(value instanceof Iterable)) {
            value = Collections.singletonList(value);
        }
        DataSpreadsheetParser.eachItemWithIndex(value, path + "." + key, (item, index) -> sides.add(this.readFakeEnumValue(path + "." + key + "[" + index + "]", item, Keywords.BorderSide.class)));
        if (sides.size() == 4 || sides.isEmpty()) {
            s.border(b -> this.handleBorder((BorderDefinition)b, path, map));
        } else if (sides.size() == 3) {
            s.border((Keywords.BorderSide)sides.get(0), (Keywords.BorderSide)sides.get(1), (Keywords.BorderSide)sides.get(2), b -> this.handleBorder((BorderDefinition)b, path, map));
        } else if (sides.size() == 2) {
            s.border((Keywords.BorderSide)sides.get(0), (Keywords.BorderSide)sides.get(1), b -> this.handleBorder((BorderDefinition)b, path, map));
        } else if (sides.size() == 1) {
            s.border((Keywords.BorderSide)sides.get(0), b -> this.handleBorder((BorderDefinition)b, path, map));
        }
    }

    private void handleStyle(CellStyleDefinition s, String path, Map<String, Object> map) {
        DataSpreadsheetParser.handleMap(path, map, (entryPath, key, value) -> {
            switch (key) {
                case "align": {
                    this.handleAlign(s, entryPath, value);
                    break;
                }
                case "background": {
                    this.handleBackground(entryPath, s, value);
                    break;
                }
                case "base": {
                    this.handleBase(s, value);
                    break;
                }
                case "borders": {
                    DataSpreadsheetParser.eachItemAsMap(value, entryPath, Collections.emptyList(), (border, localPath) -> this.handleBorder(s, (String)localPath, (Map<String, Object>)border));
                    break;
                }
                case "fill": {
                    this.handleFill(s, value);
                    break;
                }
                case "font": {
                    DataSpreadsheetParser.withMap(value, entryPath, Collections.emptyList(), (Map<String, Object> font, String localPath) -> s.font(f -> this.handleFont((FontDefinition)f, (String)localPath, (Map<String, Object>)font)));
                    break;
                }
                case "foreground": {
                    this.handleForeground(entryPath, s, value);
                    break;
                }
                case "format": {
                    this.handleFormat(s, value);
                    break;
                }
                case "indent": {
                    this.handleIndent(s, entryPath, value);
                    break;
                }
                case "rotation": {
                    this.handleRotation(s, entryPath, value);
                    break;
                }
                case "wrap": {
                    this.handleWrap(s, entryPath, value);
                    break;
                }
                case "name": {
                    break;
                }
                default: {
                    throw new InvalidPropertyException("Unknown property: " + key, path, value);
                }
            }
        });
    }

    private void handleWrap(CellStyleDefinition s, String entryPath, Object value) {
        this.ifTrue(entryPath, value, () -> s.wrap(Keywords.Text.WRAP));
    }

    private void handleFill(CellStyleDefinition s, Object value) {
        s.fill(ForegroundFill.valueOf((String)this.asEnumName(value)));
    }

    private void handleBase(CellStyleDefinition s, Object value) {
        s.base(String.valueOf(value));
    }

    private void handleBackground(String path, CellStyleDefinition s, Object value) {
        this.handleColor(path, value, arg_0 -> ((CellStyleDefinition)s).background(arg_0), arg_0 -> ((CellStyleDefinition)s).background(arg_0));
    }

    private void handleForeground(String path, CellStyleDefinition s, Object value) {
        this.handleColor(path, value, arg_0 -> ((CellStyleDefinition)s).foreground(arg_0), arg_0 -> ((CellStyleDefinition)s).foreground(arg_0));
    }

    private void handleFormat(CellStyleDefinition s, Object value) {
        s.format(String.valueOf(value));
    }

    private void handleIndent(CellStyleDefinition s, String path, Object value) {
        this.handleNumber(path, value, number -> s.indent(number.intValue()));
    }

    private void handleRotation(CellStyleDefinition s, String path, Object value) {
        this.handleNumber(path, value, number -> s.rotation(number.intValue()));
    }

    private void handleAlign(CellStyleDefinition s, String path, Object value) {
        DataSpreadsheetParser.withMap(value, path, map -> s.align(this.readFakeEnumValue(path, (Map<String, Object>)map, "vertical", (Class)Keywords.VerticalAlignment.class), this.readFakeEnumValue(path, (Map<String, Object>)map, "horizontal", (Class)Keywords.HorizontalAlignment.class)));
    }

    private <T> T readFakeEnumValue(String path, Map<String, Object> map, String key, Class<T> type) {
        if (map.containsKey(key)) {
            return this.readFakeEnumValue(path + '.' + key, map.get(key), type);
        }
        return null;
    }

    private <T> T readFakeEnumValue(String path, Object value, Class<T> type) {
        return this.readFakeEnumValue(path, value, type, false);
    }

    private <T> T readFakeEnumValue(String path, Object value, Class<T> type, boolean keepCase) {
        try {
            return type.cast(type.getField(keepCase ? String.valueOf(value) : this.asEnumName(value)).get(null));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new InvalidPropertyException(type.getSimpleName() + " " + value + " does not exist", (Throwable)e, path, value);
        }
    }

    private String asEnumName(Object value) {
        if (String.valueOf(value).matches("^[A-Z_]+$")) {
            return String.valueOf(value);
        }
        return String.valueOf(value).replaceAll("(.)(\\p{Upper})", "$1_$2").toUpperCase();
    }

    @FunctionalInterface
    private static interface MapEntryHandler {
        public void handle(String var1, String var2, Object var3);
    }
}

