/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.builder.data;

import builders.dsl.spreadsheet.builder.api.CellDefinition;
import builders.dsl.spreadsheet.builder.api.CellStyleDefinition;
import builders.dsl.spreadsheet.builder.api.RowDefinition;
import builders.dsl.spreadsheet.builder.data.AbstractNode;
import builders.dsl.spreadsheet.builder.data.CellNode;
import builders.dsl.spreadsheet.builder.data.CellStyleNode;
import java.util.Collections;
import java.util.function.Consumer;

class RowNode
extends AbstractNode
implements RowDefinition {
    RowNode() {
    }

    public RowDefinition cell(Consumer<CellDefinition> cellDefinition) {
        CellNode cellNode = new CellNode();
        cellDefinition.accept(cellNode);
        this.node.add("cells", cellNode);
        return this;
    }

    public RowDefinition cell(int column, Consumer<CellDefinition> cellDefinition) {
        CellNode cellNode = new CellNode();
        cellNode.setColumn(column);
        cellDefinition.accept(cellNode);
        this.node.add("cells", cellNode);
        return this;
    }

    public RowDefinition group(Consumer<RowDefinition> insideGroupDefinition) {
        RowNode rowNode = new RowNode();
        insideGroupDefinition.accept(rowNode);
        this.node.add("cells", Collections.singletonMap("group", rowNode.getContent().get("cells")));
        return this;
    }

    public RowDefinition collapse(Consumer<RowDefinition> insideGroupDefinition) {
        RowNode rowNode = new RowNode();
        insideGroupDefinition.accept(rowNode);
        this.node.add("cells", Collections.singletonMap("collapse", rowNode.getContent().get("cells")));
        return this;
    }

    public RowDefinition styles(Iterable<String> styles, Iterable<Consumer<CellStyleDefinition>> styleDefinitions) {
        for (String string : styles) {
            this.node.add("styles", string);
        }
        for (Consumer consumer : styleDefinitions) {
            CellStyleNode cellStyleNode = new CellStyleNode();
            consumer.accept(cellStyleNode);
            this.node.add("styles", cellStyleNode);
        }
        return this;
    }

    public void setNumber(int number) {
        this.node.set("number", number);
    }
}

