/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.builder.data;

import builders.dsl.spreadsheet.builder.api.CellDefinition;
import builders.dsl.spreadsheet.builder.api.DimensionModifier;
import builders.dsl.spreadsheet.builder.data.CellNode;

public class LiteralDimensionModifier
implements DimensionModifier {
    private final CellNode cell;
    private final double dimension;
    private final String widthOrHeight;

    public LiteralDimensionModifier(CellNode cell, double dimension, String widthOrHeight) {
        this.cell = cell;
        this.dimension = dimension;
        this.widthOrHeight = widthOrHeight;
    }

    public CellDefinition cm() {
        this.cell.node.set(this.widthOrHeight, Math.round(this.dimension) + " cm");
        return this.cell;
    }

    public CellDefinition inch() {
        this.cell.node.set(this.widthOrHeight, Math.round(this.dimension) + " inch");
        return this.cell;
    }

    public CellDefinition inches() {
        return this.inch();
    }

    public CellDefinition points() {
        this.cell.node.set(this.widthOrHeight, this.dimension);
        return this.cell;
    }
}

