/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.expectations.dsl;

import builders.dsl.expectations.Expectations;
import builders.dsl.expectations.dsl.Assertion7;
import builders.dsl.expectations.dsl.Expectations7;
import builders.dsl.expectations.dsl.Headers7;
import builders.dsl.expectations.dsl.Row7;
import builders.dsl.expectations.dsl.Verification7;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.DynamicTest;
import org.opentest4j.AssertionFailedError;

public class DataTable7<A, B, C, D, E, F, G> {
    private final List<Row7<A, B, C, D, E, F, G>> data = new ArrayList<Row7<A, B, C, D, E, F, G>>();
    private final Headers7 headers;

    public DataTable7(Headers7 headers, Iterable<Row7<A, B, C, D, E, F, G>> rows) {
        this.headers = headers;
        rows.forEach(this.data::add);
    }

    public Expectations expect(String template, Assertion7<A, B, C, D, E, F, G> verification) {
        return new Expectations7<A, B, C, D, E, F, G>(this, template, verification);
    }

    public Expectations verify(String template, Verification7<A, B, C, D, E, F, G> verification) {
        return new Expectations7<Object, Object, Object, Object, Object, Object, Object>(this, template, (a, b, c, d, e, f, g) -> {
            verification.verify(a, b, c, d, e, f, g);
            return true;
        });
    }

    public DataTable7<A, B, C, D, E, F, G> and(A a, B b, C c, D d, E e, F f, G g) {
        this.data.add(new Row7<A, B, C, D, E, F, G>(a, b, c, d, e, f, g));
        return this;
    }

    Stream<DynamicTest> generateTests(String template, Assertion7<A, B, C, D, E, F, G> verification) {
        return this.data.stream().map(row -> {
            String title = template.replace("#" + this.headers.getA(), String.valueOf(row.getA()));
            title = title.replace("#" + this.headers.getB(), String.valueOf(row.getB()));
            title = title.replace("#" + this.headers.getC(), String.valueOf(row.getC()));
            title = title.replace("#" + this.headers.getD(), String.valueOf(row.getD()));
            title = title.replace("#" + this.headers.getE(), String.valueOf(row.getE()));
            title = title.replace("#" + this.headers.getF(), String.valueOf(row.getF()));
            String finalTitle = title.replace("#" + this.headers.getG(), String.valueOf(row.getG()));
            return DynamicTest.dynamicTest((String)finalTitle, () -> {
                if (!verification.verify(row.getA(), row.getB(), row.getC(), row.getD(), row.getE(), row.getF(), row.getG())) {
                    throw new AssertionFailedError("Verification failed for " + finalTitle + " with values " + this.headers.getA() + "=" + row.getA() + ", " + this.headers.getB() + "=" + row.getB() + ", " + this.headers.getC() + "=" + row.getC() + ", " + this.headers.getD() + "=" + row.getD() + ", " + this.headers.getE() + "=" + row.getE() + ", " + this.headers.getF() + "=" + row.getF() + ", " + this.headers.getG() + "=" + row.getG());
                }
            });
        });
    }
}

