/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.expectations.dsl;

import builders.dsl.expectations.Expectations;
import builders.dsl.expectations.dsl.Assertion6;
import builders.dsl.expectations.dsl.Expectations6;
import builders.dsl.expectations.dsl.Headers6;
import builders.dsl.expectations.dsl.Row6;
import builders.dsl.expectations.dsl.Verification6;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.DynamicTest;
import org.opentest4j.AssertionFailedError;

public class DataTable6<A, B, C, D, E, F> {
    private final List<Row6<A, B, C, D, E, F>> data = new ArrayList<Row6<A, B, C, D, E, F>>();
    private final Headers6 headers;

    public DataTable6(Headers6 headers, Iterable<Row6<A, B, C, D, E, F>> rows) {
        this.headers = headers;
        rows.forEach(this.data::add);
    }

    public Expectations expect(String template, Assertion6<A, B, C, D, E, F> verification) {
        return new Expectations6<A, B, C, D, E, F>(this, template, verification);
    }

    public Expectations verify(String template, Verification6<A, B, C, D, E, F> verification) {
        return new Expectations6<Object, Object, Object, Object, Object, Object>(this, template, (a, b, c, d, e, f) -> {
            verification.verify(a, b, c, d, e, f);
            return true;
        });
    }

    public DataTable6<A, B, C, D, E, F> and(A a, B b, C c, D d, E e, F f) {
        this.data.add(new Row6<A, B, C, D, E, F>(a, b, c, d, e, f));
        return this;
    }

    Stream<DynamicTest> generateTests(String template, Assertion6<A, B, C, D, E, F> verification) {
        return this.data.stream().map(row -> {
            String title = template.replace("#" + this.headers.getA(), String.valueOf(row.getA()));
            title = title.replace("#" + this.headers.getB(), String.valueOf(row.getB()));
            title = title.replace("#" + this.headers.getC(), String.valueOf(row.getC()));
            title = title.replace("#" + this.headers.getD(), String.valueOf(row.getD()));
            title = title.replace("#" + this.headers.getE(), String.valueOf(row.getE()));
            String finalTitle = title.replace("#" + this.headers.getF(), String.valueOf(row.getF()));
            return DynamicTest.dynamicTest((String)finalTitle, () -> {
                if (!verification.verify(row.getA(), row.getB(), row.getC(), row.getD(), row.getE(), row.getF())) {
                    throw new AssertionFailedError("Verification failed for " + finalTitle + " with values " + this.headers.getA() + "=" + row.getA() + ", " + this.headers.getB() + "=" + row.getB() + ", " + this.headers.getC() + "=" + row.getC() + ", " + this.headers.getD() + "=" + row.getD() + ", " + this.headers.getE() + "=" + row.getE() + ", " + this.headers.getF() + "=" + row.getF());
                }
            });
        });
    }
}

