/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.expectations.dsl;

import builders.dsl.expectations.Expectations;
import builders.dsl.expectations.dsl.Assertion3;
import builders.dsl.expectations.dsl.Expectations3;
import builders.dsl.expectations.dsl.Headers3;
import builders.dsl.expectations.dsl.Row3;
import builders.dsl.expectations.dsl.Verification3;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.DynamicTest;
import org.opentest4j.AssertionFailedError;

public class DataTable3<A, B, C> {
    private final List<Row3<A, B, C>> data = new ArrayList<Row3<A, B, C>>();
    private final Headers3 headers;

    public DataTable3(Headers3 headers, Iterable<Row3<A, B, C>> rows) {
        this.headers = headers;
        rows.forEach(this.data::add);
    }

    public Expectations expect(String template, Assertion3<A, B, C> verification) {
        return new Expectations3<A, B, C>(this, template, verification);
    }

    public Expectations verify(String template, Verification3<A, B, C> verification) {
        return new Expectations3<Object, Object, Object>(this, template, (a, b, c) -> {
            verification.verify(a, b, c);
            return true;
        });
    }

    public DataTable3<A, B, C> and(A a, B b, C c) {
        this.data.add(new Row3<A, B, C>(a, b, c));
        return this;
    }

    Stream<DynamicTest> generateTests(String template, Assertion3<A, B, C> verification) {
        return this.data.stream().map(row -> {
            String title = template.replace("#" + this.headers.getA(), String.valueOf(row.getA()));
            title = title.replace("#" + this.headers.getB(), String.valueOf(row.getB()));
            String finalTitle = title = title.replace("#" + this.headers.getC(), String.valueOf(row.getC()));
            return DynamicTest.dynamicTest((String)finalTitle, () -> {
                if (!verification.verify(row.getA(), row.getB(), row.getC())) {
                    throw new AssertionFailedError("Verification failed for " + finalTitle + " with values " + this.headers.getA() + "=" + row.getA() + ", " + this.headers.getB() + "=" + row.getB() + ", " + this.headers.getC() + "=" + row.getC());
                }
            });
        });
    }
}

