/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.expectations.dsl;

import builders.dsl.expectations.Expectations;
import builders.dsl.expectations.dsl.Assertion2;
import builders.dsl.expectations.dsl.Expectations2;
import builders.dsl.expectations.dsl.Headers2;
import builders.dsl.expectations.dsl.Row2;
import builders.dsl.expectations.dsl.Verification2;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.DynamicTest;
import org.opentest4j.AssertionFailedError;

public class DataTable2<A, B> {
    private final List<Row2<A, B>> data = new ArrayList<Row2<A, B>>();
    private final Headers2 headers;

    public DataTable2(Headers2 headers, Iterable<Row2<A, B>> rows) {
        this.headers = headers;
        rows.forEach(this.data::add);
    }

    public Expectations expect(String template, Assertion2<A, B> verification) {
        return new Expectations2<A, B>(this, template, verification);
    }

    public Expectations verify(String template, Verification2<A, B> verification) {
        return new Expectations2<Object, Object>(this, template, (a, b) -> {
            verification.verify(a, b);
            return true;
        });
    }

    public DataTable2<A, B> and(A a, B b) {
        this.data.add(new Row2<A, B>(a, b));
        return this;
    }

    Stream<DynamicTest> generateTests(String template, Assertion2<A, B> verification) {
        return this.data.stream().map(row -> {
            String title = template.replace("#" + this.headers.getA(), String.valueOf(row.getA()));
            String finalTitle = title.replace("#" + this.headers.getB(), String.valueOf(row.getB()));
            return DynamicTest.dynamicTest((String)finalTitle, () -> {
                if (!verification.verify(row.getA(), row.getB())) {
                    throw new AssertionFailedError("Verification failed for " + finalTitle + " with values " + this.headers.getA() + "=" + row.getA() + ", " + this.headers.getB() + "=" + row.getB());
                }
            });
        });
    }
}

