/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.expectations.dsl;

import builders.dsl.expectations.Expectations;
import builders.dsl.expectations.dsl.Assertion1;
import builders.dsl.expectations.dsl.Expectations1;
import builders.dsl.expectations.dsl.Headers1;
import builders.dsl.expectations.dsl.Row1;
import builders.dsl.expectations.dsl.Verification1;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.DynamicTest;
import org.opentest4j.AssertionFailedError;

public class DataTable1<A> {
    private final List<Row1<A>> data = new ArrayList<Row1<A>>();
    private final Headers1 headers;

    public DataTable1(Headers1 headers, Iterable<Row1<A>> rows) {
        this.headers = headers;
        rows.forEach(this.data::add);
    }

    public Expectations expect(String template, Assertion1<A> verification) {
        return new Expectations1<A>(this, template, verification);
    }

    public Expectations verify(String template, Verification1<A> verification) {
        return new Expectations1<Object>(this, template, a -> {
            verification.verify(a);
            return true;
        });
    }

    public DataTable1<A> and(A a) {
        this.data.add(new Row1<A>(a));
        return this;
    }

    Stream<DynamicTest> generateTests(String template, Assertion1<A> verification) {
        return this.data.stream().map(row -> {
            String title = template.replace("#" + this.headers.getA(), String.valueOf(row.getA()));
            return DynamicTest.dynamicTest((String)title, () -> {
                if (!verification.verify(row.getA())) {
                    throw new AssertionFailedError("Verification failed for " + title + " with values " + this.headers.getA() + "=" + row.getA());
                }
            });
        });
    }
}

