/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.expectations.dsl;

import builders.dsl.expectations.Expectations;
import builders.dsl.expectations.dsl.Assertion8;
import builders.dsl.expectations.dsl.Expectations8;
import builders.dsl.expectations.dsl.Headers8;
import builders.dsl.expectations.dsl.Row8;
import builders.dsl.expectations.dsl.Verification8;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.DynamicTest;
import org.opentest4j.AssertionFailedError;

public class DataTable8<A, B, C, D, E, F, G, H> {
    private final List<Row8<A, B, C, D, E, F, G, H>> data = new ArrayList<Row8<A, B, C, D, E, F, G, H>>();
    private final Headers8 headers;

    public DataTable8(Headers8 headers, Iterable<Row8<A, B, C, D, E, F, G, H>> rows) {
        this.headers = headers;
        rows.forEach(this.data::add);
    }

    public Expectations expect(String template, Assertion8<A, B, C, D, E, F, G, H> verification) {
        return new Expectations8<A, B, C, D, E, F, G, H>(this, template, verification);
    }

    public Expectations verify(String template, Verification8<A, B, C, D, E, F, G, H> verification) {
        return new Expectations8<Object, Object, Object, Object, Object, Object, Object, Object>(this, template, (a, b, c, d, e, f, g, h) -> {
            verification.verify(a, b, c, d, e, f, g, h);
            return true;
        });
    }

    public DataTable8<A, B, C, D, E, F, G, H> and(A a, B b, C c, D d, E e, F f, G g, H h) {
        this.data.add(new Row8<A, B, C, D, E, F, G, H>(a, b, c, d, e, f, g, h));
        return this;
    }

    Stream<DynamicTest> generateTests(String template, Assertion8<A, B, C, D, E, F, G, H> verification) {
        return this.data.stream().map(row -> {
            String title = template.replace("#" + this.headers.getA(), String.valueOf(row.getA()));
            title = title.replace("#" + this.headers.getB(), String.valueOf(row.getB()));
            title = title.replace("#" + this.headers.getC(), String.valueOf(row.getC()));
            title = title.replace("#" + this.headers.getD(), String.valueOf(row.getD()));
            title = title.replace("#" + this.headers.getE(), String.valueOf(row.getE()));
            title = title.replace("#" + this.headers.getF(), String.valueOf(row.getF()));
            title = title.replace("#" + this.headers.getG(), String.valueOf(row.getG()));
            String finalTitle = title.replace("#" + this.headers.getH(), String.valueOf(row.getH()));
            return DynamicTest.dynamicTest((String)finalTitle, () -> {
                if (!verification.verify(row.getA(), row.getB(), row.getC(), row.getD(), row.getE(), row.getF(), row.getG(), row.getH())) {
                    throw new AssertionFailedError("Verification failed for " + finalTitle + " with values " + this.headers.getA() + "=" + row.getA() + ", " + this.headers.getB() + "=" + row.getB() + ", " + this.headers.getC() + "=" + row.getC() + ", " + this.headers.getD() + "=" + row.getD() + ", " + this.headers.getE() + "=" + row.getE() + ", " + this.headers.getF() + "=" + row.getF() + ", " + this.headers.getG() + "=" + row.getG() + ", " + this.headers.getH() + "=" + row.getH());
                }
            });
        });
    }
}

