/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.expectations.dsl;

import builders.dsl.expectations.Expectations;
import builders.dsl.expectations.dsl.Assertion5;
import builders.dsl.expectations.dsl.Expectations5;
import builders.dsl.expectations.dsl.Headers5;
import builders.dsl.expectations.dsl.Row5;
import builders.dsl.expectations.dsl.Verification5;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.DynamicTest;
import org.opentest4j.AssertionFailedError;

public class DataTable5<A, B, C, D, E> {
    private final List<Row5<A, B, C, D, E>> data = new ArrayList<Row5<A, B, C, D, E>>();
    private final Headers5 headers;

    public DataTable5(Headers5 headers, Iterable<Row5<A, B, C, D, E>> rows) {
        this.headers = headers;
        rows.forEach(this.data::add);
    }

    public Expectations expect(String template, Assertion5<A, B, C, D, E> verification) {
        return new Expectations5<A, B, C, D, E>(this, template, verification);
    }

    public Expectations verify(String template, Verification5<A, B, C, D, E> verification) {
        return new Expectations5<Object, Object, Object, Object, Object>(this, template, (a, b, c, d, e) -> {
            verification.verify(a, b, c, d, e);
            return true;
        });
    }

    public DataTable5<A, B, C, D, E> and(A a, B b, C c, D d, E e) {
        this.data.add(new Row5<A, B, C, D, E>(a, b, c, d, e));
        return this;
    }

    Stream<DynamicTest> generateTests(String template, Assertion5<A, B, C, D, E> verification) {
        return this.data.stream().map(row -> {
            String title = template.replace("#" + this.headers.getA(), String.valueOf(row.getA()));
            title = title.replace("#" + this.headers.getB(), String.valueOf(row.getB()));
            title = title.replace("#" + this.headers.getC(), String.valueOf(row.getC()));
            title = title.replace("#" + this.headers.getD(), String.valueOf(row.getD()));
            String finalTitle = title.replace("#" + this.headers.getE(), String.valueOf(row.getE()));
            return DynamicTest.dynamicTest((String)finalTitle, () -> {
                if (!verification.verify(row.getA(), row.getB(), row.getC(), row.getD(), row.getE())) {
                    throw new AssertionFailedError("Verification failed for " + finalTitle + " with values " + this.headers.getA() + "=" + row.getA() + ", " + this.headers.getB() + "=" + row.getB() + ", " + this.headers.getC() + "=" + row.getC() + ", " + this.headers.getD() + "=" + row.getD() + ", " + this.headers.getE() + "=" + row.getE());
                }
            });
        });
    }
}

