/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.expectations.dsl;

import builders.dsl.expectations.Expectations;
import builders.dsl.expectations.dsl.Assertion4;
import builders.dsl.expectations.dsl.Expectations4;
import builders.dsl.expectations.dsl.Headers4;
import builders.dsl.expectations.dsl.Row4;
import builders.dsl.expectations.dsl.Verification4;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.DynamicTest;
import org.opentest4j.AssertionFailedError;

public class DataTable4<A, B, C, D> {
    private final List<Row4<A, B, C, D>> data = new ArrayList<Row4<A, B, C, D>>();
    private final Headers4 headers;

    public DataTable4(Headers4 headers, Iterable<Row4<A, B, C, D>> rows) {
        this.headers = headers;
        rows.forEach(this.data::add);
    }

    public Expectations expect(String template, Assertion4<A, B, C, D> verification) {
        return new Expectations4<A, B, C, D>(this, template, verification);
    }

    public Expectations verify(String template, Verification4<A, B, C, D> verification) {
        return new Expectations4<Object, Object, Object, Object>(this, template, (a, b, c, d) -> {
            verification.verify(a, b, c, d);
            return true;
        });
    }

    public DataTable4<A, B, C, D> and(A a, B b, C c, D d) {
        this.data.add(new Row4<A, B, C, D>(a, b, c, d));
        return this;
    }

    Stream<DynamicTest> generateTests(String template, Assertion4<A, B, C, D> verification) {
        return this.data.stream().map(row -> {
            String title = template.replace("#" + this.headers.getA(), String.valueOf(row.getA()));
            title = title.replace("#" + this.headers.getB(), String.valueOf(row.getB()));
            title = title.replace("#" + this.headers.getC(), String.valueOf(row.getC()));
            String finalTitle = title.replace("#" + this.headers.getD(), String.valueOf(row.getD()));
            return DynamicTest.dynamicTest((String)finalTitle, () -> {
                if (!verification.verify(row.getA(), row.getB(), row.getC(), row.getD())) {
                    throw new AssertionFailedError("Verification failed for " + finalTitle + " with values " + this.headers.getA() + "=" + row.getA() + ", " + this.headers.getB() + "=" + row.getB() + ", " + this.headers.getC() + "=" + row.getC() + ", " + this.headers.getD() + "=" + row.getD());
                }
            });
        });
    }
}

