(ns singularity.mongo

  "Ineract with MongoDB, using CongoMongo."

  (:use [somnium.congomongo.config :only [*mongo-config*]])
  (:require [somnium.congomongo :as mongo]
            [singularity.settings :as settings]))

(def mongo-settings (settings/for :mongo))

(defn connect
  "Create a connection to the MongoDB database, based on the settings in
  terra.json."
  []
  (mongo/make-connection (:db mongo-settings) (:servers mongo-settings)))

(defmacro with-mongo
  "Open a connection to the mongo DB database.  Closes the connection when
  done.  If you've already wrapped your code in a with-mongo, just executes
  the body with the current connection.  This allows you to wrap many smaller
  calls in a single call without any additional overhead."
  [& body]
  `(if-not (empty? *mongo-config*)
     (do
       ~@body)
     (let [c# (connect)]
       (try
         (mongo/with-mongo c#
           ~@body)
         (finally
           (mongo/close-connection c#))))))
