/*
 * Decompiled with CFR 0.152.
 */
package brilliantarc.singularity;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class AmazonSignature {
    private static final String UTF8_CHARSET = "UTF-8";
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private String awsSecretKey = null;
    private SecretKeySpec secretKeySpec = null;
    private Mac mac = null;

    public AmazonSignature(String string) throws IllegalArgumentException, UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException {
        if (null == string || string.length() == 0) {
            throw new IllegalArgumentException("Please indicate an Amazon secret key.");
        }
        this.awsSecretKey = string;
        byte[] byArray = this.awsSecretKey.getBytes(UTF8_CHARSET);
        this.secretKeySpec = new SecretKeySpec(byArray, HMAC_SHA1_ALGORITHM);
        this.mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
        this.mac.init(this.secretKeySpec);
    }

    public String turk(String string, String string2) {
        return this.sign("AWSMechanicalTurkRequester" + string + string2);
    }

    public String sign(String string) {
        String string2 = null;
        try {
            byte[] byArray = string.getBytes(UTF8_CHARSET);
            byte[] byArray2 = this.mac.doFinal(byArray);
            Base64 base64 = new Base64(0);
            string2 = new String(base64.encode(byArray2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 is unsupported!", unsupportedEncodingException);
        }
        return string2;
    }

    public String timestamp() {
        String string = null;
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        string = simpleDateFormat.format(calendar.getTime());
        return string;
    }
}

