/*
 * Decompiled with CFR 0.152.
 */
package br.usp.each.saeg.asm.defuse;

import br.usp.each.saeg.asm.defuse.Variable;
import java.util.Collections;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;

public class Value
implements org.objectweb.asm.tree.analysis.Value {
    public static final Value UNINITIALIZED_VALUE = new Value();
    public static final Value INT_VALUE = new Value(Type.INT_TYPE);
    public static final Value FLOAT_VALUE = new Value(Type.FLOAT_TYPE);
    public static final Value LONG_VALUE = new Value(Type.LONG_TYPE);
    public static final Value DOUBLE_VALUE = new Value(Type.DOUBLE_TYPE);
    public static final Value REFERENCE_VALUE = new Value(Type.getObjectType((String)"java/lang/Object"));
    public final Type type;
    public final Set<AbstractInsnNode> insns;

    private Value() {
        this.type = null;
        this.insns = Collections.emptySet();
    }

    public Value(Type type) {
        this(type, Collections.emptySet());
    }

    public Value(Type type, Set<AbstractInsnNode> insns) {
        if (type == null) {
            throw new IllegalArgumentException("Type can't be null");
        }
        if (insns == null) {
            throw new IllegalArgumentException("Set of instructions can't be null");
        }
        if (type.getSort() == 11) {
            throw new IllegalArgumentException("Type can't be METHOD");
        }
        this.type = type;
        this.insns = insns;
    }

    public Value with(AbstractInsnNode insn) {
        return new Value(this.type, Collections.singleton(insn));
    }

    public Set<Variable> getVariables() {
        return Collections.emptySet();
    }

    public int getSize() {
        return this.type != null ? this.type.getSize() : 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.insns.hashCode();
        return 31 * result + (this.type == null ? 0 : this.type.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Value other = (Value)obj;
        if (this.type == null) {
            return false;
        }
        if (!this.type.equals((Object)other.type)) {
            return false;
        }
        return this.insns.equals(other.insns);
    }

    public String toString() {
        if (this == UNINITIALIZED_VALUE) {
            return ".";
        }
        if (this == REFERENCE_VALUE) {
            return "R";
        }
        return this.type.getDescriptor();
    }
}

