/*
 * Decompiled with CFR 0.152.
 */
package br.usp.each.saeg.asm.defuse;

import br.usp.each.saeg.asm.defuse.Field;
import br.usp.each.saeg.asm.defuse.Local;
import br.usp.each.saeg.asm.defuse.StaticField;
import br.usp.each.saeg.asm.defuse.Value;
import br.usp.each.saeg.asm.defuse.Variable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class ObjectField
extends Field {
    public final Value value;

    public ObjectField(String owner, String name, String desc, Value value) {
        super(owner, name, desc);
        if (value.type.getSort() != 10) {
            throw new IllegalArgumentException("Invalid value type: " + value.type);
        }
        this.value = value;
    }

    @Override
    public Set<Variable> getVariables() {
        LinkedHashSet<Variable> values = new LinkedHashSet<Variable>();
        values.addAll(this.value.getVariables());
        Value root = this.getRoot();
        if (root instanceof Local || root instanceof StaticField) {
            values.add(this);
        }
        return Collections.unmodifiableSet(values);
    }

    public Value getRoot() {
        Value root = this.value;
        while (root instanceof ObjectField) {
            root = ((ObjectField)ObjectField.class.cast((Object)root)).value;
        }
        return root;
    }

    @Override
    public String toString() {
        return String.format("%s.%s.%s", this.value, this.owner.replace("/", "."), this.name);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ObjectField other = (ObjectField)obj;
        return this.value.equals(other.value);
    }
}

