/*
 * Decompiled with CFR 0.152.
 */
package br.usp.each.saeg.asm.defuse;

import br.usp.each.saeg.asm.defuse.IntList;
import br.usp.each.saeg.commons.ArrayUtils;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;

public class FlowAnalyzer<V extends Value>
extends Analyzer<V> {
    private Set<Integer>[] successors;
    private Set<Integer>[] predecessors;
    private int[][] blocks;
    private int[] leaders;
    private int[][] paths;
    private int n;

    public FlowAnalyzer(Interpreter<V> interpreter) {
        super(interpreter);
    }

    public Frame<V>[] analyze(String owner, MethodNode m) throws AnalyzerException {
        int i;
        this.n = m.instructions.size();
        this.blocks = new int[this.n][];
        this.leaders = new int[this.n];
        this.paths = new int[this.n][];
        Arrays.fill(this.leaders, -1);
        this.successors = new Set[this.n];
        this.predecessors = new Set[this.n];
        for (int i2 = 0; i2 < this.n; ++i2) {
            this.successors[i2] = new LinkedHashSet<Integer>();
            this.predecessors[i2] = new LinkedHashSet<Integer>();
        }
        Frame[] frames = super.analyze(owner, m);
        if ((m.access & 0x500) != 0) {
            return new Frame[0];
        }
        boolean[] queued = new boolean[this.n];
        int[] queue = new int[this.n];
        int top = 0;
        int basicBlock = 0;
        queue[top++] = 0;
        queued[0] = true;
        IntList list = new IntList();
        while (top > 0) {
            int child;
            i = queue[--top];
            this.leaders[i] = basicBlock;
            list.add(i);
            while (this.successors[i].size() == 1 && !queued[child = this.successors[i].iterator().next().intValue()] && this.predecessors[child].size() <= 1) {
                i = child;
                this.leaders[i] = basicBlock;
                list.add(i);
            }
            this.blocks[basicBlock] = list.toArray();
            list.clear();
            ++basicBlock;
            for (int succ : this.successors[i]) {
                if (queued[succ]) continue;
                queue[top++] = succ;
                queued[succ] = true;
            }
        }
        this.blocks = (int[][])Arrays.copyOf(this.blocks, basicBlock);
        Arrays.fill(queued, false);
        for (i = 0; i < this.n; ++i) {
            if (this.successors[i].size() != 0 || this.leaders[i] == -1) continue;
            queue[top++] = i;
            queued[i] = true;
        }
        while (top > 0) {
            i = queue[--top];
            int b = this.leaders[i];
            list.add(b);
            while (this.predecessors[this.blocks[b][0]].size() == 1 && this.blocks[b][0] != 0) {
                b = this.leaders[this.predecessors[this.blocks[b][0]].iterator().next()];
                list.add(b);
            }
            this.paths[i] = list.toReverseArray();
            list.clear();
            for (int pred : this.predecessors[this.blocks[b][0]]) {
                if (queued[pred]) continue;
                queue[top++] = pred;
                queued[pred] = true;
            }
        }
        return frames;
    }

    protected void newControlFlowEdge(int insn, int successor) {
        this.successors[insn].add(successor);
        this.predecessors[successor].add(insn);
    }

    protected boolean newControlFlowExceptionEdge(int insn, int successor) {
        return false;
    }

    public int[] getSuccessors(int insn) {
        return ArrayUtils.toArray(this.successors[insn], (int[])new int[0]);
    }

    public int[][] getSuccessors() {
        int[][] successors = new int[this.n][];
        for (int i = 0; i < this.n; ++i) {
            successors[i] = this.getSuccessors(i);
        }
        return successors;
    }

    public int[] getPredecessors(int insn) {
        return ArrayUtils.toArray(this.predecessors[insn], (int[])new int[0]);
    }

    public int[][] getPredecessors() {
        int[][] predecessors = new int[this.n][];
        for (int i = 0; i < this.n; ++i) {
            predecessors[i] = this.getPredecessors(i);
        }
        return predecessors;
    }

    public int[] getLeaders() {
        return this.leaders;
    }

    public int[] getBasicBlock(int id) {
        return this.blocks[id];
    }

    public int[][] getBasicBlocks() {
        return this.blocks;
    }

    public int[][] getPaths() {
        return this.paths;
    }

    public int[] getPath(int insn) {
        int[] path = this.paths[insn];
        if (path == null) {
            path = this.blocks[this.leaders[insn]];
            if (this.paths[path[path.length - 1]] == null) {
                if (path[0] != 0 && this.predecessors[path[0]].size() == 1) {
                    path = ArrayUtils.merge((int[])this.getPath(this.predecessors[path[0]].iterator().next()), (int[])path);
                }
                return Arrays.copyOf(path, ArrayUtils.indexOf((int[])path, (int)insn) + 1);
            }
            path = this.paths[path[path.length - 1]];
        }
        int size = 0;
        for (int block : path) {
            size += this.blocks[block].length;
        }
        int[] insnPath = new int[size];
        size = 0;
        for (int block : path) {
            System.arraycopy(this.blocks[block], 0, insnPath, size, this.blocks[block].length);
            size += this.blocks[block].length;
        }
        return Arrays.copyOf(insnPath, ArrayUtils.indexOf((int[])insnPath, (int)insn) + 1);
    }
}

