/*
 * Decompiled with CFR 0.152.
 */
package br.usp.each.saeg.asm.defuse;

import br.usp.each.saeg.asm.defuse.DefUseChain;
import br.usp.each.saeg.asm.defuse.DefUseChainSearch;
import br.usp.each.saeg.asm.defuse.DefUseFrame;
import br.usp.each.saeg.asm.defuse.Variable;
import br.usp.each.saeg.commons.ArrayUtils;
import java.util.ArrayList;
import java.util.List;

public class DepthFirstDefUseChainSearch
implements DefUseChainSearch {
    private DefUseFrame[] frames;
    private Variable[] variables;
    private int[][] successors;
    private int n;

    @Override
    public DefUseChain[] search(DefUseFrame[] frames, Variable[] variables, int[][] adjacencyListSucc, int[][] adjacencyListPred) {
        this.frames = frames;
        this.variables = variables;
        this.successors = adjacencyListSucc;
        this.n = frames.length;
        ArrayList<DefUseChain> list = new ArrayList<DefUseChain>();
        for (int i = 0; i < this.n; ++i) {
            for (Variable def : frames[i].getDefinitions()) {
                this.DFS(def, i, list);
            }
        }
        return list.toArray(new DefUseChain[list.size()]);
    }

    private void DFS(Variable def, int i, List<DefUseChain> list) {
        boolean[] queued = new boolean[this.n];
        int[] queue = new int[this.n];
        int top = 0;
        for (int succ : this.successors[i]) {
            queue[top++] = succ;
            queued[succ] = true;
        }
        while (top > 0) {
            int j;
            if (this.frames[j = queue[--top]].getUses().contains(def)) {
                if (this.frames[j].predicate) {
                    for (int succ : this.successors[j]) {
                        list.add(new DefUseChain(i, j, succ, ArrayUtils.indexOf((Object[])this.variables, (Object)def)));
                    }
                } else {
                    list.add(new DefUseChain(i, j, ArrayUtils.indexOf((Object[])this.variables, (Object)def)));
                }
            }
            if (this.frames[j].getDefinitions().contains(def)) continue;
            for (int succ : this.successors[j]) {
                if (queued[succ]) continue;
                queue[top++] = succ;
                queued[succ] = true;
            }
        }
    }
}

