/*
 * Decompiled with CFR 0.152.
 */
package br.usp.each.saeg.asm.defuse;

import br.usp.each.saeg.asm.defuse.ArrayRef;
import br.usp.each.saeg.asm.defuse.ArrayValue;
import br.usp.each.saeg.asm.defuse.Invoke;
import br.usp.each.saeg.asm.defuse.Local;
import br.usp.each.saeg.asm.defuse.Merge;
import br.usp.each.saeg.asm.defuse.ObjectField;
import br.usp.each.saeg.asm.defuse.ObjectRef;
import br.usp.each.saeg.asm.defuse.StaticField;
import br.usp.each.saeg.asm.defuse.Value;
import br.usp.each.saeg.asm.defuse.ValueHolder;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Interpreter;

public class DefUseInterpreter
extends Interpreter<Value>
implements Opcodes {
    public DefUseInterpreter() {
        super(327680);
    }

    public Value newValue(Type type) {
        if (type == null) {
            return Value.UNINITIALIZED_VALUE;
        }
        switch (type.getSort()) {
            case 0: {
                return null;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return Value.INT_VALUE;
            }
            case 6: {
                return Value.FLOAT_VALUE;
            }
            case 7: {
                return Value.LONG_VALUE;
            }
            case 8: {
                return Value.DOUBLE_VALUE;
            }
            case 9: 
            case 10: {
                return Value.REFERENCE_VALUE;
            }
        }
        throw new IllegalArgumentException("Illegal type" + type);
    }

    public Value newOperation(AbstractInsnNode insn) {
        switch (insn.getOpcode()) {
            case 1: {
                return Value.REFERENCE_VALUE;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Value.INT_VALUE;
            }
            case 9: 
            case 10: {
                return Value.LONG_VALUE;
            }
            case 11: 
            case 12: 
            case 13: {
                return Value.FLOAT_VALUE;
            }
            case 14: 
            case 15: {
                return Value.DOUBLE_VALUE;
            }
            case 16: 
            case 17: {
                return Value.INT_VALUE;
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                if (cst instanceof Integer) {
                    return Value.INT_VALUE;
                }
                if (cst instanceof Float) {
                    return Value.FLOAT_VALUE;
                }
                if (cst instanceof Long) {
                    return Value.LONG_VALUE;
                }
                if (cst instanceof Double) {
                    return Value.DOUBLE_VALUE;
                }
                if (cst instanceof String) {
                    return Value.REFERENCE_VALUE;
                }
                if (cst instanceof Type) {
                    int sort = ((Type)cst).getSort();
                    if (sort == 10 || sort == 9 || sort == 11) {
                        return Value.REFERENCE_VALUE;
                    }
                    throw new IllegalArgumentException("Illegal LDC constant " + cst);
                }
                if (cst instanceof Handle) {
                    return Value.REFERENCE_VALUE;
                }
                throw new IllegalArgumentException("Illegal LDC constant " + cst);
            }
            case 168: {
                throw new UnsupportedOperationException("Do not support instruction types JSR - Deprecated in Java 6");
            }
            case 178: {
                FieldInsnNode f = (FieldInsnNode)insn;
                return new StaticField(f.owner, f.name, f.desc);
            }
            case 187: {
                TypeInsnNode type = (TypeInsnNode)insn;
                return new ObjectRef(Type.getObjectType((String)type.desc));
            }
        }
        throw new IllegalArgumentException("Invalid instruction opcode.");
    }

    public Value copyOperation(AbstractInsnNode insn, Value value) {
        switch (insn.getOpcode()) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                VarInsnNode v = (VarInsnNode)insn;
                return new Local(value.type, v.var);
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return this.newValue(value.type).with(insn);
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                return value;
            }
        }
        throw new IllegalArgumentException("Invalid instruction opcode.");
    }

    public Value unaryOperation(AbstractInsnNode insn, Value value) {
        switch (insn.getOpcode()) {
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                return value;
            }
            case 132: {
                return Value.INT_VALUE.with(insn);
            }
            case 133: {
                return new ValueHolder(Type.LONG_TYPE, value);
            }
            case 134: {
                return new ValueHolder(Type.FLOAT_TYPE, value);
            }
            case 135: {
                return new ValueHolder(Type.DOUBLE_TYPE, value);
            }
            case 136: {
                return new ValueHolder(Type.INT_TYPE, value);
            }
            case 137: {
                return new ValueHolder(Type.FLOAT_TYPE, value);
            }
            case 138: {
                return new ValueHolder(Type.DOUBLE_TYPE, value);
            }
            case 139: {
                return new ValueHolder(Type.INT_TYPE, value);
            }
            case 140: {
                return new ValueHolder(Type.LONG_TYPE, value);
            }
            case 141: {
                return new ValueHolder(Type.DOUBLE_TYPE, value);
            }
            case 142: {
                return new ValueHolder(Type.INT_TYPE, value);
            }
            case 143: {
                return new ValueHolder(Type.LONG_TYPE, value);
            }
            case 144: {
                return new ValueHolder(Type.FLOAT_TYPE, value);
            }
            case 145: {
                return new ValueHolder(Type.BYTE_TYPE, value);
            }
            case 146: {
                return new ValueHolder(Type.CHAR_TYPE, value);
            }
            case 147: {
                return new ValueHolder(Type.SHORT_TYPE, value);
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 179: {
                return null;
            }
            case 180: {
                FieldInsnNode f = (FieldInsnNode)insn;
                return new ObjectField(f.owner, f.name, f.desc, value);
            }
            case 188: {
                IntInsnNode iinsn = (IntInsnNode)insn;
                switch (iinsn.operand) {
                    case 4: {
                        return new ArrayRef(Type.getType((String)"[Z"), value);
                    }
                    case 5: {
                        return new ArrayRef(Type.getType((String)"[C"), value);
                    }
                    case 8: {
                        return new ArrayRef(Type.getType((String)"[B"), value);
                    }
                    case 9: {
                        return new ArrayRef(Type.getType((String)"[S"), value);
                    }
                    case 10: {
                        return new ArrayRef(Type.getType((String)"[I"), value);
                    }
                    case 6: {
                        return new ArrayRef(Type.getType((String)"[F"), value);
                    }
                    case 7: {
                        return new ArrayRef(Type.getType((String)"[D"), value);
                    }
                    case 11: {
                        return new ArrayRef(Type.getType((String)"[J"), value);
                    }
                }
                throw new IllegalArgumentException("Invalid array type");
            }
            case 189: {
                TypeInsnNode tinsn = (TypeInsnNode)insn;
                return new ArrayRef(Type.getType((String)("[" + Type.getObjectType((String)tinsn.desc))), value);
            }
            case 190: {
                return new ValueHolder(Type.INT_TYPE, value);
            }
            case 191: {
                return null;
            }
            case 192: {
                TypeInsnNode tinsn = (TypeInsnNode)insn;
                return new ValueHolder(Type.getObjectType((String)tinsn.desc), value);
            }
            case 193: {
                return new ValueHolder(Type.INT_TYPE, value);
            }
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                return null;
            }
        }
        throw new IllegalArgumentException("Invalid instruction opcode.");
    }

    public Value binaryOperation(AbstractInsnNode insn, Value value1, Value value2) {
        switch (insn.getOpcode()) {
            case 46: {
                return new ArrayValue(Type.INT_TYPE, value1, value2);
            }
            case 47: {
                return new ArrayValue(Type.LONG_TYPE, value1, value2);
            }
            case 48: {
                return new ArrayValue(Type.FLOAT_TYPE, value1, value2);
            }
            case 49: {
                return new ArrayValue(Type.DOUBLE_TYPE, value1, value2);
            }
            case 50: {
                return new ArrayValue(Type.getObjectType((String)"java/lang/Object"), value1, value2);
            }
            case 51: {
                return new ArrayValue(Type.BYTE_TYPE, value1, value2);
            }
            case 52: {
                return new ArrayValue(Type.CHAR_TYPE, value1, value2);
            }
            case 53: {
                return new ArrayValue(Type.SHORT_TYPE, value1, value2);
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                return new Merge(Type.INT_TYPE, value1, value2);
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                return new Merge(Type.LONG_TYPE, value1, value2);
            }
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                return new Merge(Type.FLOAT_TYPE, value1, value2);
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                return new Merge(Type.DOUBLE_TYPE, value1, value2);
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 181: {
                return null;
            }
        }
        throw new IllegalArgumentException("Invalid instruction opcode.");
    }

    public Value ternaryOperation(AbstractInsnNode insn, Value value1, Value value2, Value value3) {
        return null;
    }

    public Value naryOperation(AbstractInsnNode insn, List<? extends Value> values) {
        switch (insn.getOpcode()) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                MethodInsnNode invoke = (MethodInsnNode)insn;
                return new Invoke(Type.getReturnType((String)invoke.desc), values);
            }
            case 186: {
                InvokeDynamicInsnNode invoke = (InvokeDynamicInsnNode)insn;
                return new Invoke(Type.getReturnType((String)invoke.desc), values);
            }
            case 197: {
                MultiANewArrayInsnNode arr = (MultiANewArrayInsnNode)insn;
                return new ArrayRef(Type.getType((String)arr.desc), values);
            }
        }
        throw new IllegalArgumentException("Invalid instruction opcode.");
    }

    public void returnOperation(AbstractInsnNode insn, Value value, Value expected) {
    }

    public Value merge(Value v, Value w) {
        if (v.getVariables().containsAll(w.getVariables()) && v.insns.containsAll(w.insns)) {
            return v;
        }
        if (w.getVariables().containsAll(v.getVariables()) && w.insns.containsAll(v.insns)) {
            return w;
        }
        HashSet<AbstractInsnNode> insns = new HashSet<AbstractInsnNode>();
        insns.addAll(v.insns);
        insns.addAll(w.insns);
        return new Merge(v.type, v, w, Collections.unmodifiableSet(insns));
    }
}

