/*
 * Decompiled with CFR 0.152.
 */
package br.usp.each.saeg.asm.defuse;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;

public class DefUseChain {
    public final int def;
    public final int use;
    public final int target;
    public final int var;

    public DefUseChain(int def, int use, int var) {
        this.def = def;
        this.use = use;
        this.var = var;
        this.target = -1;
    }

    public DefUseChain(int def, int use, int target, int var) {
        this.def = def;
        this.use = use;
        this.target = target;
        this.var = var;
    }

    public boolean isComputationalChain() {
        return this.target == -1;
    }

    public boolean isPredicateChain() {
        return this.target != -1;
    }

    public String toString() {
        if (this.isComputationalChain()) {
            return String.format("(%d, %d, %d)", this.def, this.use, this.var);
        }
        return String.format("(%d, (%d,%d), %d)", this.def, this.use, this.target, this.var);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefUseChain other = (DefUseChain)obj;
        return this.def == other.def && this.use == other.use && this.target == other.target && this.var == other.var;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.def;
        result = 31 * result + this.use;
        result = 31 * result + this.target;
        result = 31 * result + this.var;
        return result;
    }

    public static DefUseChain[] globals(DefUseChain[] chains, int[] leaders, int[][] basicBlocks) {
        int count = 0;
        DefUseChain[] globals = new DefUseChain[chains.length];
        for (DefUseChain c : chains) {
            if (!DefUseChain.isGlobal(c, leaders, basicBlocks)) continue;
            globals[count++] = c;
        }
        return Arrays.copyOf(globals, count);
    }

    public static DefUseChain[] toBasicBlock(DefUseChain[] chains, int[] leaders, int[][] basicBlocks) {
        int count = 0;
        DefUseChain[] bbChains = new DefUseChain[chains.length];
        for (DefUseChain c : chains) {
            if (!DefUseChain.isGlobal(c, leaders, basicBlocks)) continue;
            bbChains[count++] = new DefUseChain(leaders[c.def], leaders[c.use], c.isPredicateChain() ? leaders[c.target] : -1, c.var);
        }
        List<DefUseChain> l = Arrays.asList(Arrays.copyOf(bbChains, count));
        return new LinkedHashSet<DefUseChain>(l).toArray(new DefUseChain[0]);
    }

    public static boolean isGlobal(DefUseChain chain, int[] leaders, int[][] basicBlocks) {
        boolean global = true;
        if (chain.isComputationalChain() && leaders[chain.def] == leaders[chain.use]) {
            for (int i : basicBlocks[leaders[chain.def]]) {
                if (i == chain.use) break;
                if (i != chain.def) continue;
                global = false;
                break;
            }
        }
        return global;
    }
}

