/*
 * Decompiled with CFR 0.152.
 */
package br.usp.each.saeg.asm.defuse;

import br.usp.each.saeg.asm.defuse.DefUseFrame;
import br.usp.each.saeg.asm.defuse.DefUseInterpreter;
import br.usp.each.saeg.asm.defuse.FlowAnalyzer;
import br.usp.each.saeg.asm.defuse.Local;
import br.usp.each.saeg.asm.defuse.ObjectField;
import br.usp.each.saeg.asm.defuse.StaticField;
import br.usp.each.saeg.asm.defuse.Value;
import br.usp.each.saeg.asm.defuse.Variable;
import java.util.LinkedHashSet;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;

public class DefUseAnalyzer
extends FlowAnalyzer<Value> {
    private final DefUseInterpreter interpreter;
    private DefUseFrame[] duframes;
    private Variable[] variables;
    private int n;

    public DefUseAnalyzer() {
        this(new DefUseInterpreter());
    }

    private DefUseAnalyzer(DefUseInterpreter interpreter) {
        super(interpreter);
        this.interpreter = interpreter;
    }

    @Override
    public Frame<Value>[] analyze(String owner, MethodNode m) throws AnalyzerException {
        int i;
        this.n = m.instructions.size();
        this.duframes = new DefUseFrame[this.n];
        Frame<V>[] frames = super.analyze(owner, m);
        LinkedHashSet<Variable> vars = new LinkedHashSet<Variable>();
        Type[] args = Type.getArgumentTypes((String)m.desc);
        int local = 0;
        if ((m.access & 8) == 0) {
            Type ctype = Type.getObjectType((String)owner);
            vars.add(new Local(ctype, local++));
        }
        for (int i2 = 0; i2 < args.length; ++i2) {
            vars.add(new Local(args[i2], local++));
            if (args[i2].getSize() != 2) continue;
            ++local;
        }
        int nargs = (m.access & 8) == 0 ? args.length + 1 : args.length;
        block4: for (i = 0; i < this.n; ++i) {
            AbstractInsnNode insn = m.instructions.get(i);
            this.duframes[i] = frames[i] == null ? DefUseFrame.NONE : new DefUseFrame(frames[i], this.isPredicate(insn.getOpcode()));
            switch (insn.getType()) {
                case 8: 
                case 14: 
                case 15: {
                    continue block4;
                }
                default: {
                    if (this.duframes[i] == DefUseFrame.NONE) continue block4;
                    this.duframes[i].execute(insn, this.interpreter);
                    vars.addAll(this.duframes[i].getDefinitions());
                    vars.addAll(this.duframes[i].getUses());
                }
            }
        }
        for (i = 0; i < this.n; ++i) {
            if (this.duframes[i] == DefUseFrame.NONE) continue;
            this.reachDefs(m.instructions, i);
        }
        this.variables = vars.toArray(new Variable[vars.size()]);
        if ((m.access & 0x500) != 0) {
            return new Frame[0];
        }
        for (i = 0; i < this.variables.length; ++i) {
            Variable def = this.variables[i];
            if (i < nargs || def instanceof StaticField) {
                this.duframes[0].addDef(def);
                continue;
            }
            if (!(def instanceof ObjectField)) continue;
            ObjectField defField = (ObjectField)def;
            if (!this.duframes[0].getDefinitions().contains(defField.getRoot())) continue;
            this.duframes[0].addDef(def);
        }
        return frames;
    }

    private void reachDefs(InsnList instructions, int i) {
        for (Variable var : this.duframes[i].getUses()) {
            Value root;
            if (!(var instanceof ObjectField) || !((root = ((ObjectField)var).getRoot()) instanceof Local)) continue;
            Local l = (Local)root;
            for (AbstractInsnNode def : ((Value)this.duframes[i].getLocal((int)l.var)).insns) {
                int index = instructions.indexOf(def);
                this.duframes[index].addDef(var);
            }
        }
    }

    public DefUseFrame[] getDefUseFrames() {
        return this.duframes;
    }

    public Variable[] getVariables() {
        return this.variables;
    }

    private boolean isPredicate(int opcode) {
        if (opcode >= 153 && opcode <= 166) {
            return true;
        }
        return opcode == 170 || opcode == 171 || opcode == 198 || opcode == 199;
    }
}

