/*
 * Decompiled with CFR 0.152.
 */
package br.erlangms;

import br.erlangms.EmsConnection;
import br.erlangms.EmsService;
import br.erlangms.EmsUtil;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Logger;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class ErlangMSApplication
implements ServletContainerInitializer {
    private static List<EmsConnection> listServices = new ArrayList<EmsConnection>();
    private static final Logger logger = EmsUtil.logger;
    private static volatile boolean running = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void scanServicesSpringboot(String jarName, String packageName) {
        packageName = "BOOT-INF/classes/" + packageName.replaceAll("\\.", "/");
        try (JarInputStream jarFile = new JarInputStream(new FileInputStream(jarName));){
            while (true) {
                JarEntry jarEntry;
                if ((jarEntry = jarFile.getNextJarEntry()) == null) {
                    return;
                }
                try {
                    String classNamePath;
                    Class<?> serviceClass;
                    if (!jarEntry.getName().startsWith(packageName) || !jarEntry.getName().endsWith(".class") || !(serviceClass = Class.forName(classNamePath = jarEntry.getName().replaceAll("/", "\\.").replaceAll("^BOOT-INF.classes.", "").replaceAll(".class$", ""))).isAnnotationPresent(EmsService.class)) continue;
                    Object service = serviceClass.newInstance();
                    ErlangMSApplication.startService(service);
                }
                catch (Exception ex) {
                    logger.info("Ocorreu um erro ao iniciar " + jarEntry.getName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void scanServices(String packageName) {
        try {
            ClassLoader classLoader = ErlangMSApplication.class.getClassLoader();
            String packagePath = packageName.replace('.', '/');
            URL url = classLoader.getResource(packagePath);
            VirtualFile file = VFS.getChild((URL)url);
            List children = file.getChildrenRecursively();
            ArrayList<File> classes = new ArrayList<File>();
            for (VirtualFile virtualFile : children) {
                if (!virtualFile.isFile()) continue;
                URL urlFile = virtualFile.asFileURL();
                classes.add(new File(urlFile.getPath()));
            }
            if (classes != null && classes.size() > 0) {
                for (File classe : classes) {
                    try {
                        if (classe.isFile()) {
                            String pathClassSlash = classe.getPath().split("/classes/")[1];
                            String classWithoutClass = pathClassSlash.split(".class")[0];
                            String classNamePath = classWithoutClass.replaceAll("/", ".");
                            Class<?> serviceClass = Class.forName(classNamePath);
                            if (!serviceClass.isAnnotationPresent(EmsService.class)) continue;
                            Object service = serviceClass.newInstance();
                            ErlangMSApplication.startService(service);
                            continue;
                        }
                        ErlangMSApplication.scanServices(packageName + "." + classe.getName());
                    }
                    catch (Exception ex) {
                        logger.info("Ocorreu um erro ao iniciar " + classe.getName());
                    }
                }
            } else {
                String urlJar = url.toString().replaceAll("^jar:file:", "").replaceAll("!.*$", "");
                ErlangMSApplication.scanServicesSpringboot(urlJar, packagePath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void startService(Object service) {
        String classNameOfService = service.getClass().getName();
        EmsConnection connection1 = new EmsConnection(service, classNameOfService, false);
        connection1.start();
        listServices.add(connection1);
        if (EmsUtil.properties.isLinux) {
            EmsConnection connection2 = new EmsConnection(service, classNameOfService + "02", true);
            connection2.start();
            listServices.add(connection2);
        }
    }

    private void stopServices() {
        for (EmsConnection connection : listServices) {
            try {
                connection.close();
                connection.interrupt();
            }
            catch (Exception exception) {}
        }
    }

    public void destroy() {
        logger.info("Stopping services ErlangMS...");
        this.stopServices();
    }

    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        ErlangMSApplication.run();
    }

    public static void run() {
        if (running) {
            return;
        }
        running = true;
        logger.info("Start services ErlangMS from " + EmsUtil.properties.service_scan);
        ErlangMSApplication.scanServices(EmsUtil.properties.service_scan);
    }
}

