/*
 * Decompiled with CFR 0.152.
 */
package br.erlangms;

import br.erlangms.EmsJsonModelAdapter;
import br.erlangms.EmsUtil;
import br.erlangms.EmsValidationException;
import br.erlangms.IEmsRequest;
import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangBinary;
import com.ericsson.otp.erlang.OtpErlangLong;
import com.ericsson.otp.erlang.OtpErlangMap;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangRangeException;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmsRequest
implements IEmsRequest {
    private OtpErlangTuple otp_request = null;
    private static OtpErlangAtom undefined = new OtpErlangAtom("undefined");
    private Map<String, Object> properties = null;
    private int queryCount = -1;
    private long rid = 0L;
    private long timeout = 0L;
    private long t1 = 0L;
    private boolean isPostOrUpdateRequestFlag = false;
    private String method = null;
    private String url = null;
    private Map<String, Object> userJson = null;
    private Map<String, Object> clientJson = null;
    private String contentType = null;
    private String modulo = null;
    private String function = null;
    private String payload = null;
    private int paramCount = 0;
    private String access_token;
    private String scope;

    public EmsRequest(OtpErlangTuple otp_request) {
        this.setOtpRequest(otp_request);
    }

    public EmsRequest() {
    }

    public void setOtpRequest(OtpErlangTuple otp_request) {
        this.otp_request = otp_request;
        this.properties = null;
        this.queryCount = -1;
        this.rid = ((OtpErlangLong)otp_request.elementAt(0)).longValue();
        this.timeout = ((OtpErlangLong)otp_request.elementAt(14)).longValue();
        this.t1 = ((OtpErlangLong)otp_request.elementAt(13)).longValue();
        this.method = ((OtpErlangString)otp_request.elementAt(2)).stringValue();
        this.url = ((OtpErlangString)otp_request.elementAt(1)).stringValue();
        this.isPostOrUpdateRequestFlag = this.method.equals("POST") || this.method.equals("PUT");
        this.contentType = new String(((OtpErlangBinary)otp_request.elementAt(6)).binaryValue());
        this.modulo = ((OtpErlangString)otp_request.elementAt(7)).stringValue();
        this.function = ((OtpErlangString)otp_request.elementAt(8)).stringValue();
        this.payload = new String(((OtpErlangBinary)otp_request.elementAt(5)).binaryValue());
        this.paramCount = ((OtpErlangMap)otp_request.elementAt(3)).arity();
        this.userJson = null;
        this.clientJson = null;
        OtpErlangObject OAuth2FieldObj = otp_request.elementAt(12);
        if (OAuth2FieldObj != null && OAuth2FieldObj instanceof OtpErlangTuple) {
            OtpErlangTuple OAuth2Field = (OtpErlangTuple)OAuth2FieldObj;
            if (OAuth2Field != null) {
                this.scope = new String(((OtpErlangBinary)OAuth2Field.elementAt(1)).binaryValue());
                this.access_token = new String(((OtpErlangBinary)OAuth2Field.elementAt(1)).binaryValue());
            }
        } else {
            this.scope = "";
            this.access_token = "";
        }
    }

    @Override
    public long getRID() {
        return this.rid;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getMetodo() {
        return this.method;
    }

    @Override
    public int getParamsCount() {
        return this.paramCount;
    }

    @Override
    public String getParam(String nome) {
        if (nome == null) {
            throw new EmsValidationException("Propriedade nome n\u00e3o pode ser null para EmsRequest.getParam.");
        }
        try {
            if (this.getParamsCount() > 0) {
                OtpErlangBinary OtpNomeParam;
                OtpErlangMap params = (OtpErlangMap)this.otp_request.elementAt(3);
                OtpErlangLong otp_result = (OtpErlangLong)params.get((OtpErlangObject)(OtpNomeParam = new OtpErlangBinary(nome.getBytes())));
                if (otp_result != null) {
                    String result = Integer.toString(otp_result.intValue());
                    return result;
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            throw new EmsValidationException("N\u00e3o foi poss\u00edvel obter o par\u00e2metro " + nome + " do request.");
        }
    }

    @Override
    public int getParamAsInt(String nome) {
        OtpErlangMap params = (OtpErlangMap)this.otp_request.elementAt(3);
        OtpErlangBinary OtpNomeParam = new OtpErlangBinary(nome.getBytes());
        OtpErlangLong otp_result = (OtpErlangLong)params.get((OtpErlangObject)OtpNomeParam);
        try {
            return otp_result.intValue();
        }
        catch (OtpErlangRangeException e) {
            throw new EmsValidationException("Par\u00e2metro " + nome + " n\u00e3o \u00e9 inteiro.");
        }
    }

    @Override
    public double getParamAsDouble(String nome) {
        try {
            return Double.parseDouble(this.getParam(nome));
        }
        catch (Exception e) {
            throw new EmsValidationException("N\u00e3o foi poss\u00edvel converter o par\u00e2metro " + nome + " no tipo double do request.");
        }
    }

    @Override
    public Date getParamAsDate(String nome) throws ParseException {
        try {
            return new SimpleDateFormat("dd/mm/yyyy").parse(this.getParam(nome));
        }
        catch (Exception e) {
            throw new EmsValidationException("N\u00e3o foi poss\u00edvel converter o par\u00e2metro " + nome + " no tipo Date do request.");
        }
    }

    @Override
    public int getQueryCount() {
        if (this.queryCount != -1) {
            return this.queryCount;
        }
        try {
            OtpErlangObject Querystring = this.otp_request.elementAt(4);
            this.queryCount = !Querystring.equals((Object)undefined) ? ((OtpErlangMap)Querystring).arity() : 0;
            return this.queryCount;
        }
        catch (Exception e) {
            throw new EmsValidationException("N\u00e3o foi poss\u00edvel obter a quantidade de queries do request.");
        }
    }

    @Override
    public String getQuery(String nome) {
        if (nome == null) {
            throw new EmsValidationException("Propriedade nome n\u00e3o pode ser null para EmsRequest.getQuery.");
        }
        if (this.getQueryCount() > 0) {
            try {
                OtpErlangMap Queries = (OtpErlangMap)this.otp_request.elementAt(4);
                OtpErlangBinary OtpNome = new OtpErlangBinary(nome.getBytes());
                OtpErlangBinary otp_result = (OtpErlangBinary)Queries.get((OtpErlangObject)OtpNome);
                if (otp_result != null) {
                    String result = new String(otp_result.binaryValue());
                    return result;
                }
                return null;
            }
            catch (Exception e) {
                throw new EmsValidationException("N\u00e3o foi poss\u00edvel obter a query " + nome + " do request.");
            }
        }
        throw new EmsValidationException("N\u00e3o existe a query " + nome + " do request.");
    }

    @Override
    public String getQuery(String nome, String defaultValue) {
        if (nome == null) {
            throw new EmsValidationException("Propriedade nome n\u00e3o pode ser null para EmsRequest.getQuery.");
        }
        if (this.getQueryCount() > 0) {
            try {
                OtpErlangMap Queries = (OtpErlangMap)this.otp_request.elementAt(4);
                OtpErlangBinary OtpNome = new OtpErlangBinary(nome.getBytes());
                OtpErlangBinary otp_result = (OtpErlangBinary)Queries.get((OtpErlangObject)OtpNome);
                if (otp_result != null) {
                    String result = new String(otp_result.binaryValue(), "ISO-8859-1");
                    return result;
                }
                return defaultValue;
            }
            catch (Exception e) {
                throw new EmsValidationException("N\u00e3o foi poss\u00edvel obter a query " + nome + " do request.");
            }
        }
        throw new EmsValidationException("N\u00e3o existe a query " + nome + " do request.");
    }

    @Override
    public int getQueryAsInt(String nome) {
        try {
            return Integer.parseInt(this.getQuery(nome));
        }
        catch (Exception e) {
            throw new EmsValidationException("N\u00e3o foi poss\u00edvel converter a query " + nome + " para int do request.");
        }
    }

    @Override
    public int getQueryAsInt(String nome, int defaultValue) {
        try {
            String result = this.getQuery(nome);
            if (result != null) {
                return Integer.parseInt(result);
            }
            return defaultValue;
        }
        catch (Exception e) {
            throw new EmsValidationException("N\u00e3o foi poss\u00edvel converter a query " + nome + " para int do request.");
        }
    }

    @Override
    public double getQueryAsDouble(String nome) {
        try {
            return Double.parseDouble(this.getQuery(nome));
        }
        catch (Exception e) {
            throw new EmsValidationException("N\u00e3o foi poss\u00edvel converter a query " + nome + " para double do request.");
        }
    }

    @Override
    public double getQueryAsDouble(String nome, double defaultValue) {
        try {
            String result = this.getQuery(nome);
            if (result != null) {
                return Double.parseDouble(result);
            }
            return defaultValue;
        }
        catch (Exception e) {
            throw new EmsValidationException("N\u00e3o foi poss\u00edvel converter a query " + nome + " para double do request.");
        }
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    public <T> T getObject(Class<T> classOfObj) {
        return this.getObject(classOfObj, null);
    }

    @Override
    public <T> T getObject(Class<T> classOfObj, EmsJsonModelAdapter jsonModelAdapter) {
        try {
            return EmsUtil.fromJson(this.getPayload(), classOfObj, jsonModelAdapter);
        }
        catch (Exception e) {
            throw new EmsValidationException(e.getMessage());
        }
    }

    @Override
    public Map<String, Object> getObject() {
        return this.getPayloadAsMap();
    }

    @Override
    public Object getProperty(String nome) {
        if (nome == null) {
            throw new EmsValidationException("Propriedade nome n\u00e3o pode ser null para EmsRequest.getProperty.");
        }
        if (this.properties == null) {
            throw new EmsValidationException("Propriedade " + nome + " n\u00e3o existe na requisi\u00e7\u00e3o.");
        }
        if (this.properties.containsKey(nome)) {
            return this.properties.get(nome);
        }
        throw new EmsValidationException("Propriedade " + nome + " n\u00e3o existe na requisi\u00e7\u00e3o.");
    }

    @Override
    public Object getProperty(String nome, Object defaultValue) {
        if (nome == null) {
            throw new EmsValidationException("Propriedade nome n\u00e3o pode ser null para EmsRequest.getProperty.");
        }
        if (this.properties == null) {
            throw new EmsValidationException("Propriedade " + nome + " n\u00e3o existe na requisi\u00e7\u00e3o.");
        }
        return this.properties.getOrDefault(nome, defaultValue);
    }

    @Override
    public void setProperty(String nome, Object value) {
        if (nome == null) {
            throw new EmsValidationException("Propriedade nome n\u00e3o pode ser null para EmsRequest.setProperty.");
        }
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(nome, value);
    }

    @Override
    public Map<String, Object> getPayloadAsMap() {
        try {
            return EmsUtil.fromJson(this.getPayload(), HashMap.class);
        }
        catch (Exception e) {
            throw new EmsValidationException("N\u00e3o foi poss\u00edvel converter o payload do request em um objeto da interface java.util.Map. Erro interno: " + e.getMessage());
        }
    }

    @Override
    public List<Map<String, Object>> getPayloadAsList() {
        try {
            return EmsUtil.fromJson(this.getPayload(), List.class);
        }
        catch (Exception e) {
            throw new EmsValidationException("N\u00e3o foi poss\u00edvel converter o payload do request em um objeto da interface java.util.List. Erro interno: " + e.getMessage());
        }
    }

    @Override
    public <T> T getPayloadAsArray(Class<T> classOfArray) {
        try {
            String payload = this.getPayload();
            return (T)EmsUtil.gson.fromJson(payload, classOfArray);
        }
        catch (Exception e) {
            throw new EmsValidationException("N\u00e3o foi poss\u00edvel converter o payload do request em uma lista de objetos. Erro interno: " + e.getMessage());
        }
    }

    @Override
    public <T> List<T> getPayloadAsList(Class<T[]> classOfArray) {
        T[] result = this.getPayloadAsArray(classOfArray);
        return Arrays.asList(result);
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getModulo() {
        return this.modulo;
    }

    @Override
    public String getFunction() {
        return this.function;
    }

    @Override
    public OtpErlangObject getOtpRequest() {
        return this.otp_request;
    }

    @Override
    public Object mergeObjectFromPayload(Object obj) {
        return this.mergeObjectFromPayload(obj, null);
    }

    @Override
    public Object mergeObjectFromPayload(Object obj, EmsJsonModelAdapter emsJsonModelSerialize) {
        if (obj != null) {
            Map update_values = this.getObject(HashMap.class);
            EmsUtil.setValuesFromMap(obj, update_values, emsJsonModelSerialize);
            return obj;
        }
        return null;
    }

    @Override
    public Map<String, Object> getClient() {
        if (this.clientJson == null) {
            try {
                String clientJsonString = new String(((OtpErlangBinary)this.otp_request.elementAt(9)).binaryValue());
                this.clientJson = EmsUtil.fromJson(clientJsonString, HashMap.class);
            }
            catch (Exception e) {
                throw new EmsValidationException("N\u00e3o foi poss\u00edvel obter o client do request. Erro interno: " + e.getMessage());
            }
        }
        return this.clientJson;
    }

    @Override
    public Map<String, Object> getUser() {
        if (this.userJson == null) {
            try {
                String userJsonString = new String(((OtpErlangBinary)this.otp_request.elementAt(10)).binaryValue());
                this.userJson = EmsUtil.fromJson(userJsonString, HashMap.class);
            }
            catch (Exception e) {
                throw new EmsValidationException("N\u00e3o foi poss\u00edvel obter o user do request. Erro interno: " + e.getMessage());
            }
        }
        return this.userJson;
    }

    @Override
    public Map<String, Object> getCatalog() {
        try {
            String catalogJson = new String(((OtpErlangBinary)this.otp_request.elementAt(11)).binaryValue());
            return EmsUtil.fromJson(catalogJson, HashMap.class);
        }
        catch (Exception e) {
            throw new EmsValidationException("N\u00e3o foi poss\u00edvel obter o cat\u00e1logo do request. Erro interno: " + e.getMessage());
        }
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public String getAccessToken() {
        return this.access_token;
    }

    @Override
    public long getT1() {
        return this.t1;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public boolean isPostOrUpdateRequest() {
        return this.isPostOrUpdateRequestFlag;
    }
}

