/*
 * Decompiled with CFR 0.152.
 */
package br.erlangms;

import br.erlangms.EmsNotFoundException;
import br.erlangms.EmsRequest;
import br.erlangms.EmsResponse;
import br.erlangms.EmsUtil;
import br.erlangms.EmsValidationException;
import br.erlangms.IEmsRequest;
import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangBinary;
import com.ericsson.otp.erlang.OtpErlangExit;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.ericsson.otp.erlang.OtpMbox;
import com.ericsson.otp.erlang.OtpNode;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.logging.Logger;
import javax.ejb.EJBException;

public class EmsConnection
extends Thread {
    public static final OtpErlangAtom ok_atom = new OtpErlangAtom("ok");
    private static final EmsUtil.EmsProperties properties = EmsUtil.properties;
    private static final OtpErlangBinary result_ok = EmsUtil.result_ok;
    private static final Logger logger = EmsUtil.logger;
    private static boolean erro_connection_epmd = false;
    private static final int THREAD_WAIT_TO_RESTART = 5000;
    private static final String connectionErrorMessage = "N\u00e3o foi poss\u00edvel conectar no barramento. Verifique se o servidor de nome epmd foi iniciado.";
    private final String nameService;
    private final Object service;
    private Class<? extends Object> classOfservice;
    private Method[] methods;
    private String[] method_names;
    private int method_count = 0;
    private String otpNodeName;
    private static OtpNode myNodeWin = null;
    private OtpNode myNodeLinux = null;
    private OtpMbox myMbox = null;
    private boolean isLinux = true;
    private boolean isSlave = false;
    private static Semaphore sem = new Semaphore(1, true);

    public EmsConnection(Object service, String otpNodeName, boolean isSlave) {
        this.isLinux = EmsUtil.properties.isLinux;
        this.setSlave(isSlave);
        this.service = service;
        this.classOfservice = service.getClass();
        this.nameService = this.classOfservice.getName();
        this.otpNodeName = this.isLinux ? otpNodeName.replace(".", "_") + "_" + EmsConnection.properties.nodeName : EmsConnection.properties.nodeName;
        this.getMethodNamesTable();
    }

    private void getMethodNamesTable() {
        Method[] allMethods = this.classOfservice.getMethods();
        this.methods = new Method[allMethods.length];
        this.method_names = new String[allMethods.length];
        for (Method m : allMethods) {
            Class<?>[] params;
            if (m.getParameterCount() != 1 || (params = m.getParameterTypes())[0] != IEmsRequest.class) continue;
            this.methods[this.method_count] = m;
            this.method_names[this.method_count] = m.getName();
            m.setAccessible(true);
            ++this.method_count;
        }
    }

    public void close() {
        try {
            if (this.myMbox != null) {
                this.myMbox.close();
            }
            if (this.isLinux) {
                if (this.myNodeLinux != null) {
                    this.myNodeLinux.close();
                }
            } else if (myNodeWin != null) {
                myNodeWin.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void createNode() throws InterruptedException {
        if (this.isLinux) {
            while (true) {
                Random r = new Random();
                try {
                    this.myNodeLinux = new OtpNode(this.otpNodeName);
                    this.myNodeLinux.setCookie(EmsConnection.properties.cookie);
                    return;
                }
                catch (IOException e) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    if (!erro_connection_epmd) {
                        erro_connection_epmd = true;
                        logger.warning(connectionErrorMessage);
                    }
                    try {
                        Thread.sleep(3 + r.nextInt(7));
                        continue;
                    }
                    catch (InterruptedException e1) {
                        if (Thread.interrupted()) throw e1;
                        continue;
                    }
                }
                break;
            }
        }
        try {
            sem.acquire();
            if (myNodeWin != null) {
                sem.release();
                return;
            }
            while (true) {
                Random r = new Random();
                try {
                    myNodeWin = new OtpNode(this.otpNodeName);
                    myNodeWin.setCookie(EmsConnection.properties.cookie);
                    sem.release();
                    return;
                }
                catch (IOException e) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    if (!erro_connection_epmd) {
                        erro_connection_epmd = true;
                        logger.warning(connectionErrorMessage);
                    }
                    try {
                        Thread.sleep(3 + r.nextInt(7));
                        continue;
                    }
                    catch (InterruptedException e1) {
                        if (Thread.interrupted()) throw e1;
                        continue;
                    }
                }
                break;
            }
        }
        catch (InterruptedException e) {
            this.createNode();
        }
    }

    public synchronized void sendResult(OtpErlangPid from, OtpErlangTuple response) {
        this.myMbox.send(from, (OtpErlangObject)response);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        StringBuilder msg_task = new StringBuilder();
        ExecutorService pool = Executors.newCachedThreadPool();
        String msgFinalizadoSucesso = this.nameService + " finalizado com sucesso.";
        String msgReiniciarException = "Servi\u00e7o " + this.nameService + " ser\u00e1 reiniciado devido erro interno: ";
        int PostUpdateTimeout = EmsUtil.properties.postUpdateTimeout;
        while (true) {
            try {
                this.createNode();
                if (this.isLinux) {
                    this.myMbox = this.myNodeLinux.createMbox(this.nameService);
                    logger.info(this.nameService + " node -> " + this.myNodeLinux.node());
                } else {
                    this.myMbox = myNodeWin.createMbox(this.nameService);
                    logger.info(this.nameService + " node -> " + myNodeWin.node());
                }
                while (true) {
                    try {
                        while (true) {
                            if (Thread.interrupted()) {
                                throw new InterruptedException();
                            }
                            EmsRequest request = new EmsRequest();
                            msg_task.setLength(0);
                            msg_task.append(this.otpNodeName).append(" [ ");
                            OtpErlangObject myObject = this.myMbox.receive();
                            OtpErlangTuple myMsg = (OtpErlangTuple)myObject;
                            OtpErlangTuple otp_request = (OtpErlangTuple)myMsg.elementAt(0);
                            request.setOtpRequest(otp_request);
                            Long T2 = System.currentTimeMillis() - request.getT1();
                            if (this.isLinux && request.getTimeout() > 0L && (T2 > request.getTimeout() || T2 > (long)PostUpdateTimeout && request.isPostOrUpdateRequest())) {
                                logger.info("Servi\u00e7o " + this.nameService + "." + request.getMetodo() + " descartou mensagem devido timeout.");
                                continue;
                            }
                            OtpErlangPid dispatcherPid = (OtpErlangPid)myMsg.elementAt(1);
                            if (request.getTimeout() > 0L) {
                                this.myMbox.send(dispatcherPid, (OtpErlangObject)ok_atom);
                            }
                            pool.submit(new Task(dispatcherPid, request, this));
                            msg_task.append(request.getMetodo()).append(" ").append(request.getFunction()).append(" RID: ").append(request.getRID()).append("  Url: ").append(request.getUrl()).append("  T2: ").append(Long.toString(T2)).append(" ]");
                            logger.info(msg_task.toString());
                        }
                    }
                    catch (OtpErlangExit e3) {
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        try {
                            Thread.sleep(5000L);
                            continue;
                        }
                        catch (InterruptedException e1) {
                            if (Thread.interrupted()) throw e1;
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (InterruptedException e2) {
                this.close();
                logger.info(msgFinalizadoSucesso);
                return;
            }
            catch (Exception e) {
                logger.warning(msgReiniciarException + e.getMessage());
                e.printStackTrace();
                this.close();
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    if (Thread.interrupted()) return;
                    continue;
                }
            }
            break;
        }
    }

    private Object chamaMetodo(String modulo, String metodo, IEmsRequest request) {
        Method m = null;
        Object result = null;
        String msg_json = null;
        try {
            for (int i = 0; i < this.method_count; ++i) {
                if (!metodo.equals(this.method_names[i])) continue;
                m = this.methods[i];
                break;
            }
            if (m == null) {
                m = this.classOfservice.getMethod(metodo, new Class[0]);
                m.setAccessible(true);
            }
            if (m.getReturnType().getName().equals("void")) {
                m.invoke(this.service, request);
                return result_ok;
            }
            result = m.invoke(this.service, request);
            return result;
        }
        catch (NoSuchMethodException e) {
            String erro = "M\u00e9todo da camada de servi\u00e7o n\u00e3o encontrado: " + metodo + ".";
            msg_json = "{\"error\":\"validation\", \"message\" : \"" + erro + "\"}";
            logger.info(erro);
            return new EmsResponse(400, msg_json);
        }
        catch (IllegalAccessException e) {
            String erro = "Acesso ilegal ao m\u00e9todo da camada de servi\u00e7o: " + metodo + ".";
            msg_json = "{\"error\":\"validation\", \"message\" : \"" + erro + "\"}";
            logger.info(erro);
            return new EmsResponse(400, msg_json);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                if (cause instanceof EmsValidationException) {
                    List<String> errors = ((EmsValidationException)cause).getErrors();
                    String msg = null;
                    if (errors.size() > 1) {
                        msg = EmsUtil.toJson(errors);
                        msg_json = "{\"error\":\"validation\", \"message\" : " + msg + "}";
                    } else if (errors.size() == 1) {
                        msg = EmsUtil.toJson(errors.get(0));
                        msg_json = "{\"error\":\"validation\", \"message\" : " + msg + "}";
                    } else {
                        msg_json = "{\"error\":\"validation\", \"message\" : \"\"}";
                    }
                    return new EmsResponse(400, msg_json);
                }
                if (cause instanceof EmsNotFoundException) {
                    msg_json = "{\"error\":\"enoent\", \"message\" : " + EmsUtil.toJson(cause.getMessage()) + "}";
                    return new EmsResponse(404, msg_json);
                }
                if (cause instanceof EJBException) {
                    try {
                        Exception causeEx = ((EJBException)cause).getCausedByException();
                        if (causeEx != null && causeEx.getCause() != null) {
                            cause = causeEx.getCause();
                            if (causeEx.getCause().getCause() != null) {
                                cause = causeEx.getCause().getCause();
                            }
                        }
                        String motivo = null;
                        int posMsgSql = cause.getMessage().toLowerCase().indexOf("unique index");
                        motivo = posMsgSql != -1 ? "Registro duplicado, verifique." : ((posMsgSql = cause.getMessage().indexOf("; SQL statement:")) > 0 ? cause.getMessage().substring(0, posMsgSql - 1) : cause.getMessage());
                        msg_json = "{\"error\":\"validation\", \"message\" : " + EmsUtil.toJson(motivo) + "}";
                        return new EmsResponse(400, msg_json);
                    }
                    catch (Exception ex) {
                        String erro = "O m\u00e9todo " + modulo + "." + metodo + " gerou um erro: " + e.getCause() + ".";
                        msg_json = "{\"error\":\"validation\", \"message\" : \"" + erro + "\"}";
                        logger.info(erro);
                        return new EmsResponse(400, msg_json);
                    }
                }
                Throwable target = e.getTargetException();
                msg_json = "{\"error\":\"validation\", \"message\" : \"Requisi\u00e7\u00e3o inv\u00e1lida.\"}";
                if (target != null) {
                    cause = e.getCause();
                    if (cause != null) {
                        String erro = "O m\u00e9todo " + modulo + "." + metodo + " gerou um erro: " + cause.getMessage() + ".";
                        logger.info(erro);
                        return new EmsResponse(404, msg_json);
                    }
                    String erro = "O m\u00e9todo " + modulo + "." + metodo + " gerou um erro: " + e.getMessage() + ".";
                    logger.info(erro);
                    return new EmsResponse(404, msg_json);
                }
                String erro = "O m\u00e9todo " + modulo + "." + metodo + " gerou um erro: " + e.getMessage() + ".";
                logger.info(erro);
                return new EmsResponse(404, msg_json);
            }
            String erro = "O m\u00e9todo " + modulo + "." + metodo + " gerou um erro: " + e.getCause() + ".";
            msg_json = "{\"error\":\"validation\", \"message\" : \"Requisi\u00e7\u00e3o inv\u00e1lida.\"}";
            logger.info(erro);
            return new EmsResponse(400, msg_json);
        }
    }

    public boolean isSlave() {
        return this.isSlave;
    }

    public void setSlave(boolean isSlave) {
        this.isSlave = isSlave;
    }

    private final class Task
    implements Callable<Boolean> {
        private OtpErlangPid from;
        private IEmsRequest request;
        private EmsConnection connection;

        public Task(OtpErlangPid from, IEmsRequest request, EmsConnection connection) {
            this.from = from;
            this.request = request;
            this.connection = connection;
        }

        @Override
        public Boolean call() {
            Object ret = EmsConnection.this.chamaMetodo(this.request.getModulo(), this.request.getFunction(), this.request);
            if (this.request.getRID() > 0L) {
                Long T3 = System.currentTimeMillis() - this.request.getT1();
                if (EmsConnection.this.isLinux && this.request.getTimeout() > 0L) {
                    if (T3 < this.request.getTimeout()) {
                        OtpErlangTuple response = EmsUtil.serializeObjectToErlangResponse(ret, this.request);
                        this.connection.sendResult(this.from, response);
                    } else {
                        logger.info("Servi\u00e7o " + EmsConnection.this.nameService + "." + this.request.getMetodo() + " descartou envio do resultado ap\u00f3s timeout.");
                    }
                } else {
                    OtpErlangTuple response = EmsUtil.serializeObjectToErlangResponse(ret, this.request);
                    this.connection.sendResult(this.from, response);
                }
            }
            return true;
        }
    }
}

