/*
 * Decompiled with CFR 0.152.
 */
package br.erlangms;

import br.erlangms.EmsJsonModelAdapter;
import br.erlangms.EmsNotFoundException;
import br.erlangms.EmsResponse;
import br.erlangms.EmsValidationException;
import br.erlangms.IEmsRequest;
import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangBinary;
import com.ericsson.otp.erlang.OtpErlangInt;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangLong;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.persistence.Column;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Query;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.swing.text.MaskFormatter;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.util.JRFontNotFoundException;
import net.sf.jasperreports.engine.util.JRLoader;
import org.hibernate.Hibernate;
import org.hibernate.proxy.HibernateProxy;

public final class EmsUtil {
    public static final OtpErlangAtom ok_atom = new OtpErlangAtom("ok");
    public static final OtpErlangAtom error_atom = new OtpErlangAtom("error");
    public static final OtpErlangAtom request_msg_atom = new OtpErlangAtom("request");
    public static final OtpErlangBinary result_null = new OtpErlangBinary("{\"ok\":\"null\"}".getBytes());
    public static final OtpErlangBinary erro_convert_json = new OtpErlangBinary("{\"erro\":\"service\", \"message\" : \"Falha na serializa\u00e7\u00e3o do conte\u00fado em JSON\"}".getBytes());
    public static final OtpErlangBinary result_list_empty = new OtpErlangBinary("[]".getBytes());
    public static final OtpErlangBinary result_ok = new OtpErlangBinary("{\"ok\":\"ok\"}".getBytes());
    public static final Logger logger = Logger.getLogger("erlangms");
    private static NumberFormat doubleFormatter = null;
    public static Gson gson = null;
    private static Gson gson2 = null;
    public static EmsProperties properties = null;
    private static final SimpleDateFormat dateFormatDDMMYYYY = new SimpleDateFormat("dd/MM/yyyy");
    private static final SimpleDateFormat dateFormatDDMMYYYY_HHmm = new SimpleDateFormat("dd/MM/yyyy HH:mm");
    private static final SimpleDateFormat dateFormatDDMMYYYY_HHmmss = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private static final SimpleDateFormat dateFormatYYYYMMDD = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat dateFormatYYYYMMDD_HHmm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final SimpleDateFormat dateFormatYYYYMMDD_HHmmss = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static MessageDigest messageDigestSHA1 = null;
    private static Base64.Encoder base64Encoder = null;
    private static final String HEX = "0123456789ABCDEF";
    private static final String seed = "LDAPCorp_pwdupdate";
    private static String[] args = null;

    public static boolean isAnyParameterAnnotated(Method method, Class<?> annotationType) {
        Annotation[][] paramAnnotations;
        Annotation[][] annotationArray = paramAnnotations = method.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotations;
            for (Annotation an : annotations = annotationArray[i]) {
                if (!an.annotationType().equals(annotationType)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getClassAnnotationValue(Class classType, Class annotationType, String attributeName) {
        String value = null;
        Object annotation = classType.getAnnotation(annotationType);
        if (annotation != null) {
            try {
                value = (String)annotation.annotationType().getMethod(attributeName, new Class[0]).invoke(annotation, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public static String toJson(Object obj) {
        return EmsUtil.toJson(obj, false);
    }

    public static String toJson(Object obj, boolean serializeFullObject) {
        if (obj != null) {
            String result = null;
            result = serializeFullObject ? gson2.toJson(obj) : gson.toJson(obj);
            return result;
        }
        return null;
    }

    public static <T> T fromJson(String jsonString, Class<T> classOfObj) {
        return EmsUtil.fromJson(jsonString, classOfObj, null);
    }

    public static <T> T fromJson(String jsonString, Class<T> classOfObj, EmsJsonModelAdapter jsonModelAdapter) {
        if (classOfObj != null) {
            try {
                if (jsonString != null && !jsonString.isEmpty()) {
                    if (classOfObj == List.class || classOfObj == ArrayList.class) {
                        List values = (List)gson.fromJson(jsonString, List.class);
                        return (T)values;
                    }
                    if (classOfObj == HashMap.class || classOfObj == Map.class) {
                        Map values = (Map)gson.fromJson(jsonString, Map.class);
                        return (T)values;
                    }
                    Map values = (Map)gson.fromJson(jsonString, Map.class);
                    T obj = null;
                    try {
                        obj = classOfObj.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (EmsValidationException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        throw new EmsValidationException("N\u00e3o suporta convers\u00e3o do json da classe " + classOfObj.getSimpleName() + ". Json: " + jsonString);
                    }
                    EmsUtil.setValuesFromMap(obj, values, jsonModelAdapter);
                    return obj;
                }
                return classOfObj.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (JsonSyntaxException e) {
                throw new EmsValidationException("Sint\u00e1xe do JSON inv\u00e1lida.");
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new EmsValidationException("N\u00e3o suporta inst\u00e2nciar objeto para a classe " + classOfObj.getSimpleName());
            }
        }
        throw new EmsValidationException("Par\u00e2metro classOfObj do m\u00e9todo EmsUtil.fromJson n\u00e3o deve ser null.");
    }

    public static <T> List<T> fromListJson(String jsonString, Class<T> classOfObj) {
        return EmsUtil.fromListJson(jsonString, classOfObj, null);
    }

    public static <T> List<T> fromListJson(String jsonString, Class<T> classOfObj, EmsJsonModelAdapter jsonModelAdapter) {
        if (classOfObj != null) {
            ArrayList<T> newList = new ArrayList<T>();
            if (jsonString != null && !jsonString.isEmpty()) {
                List values;
                try {
                    values = (List)gson.fromJson(jsonString, List.class);
                }
                catch (JsonSyntaxException e) {
                    throw new EmsValidationException("Sint\u00e1xe do JSON inv\u00e1lida.");
                }
                for (Object value : values) {
                    try {
                        T obj = classOfObj.getConstructor(new Class[0]).newInstance(new Object[0]);
                        EmsUtil.setValuesFromMap(obj, (Map)value, jsonModelAdapter);
                        newList.add(obj);
                    }
                    catch (Exception e) {
                        throw new EmsValidationException("N\u00e3o suporta convers\u00e3o do json para " + classOfObj.getSimpleName() + ". Json: " + jsonString);
                    }
                }
            }
            return newList;
        }
        throw new EmsValidationException("Par\u00e2metro classOfObj do m\u00e9todo EmsUtil.fromListJson n\u00e3o deve ser null.");
    }

    public static void setQueryParameterFromMap(Query query, Map<String, Object> values) {
        if (query != null && values != null && values.size() > 0) {
            int p = 1;
            for (String field : values.keySet()) {
                try {
                    String field_op;
                    String field_name;
                    String[] field_defs = field.split("__");
                    int field_len = field_defs.length;
                    if (field_len == 1) {
                        field_name = field_defs[0];
                        field_op = "=";
                    } else if (field_len == 2) {
                        field_name = field_defs[0];
                        field_op = field_defs[1];
                        if (field_op.equals("isnull")) {
                            continue;
                        }
                    } else {
                        throw new EmsValidationException("Campo de pesquisa " + field + " inv\u00e1lido");
                    }
                    Object value_field = values.get(field);
                    Class<?> paramType = query.getParameter(p).getParameterType();
                    if (paramType == null) {
                        paramType = value_field instanceof ArrayList ? ((ArrayList)value_field).get(0).getClass() : value_field.getClass();
                    }
                    if (paramType == Integer.class) {
                        if (value_field instanceof String) {
                            query.setParameter(p++, (Object)Integer.parseInt((String)value_field));
                            continue;
                        }
                        if (value_field instanceof Double) {
                            query.setParameter(p++, (Object)((Double)value_field).intValue());
                            continue;
                        }
                        if (value_field instanceof ArrayList) {
                            ArrayList<Integer> value_field_parameter = new ArrayList<Integer>();
                            if (((ArrayList)value_field).size() > 0) {
                                if (((ArrayList)value_field).get(0) instanceof String) {
                                    for (String string : (ArrayList)value_field) {
                                        value_field_parameter.add(Integer.parseInt(string));
                                    }
                                } else if (((ArrayList)value_field).get(0) instanceof Double) {
                                    for (Double doubleValue : (ArrayList)value_field) {
                                        value_field_parameter.add(doubleValue.intValue());
                                    }
                                }
                            }
                            query.setParameter(p++, value_field_parameter);
                            continue;
                        }
                        query.setParameter(p++, value_field);
                        continue;
                    }
                    if (paramType == BigDecimal.class) {
                        if (value_field instanceof String) {
                            query.setParameter(p++, (Object)BigDecimal.valueOf(Double.parseDouble((String)value_field)));
                            continue;
                        }
                        query.setParameter(p++, (Object)BigDecimal.valueOf((Double)value_field));
                        continue;
                    }
                    if (paramType == Double.class || paramType == Double.TYPE) {
                        if (value_field instanceof ArrayList) {
                            ArrayList<Double> value_field_parameter = new ArrayList<Double>();
                            if (((ArrayList)value_field).size() > 0) {
                                if (((ArrayList)value_field).get(0) instanceof String) {
                                    for (String string : (ArrayList)value_field) {
                                        value_field_parameter.add(Double.valueOf(string));
                                    }
                                } else if (((ArrayList)value_field).get(0) instanceof Double) {
                                    for (Double doubleValue : (ArrayList)value_field) {
                                        value_field_parameter.add(doubleValue);
                                    }
                                }
                            }
                            query.setParameter(p++, value_field_parameter);
                            continue;
                        }
                        double valueDouble = EmsUtil.parseAsDouble(value_field);
                        query.setParameter(p++, (Object)valueDouble);
                        continue;
                    }
                    if (paramType == String.class) {
                        String valueString = value_field instanceof Double ? (value_field.toString().endsWith(".0") ? Integer.toString(((Double)value_field).intValue()) : value_field.toString()) : value_field.toString();
                        if (field_op.equals("contains")) {
                            valueString = "%" + valueString + "%";
                        } else if (field_op.equals("icontains")) {
                            valueString = "%" + valueString.toLowerCase() + "%";
                        } else if (field_op.equals("like")) {
                            valueString = valueString.toLowerCase() + "%";
                        } else if (field_op.equals("ilike")) {
                            valueString = valueString.toLowerCase() + "%";
                        }
                        query.setParameter(p++, (Object)valueString);
                        continue;
                    }
                    if (paramType == Boolean.class) {
                        boolean value_boolean = EmsUtil.parseAsBoolean(value_field);
                        query.setParameter(p++, (Object)value_boolean);
                        continue;
                    }
                    if (paramType == Date.class) {
                        String m_erro = field_name + " n\u00e3o \u00e9 uma data v\u00e1lida.";
                        if (value_field instanceof String) {
                            int len_value = ((String)value_field).length();
                            try {
                                if (len_value >= 6 && len_value <= 10) {
                                    query.setParameter(p++, (Object)dateFormatDDMMYYYY.parse((String)value_field));
                                    continue;
                                }
                                if (len_value == 16) {
                                    query.setParameter(p++, (Object)dateFormatDDMMYYYY_HHmm.parse((String)value_field));
                                    continue;
                                }
                                if (len_value == 19) {
                                    query.setParameter(p++, (Object)dateFormatDDMMYYYY_HHmmss.parse((String)value_field));
                                    continue;
                                }
                                throw new EmsValidationException(m_erro);
                            }
                            catch (ParseException e) {
                                throw new EmsValidationException(m_erro);
                            }
                        }
                        throw new EmsValidationException(m_erro);
                    }
                    throw new EmsValidationException("N\u00e3o suporta o tipo de dado para o campo " + field_name + ".");
                }
                catch (Exception e) {
                    throw new EmsValidationException("Erro ao setar par\u00e2metros da query. Erro interno: " + e.getMessage());
                }
            }
        }
    }

    public static Map<String, Object> ObjectFieldsToMap(Object obj) {
        if (obj != null) {
            Field[] fields;
            if (obj instanceof Map) {
                return (Map)obj;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Field field : fields = obj.getClass().getDeclaredFields()) {
                try {
                    map.put(field.getName(), field.get(obj));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    field.setAccessible(true);
                    try {
                        map.put(field.getName(), field.get(obj));
                    }
                    catch (IllegalAccessException | IllegalArgumentException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            return map;
        }
        throw new EmsValidationException("Par\u00e2metro obj n\u00e3o pode ser null para EmsUtil.ObjectFieldsToMap.");
    }

    public static byte[] toByteArray(List new_value) {
        int n = new_value.size();
        byte[] ret = new byte[n];
        for (int i = 0; i < n; ++i) {
            double valor = (Double)new_value.get(i);
            ret[i] = (byte)valor;
        }
        return ret;
    }

    public static Object setValuesFromMap(Object obj, Map<String, Object> values, EmsJsonModelAdapter jsonModelAdapter) {
        if (obj != null && values != null && values.size() > 0) {
            Class<?> class_obj = obj.getClass();
            for (String field_name : values.keySet()) {
                try {
                    Integer idValue;
                    String m_erro;
                    Field field = null;
                    try {
                        field = class_obj.getDeclaredField(field_name);
                    }
                    catch (NoSuchFieldException e) {
                        continue;
                    }
                    field.setAccessible(true);
                    Object new_value = values.get(field_name);
                    Class<Enum> tipo_field = field.getType();
                    if (tipo_field == Integer.class || tipo_field == Integer.TYPE) {
                        if (new_value instanceof String) {
                            field.set(obj, Integer.parseInt((String)new_value));
                            continue;
                        }
                        if (new_value instanceof Double) {
                            field.set(obj, ((Double)new_value).intValue());
                            continue;
                        }
                        field.set(obj, (int)((Integer)new_value));
                        continue;
                    }
                    if (tipo_field == Double.class || tipo_field == Double.TYPE) {
                        if (new_value instanceof String) {
                            field.set(obj, Double.parseDouble((String)new_value));
                            continue;
                        }
                        if (new_value instanceof Double) {
                            field.set(obj, (double)((Double)new_value));
                            continue;
                        }
                        field.set(obj, (Float)new_value);
                        continue;
                    }
                    if (tipo_field == Float.class || tipo_field == Float.TYPE) {
                        if (new_value instanceof String) {
                            field.set(obj, Float.valueOf(Float.parseFloat((String)new_value)));
                            continue;
                        }
                        if (new_value instanceof Double) {
                            field.set(obj, Float.valueOf(((Double)new_value).floatValue()));
                            continue;
                        }
                        field.set(obj, (Float)new_value);
                        continue;
                    }
                    if (tipo_field == Long.class || tipo_field == Long.TYPE) {
                        if (new_value instanceof String) {
                            field.set(obj, Double.parseDouble((String)new_value));
                            continue;
                        }
                        field.set(obj, ((Double)new_value).longValue());
                        continue;
                    }
                    if (tipo_field == BigDecimal.class) {
                        if (new_value instanceof String) {
                            field.set(obj, BigDecimal.valueOf(Double.parseDouble((String)new_value)));
                            continue;
                        }
                        field.set(obj, BigDecimal.valueOf((Double)new_value));
                        continue;
                    }
                    if (tipo_field == String.class) {
                        if (new_value instanceof String) {
                            field.set(obj, new_value);
                            continue;
                        }
                        if (new_value instanceof Double) {
                            if (new_value.toString().endsWith(".0")) {
                                field.set(obj, Integer.toString(((Double)new_value).intValue()));
                                continue;
                            }
                            field.set(obj, new_value.toString());
                            continue;
                        }
                        field.set(obj, new_value.toString());
                        continue;
                    }
                    if (tipo_field == Boolean.class || tipo_field == Boolean.TYPE) {
                        if (new_value instanceof String) {
                            if (((String)new_value).equalsIgnoreCase("true")) {
                                field.set(obj, true);
                                continue;
                            }
                            if (((String)new_value).equalsIgnoreCase("false")) {
                                field.set(obj, false);
                                continue;
                            }
                            if (((String)new_value).equalsIgnoreCase("1")) {
                                field.set(obj, true);
                                continue;
                            }
                            if (((String)new_value).equalsIgnoreCase("0")) {
                                field.set(obj, false);
                                continue;
                            }
                            if (((String)new_value).equalsIgnoreCase("sim")) {
                                field.set(obj, true);
                                continue;
                            }
                            if (((String)new_value).equalsIgnoreCase("1.0")) {
                                field.set(obj, true);
                                continue;
                            }
                            if (((String)new_value).equalsIgnoreCase("yes")) {
                                field.set(obj, true);
                                continue;
                            }
                            field.set(obj, false);
                            continue;
                        }
                        if (new_value instanceof Double) {
                            if (new_value.toString().equals("1.0")) {
                                field.set(obj, true);
                                continue;
                            }
                            field.set(obj, false);
                            continue;
                        }
                        if (new_value instanceof Boolean) {
                            field.set(obj, (boolean)((Boolean)new_value));
                            continue;
                        }
                        field.set(obj, false);
                        continue;
                    }
                    if (tipo_field == Date.class) {
                        m_erro = field_name + " n\u00e3o \u00e9 uma data v\u00e1lida.";
                        if (new_value instanceof String) {
                            int len_value = ((String)new_value).length();
                            try {
                                if (len_value == 0) {
                                    field.set(obj, null);
                                    continue;
                                }
                                if (len_value >= 6 && len_value <= 10) {
                                    field.set(obj, dateFormatDDMMYYYY.parse((String)new_value));
                                    continue;
                                }
                                if (len_value == 16) {
                                    field.set(obj, dateFormatDDMMYYYY_HHmm.parse((String)new_value));
                                    continue;
                                }
                                if (len_value == 19) {
                                    field.set(obj, dateFormatDDMMYYYY_HHmmss.parse((String)new_value));
                                    continue;
                                }
                                throw new EmsValidationException(m_erro);
                            }
                            catch (ParseException e) {
                                try {
                                    if (len_value == 0) {
                                        field.set(obj, null);
                                        continue;
                                    }
                                    if (len_value >= 6 && len_value <= 10) {
                                        field.set(obj, dateFormatYYYYMMDD.parse((String)new_value));
                                        continue;
                                    }
                                    if (len_value == 16) {
                                        field.set(obj, dateFormatYYYYMMDD_HHmm.parse((String)new_value));
                                        continue;
                                    }
                                    if (len_value == 19) {
                                        field.set(obj, dateFormatYYYYMMDD_HHmmss.parse((String)new_value));
                                        continue;
                                    }
                                    throw new EmsValidationException(m_erro);
                                }
                                catch (ParseException em) {
                                    throw new EmsValidationException(m_erro);
                                }
                            }
                        }
                        throw new EmsValidationException(m_erro);
                    }
                    if (tipo_field == java.sql.Date.class) {
                        m_erro = field_name + " n\u00e3o \u00e9 uma data v\u00e1lida.";
                        if (new_value instanceof String) {
                            int len_value = ((String)new_value).length();
                            try {
                                if (len_value == 0) {
                                    field.set(obj, null);
                                    continue;
                                }
                                if (len_value >= 6 && len_value <= 10) {
                                    field.set(obj, new java.sql.Date(dateFormatDDMMYYYY.parse((String)new_value).getTime()));
                                    continue;
                                }
                                if (len_value == 16) {
                                    field.set(obj, new java.sql.Date(dateFormatDDMMYYYY_HHmm.parse((String)new_value).getTime()));
                                    continue;
                                }
                                if (len_value == 19) {
                                    field.set(obj, new java.sql.Date(dateFormatDDMMYYYY_HHmmss.parse((String)new_value).getTime()));
                                    continue;
                                }
                                throw new EmsValidationException(m_erro);
                            }
                            catch (ParseException e) {
                                try {
                                    if (len_value == 0) {
                                        field.set(obj, null);
                                        continue;
                                    }
                                    if (len_value >= 6 && len_value <= 10) {
                                        field.set(obj, new java.sql.Date(dateFormatYYYYMMDD.parse((String)new_value).getTime()));
                                        continue;
                                    }
                                    if (len_value == 16) {
                                        field.set(obj, new java.sql.Date(dateFormatYYYYMMDD_HHmm.parse((String)new_value).getTime()));
                                        continue;
                                    }
                                    if (len_value == 19) {
                                        field.set(obj, new java.sql.Date(dateFormatYYYYMMDD_HHmmss.parse((String)new_value).getTime()));
                                        continue;
                                    }
                                    throw new EmsValidationException(m_erro);
                                }
                                catch (ParseException em) {
                                    throw new EmsValidationException(m_erro);
                                }
                            }
                        }
                        throw new EmsValidationException(m_erro);
                    }
                    if (tipo_field == Timestamp.class) {
                        m_erro = field_name + " n\u00e3o \u00e9 uma data v\u00e1lida.";
                        Timestamp new_time = null;
                        if (new_value instanceof String) {
                            block90: {
                                int len_value = ((String)new_value).length();
                                try {
                                    if (len_value == 0) {
                                        new_time = null;
                                        break block90;
                                    }
                                    if (len_value >= 6 && len_value <= 10) {
                                        new_time = new Timestamp(dateFormatDDMMYYYY.parse((String)new_value).getTime());
                                        break block90;
                                    }
                                    if (len_value == 16) {
                                        new_time = new Timestamp(dateFormatDDMMYYYY_HHmm.parse((String)new_value).getTime());
                                        break block90;
                                    }
                                    if (len_value == 19) {
                                        new_time = new Timestamp(dateFormatDDMMYYYY_HHmmss.parse((String)new_value).getTime());
                                        break block90;
                                    }
                                    throw new EmsValidationException(m_erro);
                                }
                                catch (ParseException e) {
                                    try {
                                        if (len_value == 0) {
                                            field.set(obj, null);
                                        }
                                        if (len_value >= 6 && len_value <= 10) {
                                            field.set(obj, new java.sql.Date(dateFormatYYYYMMDD.parse((String)new_value).getTime()));
                                        }
                                        if (len_value == 16) {
                                            field.set(obj, new java.sql.Date(dateFormatYYYYMMDD_HHmm.parse((String)new_value).getTime()));
                                        }
                                        if (len_value == 19) {
                                            field.set(obj, new java.sql.Date(dateFormatYYYYMMDD_HHmmss.parse((String)new_value).getTime()));
                                        }
                                        throw new EmsValidationException(m_erro);
                                    }
                                    catch (ParseException em) {
                                        throw new EmsValidationException(m_erro);
                                    }
                                }
                            }
                            field.set(obj, new_time);
                            continue;
                        }
                        throw new EmsValidationException(m_erro);
                    }
                    if (tipo_field.isEnum()) {
                        try {
                            idValue = null;
                            Enum<?> value = null;
                            if (new_value instanceof String) {
                                try {
                                    idValue = Integer.parseInt((String)new_value);
                                    value = EmsUtil.intToEnum(idValue, tipo_field);
                                }
                                catch (NumberFormatException e) {
                                    value = EmsUtil.StrToEnum((String)new_value, tipo_field);
                                }
                            } else {
                                idValue = ((Double)new_value).intValue();
                                value = EmsUtil.intToEnum(idValue, tipo_field);
                            }
                            field.set(obj, value);
                            continue;
                        }
                        catch (Exception e) {
                            throw new EmsValidationException(field_name + " n\u00e3o \u00e9 v\u00e1lido.");
                        }
                    }
                    if (tipo_field == byte[].class) {
                        byte[] value = null;
                        value = EmsUtil.toByteArray((ArrayList)new_value);
                        field.set(obj, value);
                        continue;
                    }
                    if (tipo_field instanceof Object && EmsUtil.findFieldByAnnotation(tipo_field, Id.class) != null) {
                        try {
                            idValue = null;
                            idValue = new_value instanceof String ? Integer.valueOf(Integer.parseInt((String)new_value)) : Integer.valueOf(((Double)new_value).intValue());
                            if (idValue <= 0) continue;
                            Object model = jsonModelAdapter.findById(tipo_field, idValue);
                            field.set(obj, model);
                            continue;
                        }
                        catch (EmsNotFoundException e) {
                            throw new EmsValidationException(field_name + " n\u00e3o existe.");
                        }
                        catch (Exception e) {
                            throw new EmsValidationException(field_name + " inv\u00e1lido.");
                        }
                    }
                    throw new EmsValidationException("N\u00e3o suporta o tipo de dado do campo " + field_name + ".");
                }
                catch (EmsValidationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new EmsValidationException("Campo " + field_name + " inv\u00e1lido. Erro interno: " + e.getMessage());
                }
            }
        }
        return obj;
    }

    public static Field findFieldByAnnotation(Class<?> clazz, Class<? extends Annotation> ann) {
        if (clazz != null && ann != null) {
            for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
                for (Field field : c.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(ann)) continue;
                    return field;
                }
            }
        }
        return null;
    }

    public static Integer getIdFromObject(Object obj) {
        if (obj != null) {
            Field idField = EmsUtil.findFieldByAnnotation(obj.getClass(), Id.class);
            if (idField != null) {
                try {
                    idField.setAccessible(true);
                    Object result = idField.get(obj);
                    if (result != null) {
                        return (int)((Integer)result);
                    }
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }
            throw new EmsValidationException("Objeto n\u00e3o tem id.");
        }
        throw new EmsValidationException("Par\u00e2metro Obj do m\u00e9todo EmsUtil.getIdFromObject n\u00e3o deve ser null.");
    }

    public static Enum<?> intToEnum(int value, Class<Enum> clazz) {
        if (clazz != null) {
            if (value >= 0 && clazz != null) {
                for (Enum t : clazz.getEnumConstants()) {
                    if (t.ordinal() != value) continue;
                    return t;
                }
            }
            throw new EmsValidationException("Valor inv\u00e1lido para o campo " + clazz.getSimpleName());
        }
        throw new IllegalArgumentException("Par\u00e2metro clazz do m\u00e9todo EmsUtil.intToEnum n\u00e3o deve ser null.");
    }

    public static Enum<?> StrToEnum(String value, Class<Enum> clazz) {
        if (value != null && !value.isEmpty() && clazz != null) {
            for (Enum t : clazz.getEnumConstants()) {
                if (!t.name().equalsIgnoreCase(value)) continue;
                return t;
            }
            throw new EmsValidationException("Valor inv\u00e1lido para o campo " + clazz.getSimpleName());
        }
        throw new IllegalArgumentException("Par\u00e2metros clazz e value do m\u00e9todo EmsUtil.StrToEnum n\u00e3o devem ser null.");
    }

    public static Client getRestStream() {
        Client client = ClientBuilder.newClient();
        return client;
    }

    public static OtpErlangTuple serializeObjectToErlangResponse(Object ret, IEmsRequest request) {
        OtpErlangObject[] otp_result = new OtpErlangObject[3];
        OtpErlangObject[] reply = new OtpErlangObject[2];
        boolean isEmsResponse = ret instanceof EmsResponse;
        if (ret != null) {
            try {
                String m_json = null;
                if (isEmsResponse) {
                    reply[1] = new OtpErlangBinary(((EmsResponse)ret).content.getBytes());
                } else if (ret instanceof OtpErlangBinary) {
                    reply[1] = (OtpErlangBinary)ret;
                } else if (ret instanceof OtpErlangAtom) {
                    reply[1] = (OtpErlangObject)ret;
                } else if (ret instanceof Integer || ret instanceof Boolean) {
                    m_json = "{\"ok\":" + ret.toString() + "}";
                    reply[1] = new OtpErlangBinary(m_json.getBytes());
                } else if (ret instanceof Date || ret instanceof Timestamp || ret instanceof Double) {
                    m_json = "{\"ok\":" + EmsUtil.toJson(ret) + "}";
                    reply[1] = new OtpErlangBinary(m_json.getBytes());
                } else if (ret instanceof String) {
                    reply[1] = new OtpErlangBinary(((String)ret).getBytes());
                } else if (ret instanceof List && ((List)ret).isEmpty()) {
                    reply[1] = result_list_empty;
                } else if (ret instanceof byte[]) {
                    reply[1] = new OtpErlangBinary(ret);
                } else if (ret instanceof Object) {
                    m_json = EmsUtil.toJson(ret);
                    reply[1] = new OtpErlangBinary(m_json.getBytes());
                } else if (ret.getClass().getName().equals(ArrayList.class.getName())) {
                    List lista = (List)ret;
                    OtpErlangObject[] otp_items = new OtpErlangObject[lista.size()];
                    for (int i = 0; i < lista.size(); ++i) {
                        otp_items[i] = new OtpErlangString((String)lista.get(i));
                    }
                    OtpErlangList otp_list = new OtpErlangList(otp_items);
                    reply[1] = otp_list;
                }
            }
            catch (Exception e) {
                reply[1] = erro_convert_json;
            }
        } else {
            reply[1] = result_null;
        }
        if (isEmsResponse) {
            int code = ((EmsResponse)ret).code;
            reply[0] = code >= 400 ? error_atom : ok_atom;
            otp_result[0] = new OtpErlangInt(code);
        } else {
            reply[0] = ok_atom;
            otp_result[0] = request.getMetodo().equals("POST") ? new OtpErlangInt(201) : new OtpErlangInt(200);
        }
        otp_result[1] = new OtpErlangLong(request.getRID());
        otp_result[2] = new OtpErlangTuple(reply);
        OtpErlangTuple myTuple = new OtpErlangTuple(otp_result);
        return myTuple;
    }

    public static OtpErlangTuple serializeObjectToErlangRequest(Object ret, OtpErlangPid from) {
        OtpErlangObject[] otp_result = new OtpErlangObject[3];
        OtpErlangBinary reply = null;
        if (ret != null) {
            try {
                String m_json = null;
                if (ret instanceof OtpErlangBinary) {
                    reply = (OtpErlangBinary)ret;
                } else if (ret instanceof OtpErlangAtom) {
                    reply = (OtpErlangObject)ret;
                } else if (ret instanceof Integer || ret instanceof Boolean) {
                    m_json = "{\"ok\":" + ret.toString() + "}";
                    reply = new OtpErlangBinary(m_json.getBytes());
                } else if (ret instanceof Date || ret instanceof Timestamp || ret instanceof Double) {
                    m_json = "{\"ok\":" + EmsUtil.toJson(ret) + "}";
                    reply = new OtpErlangBinary(m_json.getBytes());
                } else if (ret instanceof String) {
                    reply = new OtpErlangBinary(((String)ret).getBytes());
                } else if (ret instanceof List && ((List)ret).isEmpty()) {
                    reply = result_list_empty;
                } else if (ret instanceof Object) {
                    reply = new OtpErlangBinary(EmsUtil.toJson(ret).getBytes());
                } else if (ret.getClass().getName().equals(ArrayList.class.getName())) {
                    List lista = (List)ret;
                    OtpErlangObject[] otp_items = new OtpErlangObject[lista.size()];
                    for (int i = 0; i < lista.size(); ++i) {
                        otp_items[i] = new OtpErlangString((String)lista.get(i));
                    }
                    OtpErlangList otp_list = new OtpErlangList(otp_items);
                    reply = otp_list;
                }
            }
            catch (Exception e) {
                reply = erro_convert_json;
            }
        } else {
            reply = result_null;
        }
        otp_result[0] = request_msg_atom;
        otp_result[1] = new OtpErlangTuple((OtpErlangObject)reply);
        otp_result[2] = from;
        OtpErlangTuple myTuple = new OtpErlangTuple(otp_result);
        return myTuple;
    }

    public static boolean isDateValid(Date field) {
        return field != null;
    }

    public static boolean isDateFinalAfterOrEqualDateInitial(Date dataIni, Date dataFinal) {
        return dataFinal != null && dataIni != null && (dataFinal.equals(dataIni) || dataFinal.after(dataIni));
    }

    public static boolean isDateFinalAfterDateInitial(Date dataIni, Date dataFinal) {
        return dataFinal != null && dataIni != null && dataFinal.after(dataIni);
    }

    public static boolean isFieldStrValid(String field) {
        return field != null && !field.isEmpty();
    }

    public static boolean isFieldStrValid(String field, int maxLength) {
        return field != null && !field.isEmpty() && field.length() <= maxLength;
    }

    public static boolean isFieldObjectValid(Object obj) {
        return obj != null;
    }

    public static Object mergeObjects(Object obj1, Object obj2) {
        return EmsUtil.mergeObjects(obj1, obj2, null);
    }

    public static Object mergeObjects(Object obj1, Object obj2, EmsJsonModelAdapter jsonModelAdapter) {
        Map<String, Object> values = EmsUtil.ObjectFieldsToMap(obj2);
        return EmsUtil.setValuesFromMap(obj1, values, jsonModelAdapter);
    }

    public static String fieldOperatorToSqlOperator(String fieldOperator) {
        switch (fieldOperator) {
            case "contains": {
                return " like ";
            }
            case "icontains": {
                return " like ";
            }
            case "like": {
                return " like ";
            }
            case "ilike": {
                return " like ";
            }
            case "gt": {
                return " > ";
            }
            case "gte": {
                return " >= ";
            }
            case "lt": {
                return " < ";
            }
            case "lte": {
                return " <= ";
            }
            case "e": {
                return " = ";
            }
            case "ne": {
                return " != ";
            }
            case "isnull": {
                return " is null ";
            }
            case "equal": {
                return " = ";
            }
            case "in": {
                return " IN ";
            }
        }
        throw new EmsValidationException("Operador do campo de pesquisa " + fieldOperator + " inv\u00e1lido.");
    }

    public static String listFunctionToSqlFunction(List<String> listFunction) {
        if (listFunction != null) {
            String function;
            if (listFunction.isEmpty() || listFunction.size() != 2) {
                throw new EmsValidationException("Fun\u00e7\u00e3o SQL precisa de um operador e de uma coluna para EmsUtil.listFunctionToSqlFunction.");
            }
            switch (function = listFunction.get(0)) {
                case "avg": {
                    return " avg (" + listFunction.get(1) + ") ";
                }
                case "count": {
                    return " count (" + listFunction.get(1) + ") ";
                }
                case "first": {
                    return " first (" + listFunction.get(1) + ") ";
                }
                case "last": {
                    return " last (" + listFunction.get(1) + ") ";
                }
                case "max": {
                    return " max (" + listFunction.get(1) + ") ";
                }
                case "min": {
                    return " min (" + listFunction.get(1) + ") ";
                }
                case "sum": {
                    return " sum (" + listFunction.get(1) + ") ";
                }
            }
            throw new EmsValidationException("Fun\u00e7\u00e3o SQL " + function + " inv\u00e1lido para EmsUtil.listFunctionToSqlFunction.");
        }
        throw new EmsValidationException("Par\u00e2metro listFunction n\u00e3o pode ser null para EmsUtil.listFunctionToSqlFunction.");
    }

    public static boolean parseAsBoolean(Object value_field) {
        if (value_field == null) {
            return false;
        }
        if (value_field instanceof String) {
            if (((String)value_field).equalsIgnoreCase("true")) {
                return true;
            }
            if (((String)value_field).equalsIgnoreCase("false")) {
                return false;
            }
            if (((String)value_field).equalsIgnoreCase("1")) {
                return true;
            }
            if (((String)value_field).equalsIgnoreCase("0")) {
                return false;
            }
            if (((String)value_field).equalsIgnoreCase("sim")) {
                return true;
            }
            if (((String)value_field).equalsIgnoreCase("1.0")) {
                return true;
            }
            return ((String)value_field).equalsIgnoreCase("yes");
        }
        if (value_field instanceof Double) {
            return value_field.toString().equals("1.0");
        }
        if (value_field instanceof Boolean) {
            return (Boolean)value_field;
        }
        return false;
    }

    public static Double parseAsDouble(Object value_field) {
        if (value_field != null) {
            if (value_field instanceof String) {
                return Double.parseDouble((String)value_field);
            }
            if (value_field instanceof Double) {
                return (double)((Double)value_field);
            }
            return ((Float)value_field).doubleValue();
        }
        return null;
    }

    public static byte[] printPdf(Object params, Object datasource, String templateJasper, Object owner) {
        if (templateJasper != null && !templateJasper.isEmpty() && owner != null) {
            try {
                Map<String, Object> paramsMap = null;
                ArrayList<Object> objectList = null;
                InputStream streamTemplateJasper = owner.getClass().getResourceAsStream(templateJasper);
                if (streamTemplateJasper != null) {
                    JasperReport jr = (JasperReport)JRLoader.loadObject((InputStream)streamTemplateJasper);
                    if (params != null) {
                        paramsMap = params instanceof Map ? (Map<String, Object>)params : EmsUtil.ObjectFieldsToMap(params);
                    }
                    if (datasource != null) {
                        if (datasource instanceof List) {
                            objectList = (ArrayList<Object>)datasource;
                        } else {
                            objectList = new ArrayList<Object>();
                            objectList.add(datasource);
                        }
                    }
                    JRBeanCollectionDataSource datasourceList = new JRBeanCollectionDataSource(objectList);
                    JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jr, paramsMap, (JRDataSource)datasourceList);
                    return JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
                }
                throw new EmsValidationException("N\u00e3o foi poss\u00edvel encontrar o templateJasper " + templateJasper);
            }
            catch (JRFontNotFoundException e) {
                throw new EmsValidationException("N\u00e3o foi poss\u00edvel gerar o pdf pois as fontes utilizadas n\u00e3o foram encontradas no servidor. Erro interno: " + e.getLocalizedMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new EmsValidationException("N\u00e3o foi poss\u00edvel gerar o pdf pois um erro interno ocorreu: " + e.getLocalizedMessage());
            }
        }
        throw new EmsValidationException("Par\u00e2metros params ou listaObj, templateJasper e owner devem ser informados para EmsUtil.printPdf");
    }

    public static UniqueConstraint[] getTableUniqueConstraints(Class<?> classOfModel) {
        if (classOfModel != null) {
            Table tableAnnotation = classOfModel.getAnnotation(Table.class);
            return tableAnnotation.uniqueConstraints();
        }
        throw new EmsValidationException("Par\u00e2metro classOfModel n\u00e3o pode ser null para EmsUtil.getTableUniqueConstraints.");
    }

    public static List<Field> getFieldsWithUniqueConstraint(Class<?> classOfModel) {
        if (classOfModel != null) {
            Field[] fields = classOfModel.getDeclaredFields();
            ArrayList<Field> result = new ArrayList<Field>();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!field.isAnnotationPresent(Column.class) || !field.getAnnotation(Column.class).unique() || field.isAnnotationPresent(Id.class)) continue;
                result.add(field);
            }
            return result;
        }
        throw new EmsValidationException("Par\u00e2metro classOfModel n\u00e3o pode ser null para EmsUtil.getFieldsWithUniqueConstraint.");
    }

    public static List<Field> getFieldsFromModel(Class<?> classOfModel) {
        if (classOfModel != null) {
            Field[] fields = classOfModel.getDeclaredFields();
            ArrayList<Field> result = new ArrayList<Field>();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!field.isAnnotationPresent(Column.class)) continue;
                result.add(field);
            }
            return result;
        }
        throw new EmsValidationException("Par\u00e2metro classOfModel n\u00e3o pode ser null para EmsUtil.getFieldsFromModel.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object ldapSearch(String login) {
        if (login != null) {
            Attributes attributes;
            Hashtable<String, String> env = new Hashtable<String, String>(11);
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", EmsUtil.properties.ldapUrl);
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", EmsUtil.properties.ldapAdmin);
            env.put("java.naming.security.credentials", EmsUtil.properties.ldapAdminPasswd);
            InitialLdapContext ctx = null;
            ctx = new InitialLdapContext(env, null);
            try {
                NamingEnumeration<SearchResult> answer = ctx.search("dc=unb,dc=br", "uid=" + login, null);
                attributes = answer.next().getAttributes();
            }
            catch (Throwable throwable) {
                try {
                    ctx.close();
                    throw throwable;
                }
                catch (AuthenticationException e) {
                    throw new EmsValidationException("Invalid ldap admin credentials.");
                }
                catch (NamingException e) {
                    throw new EmsValidationException("N\u00e3o foi poss\u00edvel pesquisar usu\u00e1rio no servidor LDAP " + EmsUtil.properties.ldapUrl);
                }
            }
            ctx.close();
            return attributes;
        }
        throw new EmsValidationException("Par\u00e2metro login n\u00e3o pode ser null para EmsUtil.ldapSearch.");
    }

    public static List<Map<String, Object>> ListObjectToListMap(Object fields, List<?> listObj) {
        if (fields != null && listObj != null) {
            String[] fieldNames = null;
            if (fields instanceof String) {
                fieldNames = ((String)fields).split(",");
            } else if (fields instanceof String[]) {
                fieldNames = (String[])fields;
            } else if (fields instanceof List) {
                fieldNames = (String[])((List)fields).toArray();
            } else {
                throw new EmsValidationException("Par\u00e2metro fields n\u00e3o \u00e9 do tipo correto para EmsUtil.ListObjectToListMap.");
            }
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(listObj.size());
            int colSize = fieldNames.length;
            for (Object obj : listObj) {
                int index = 0;
                HashMap<String, Object> objVo = new HashMap<String, Object>(colSize);
                for (String fieldName : fieldNames) {
                    objVo.put(fieldName, ((Object[])obj)[index++]);
                }
                result.add(objVo);
            }
            return result;
        }
        throw new EmsValidationException("Par\u00e2metros fields e ListObj n\u00e3o podem ser null para EmsUtil.ListObjectToListMap.");
    }

    private static EmsProperties getProperties() {
        String tmp_postUpdateTimeout;
        String tmp_smtp_from;
        String tmp_cookie;
        String tmp_thread_pool;
        EmsProperties prop = new EmsProperties();
        String tmp_daemon_params = EmsUtil.getProperty("ems_daemon_params");
        if (tmp_daemon_params != null) {
            try {
                if (tmp_daemon_params.startsWith("base64:")) {
                    prop.daemon_params_encode = "base64";
                    tmp_daemon_params = tmp_daemon_params.substring(7);
                    tmp_daemon_params = EmsUtil.decode64(tmp_daemon_params);
                } else {
                    prop.daemon_params_encode = "";
                }
                prop.daemon_params = EmsUtil.fromJson(tmp_daemon_params, HashMap.class);
            }
            catch (Exception e) {
                System.out.println("N\u00e3o foi poss\u00edvel fazer o parse do par\u00e2metro ems_daemon_params. Erro interno: " + e.getMessage());
                prop.daemon_params = new HashMap<String, Object>();
            }
        } else {
            prop.daemon_params = new HashMap<String, Object>();
        }
        if ((tmp_thread_pool = EmsUtil.getProperty("ems_thread_pool")) != null) {
            try {
                prop.maxThreadPool = Integer.parseInt(tmp_thread_pool);
            }
            catch (NumberFormatException e) {
                prop.maxThreadPool = 12;
            }
        } else {
            prop.maxThreadPool = 12;
        }
        prop.cookie = (tmp_cookie = EmsUtil.getProperty("ems_cookie")) != null ? tmp_cookie : "erlangms";
        String tmp_host = EmsUtil.getProperty("ems_host");
        if (tmp_host != null) {
            prop.hostName = tmp_host;
        } else {
            try {
                prop.hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                prop.hostName = "localhost";
                System.out.println("N\u00e3o foi poss\u00edvel obter o hostname da m\u00e1quina onde est\u00e1 o node. Usando localhost.");
            }
        }
        prop.debug = EmsUtil.getProperty("ems_debug", "false").equalsIgnoreCase("true");
        prop.service_scan = EmsUtil.getProperty("ems_service_scan", "br.unb");
        String tmp_nodeName = EmsUtil.getProperty("ems_node");
        prop.nodeName = tmp_nodeName != null ? tmp_nodeName : "node01";
        String tmp_environment = EmsUtil.getProperty("ems_environment");
        prop.environment = tmp_environment != null ? tmp_environment : "desenv";
        String tmp_ESB_URL = EmsUtil.getProperty("ems_bus_url");
        if (tmp_ESB_URL != null) {
            if (tmp_ESB_URL.indexOf(":") == -1) {
                tmp_ESB_URL = tmp_ESB_URL + ":2301";
            }
            prop.ESB_URL = tmp_ESB_URL;
        } else {
            prop.ESB_URL = "http://localhost:2301";
        }
        String tmp_user = EmsUtil.getProperty("ems_user");
        prop.nodeUser = tmp_user != null ? tmp_user : "geral";
        String tmp_password = EmsUtil.getProperty("ems_password");
        prop.nodePasswd = tmp_password != null ? tmp_password : "123456";
        String usernameAndPassword = prop.nodeUser + ":" + prop.nodePasswd;
        prop.authorizationHeaderName = "Authorization";
        prop.authorizationHeaderValue = "Basic " + EmsUtil.toBase64(usernameAndPassword);
        String tmp_smtp = EmsUtil.getProperty("ems_smtp");
        prop.smtp = tmp_smtp != null ? tmp_smtp : "smtp.unb.br";
        String tmp_smtp_port = EmsUtil.getProperty("ems_smtp_port");
        if (tmp_smtp_port != null) {
            try {
                prop.smtpPort = Integer.parseInt(tmp_smtp_port);
            }
            catch (NumberFormatException e) {
                prop.smtpPort = 25;
            }
        } else {
            prop.smtpPort = 25;
        }
        prop.smtpFrom = (tmp_smtp_from = EmsUtil.getProperty("ems_smtp_from")) != null ? tmp_smtp_from : "erlangms@unb.br";
        String tmp_smtp_passwd = EmsUtil.getProperty("ems_smtp_passwd");
        prop.smtpPasswd = tmp_smtp_passwd != null ? tmp_smtp_passwd : "123456";
        String tmp_ldap_url = EmsUtil.getProperty("ems_ldap_url");
        if (tmp_ldap_url != null) {
            if (tmp_ldap_url.indexOf(":") == -1) {
                tmp_ldap_url = tmp_ldap_url + ":2389";
            }
            if (!tmp_ldap_url.startsWith("ldap://")) {
                tmp_ldap_url = "ldap://" + tmp_ldap_url;
            }
            prop.ldapUrl = tmp_ldap_url;
        } else {
            prop.ldapUrl = "ldap://localhost:2389";
        }
        String tmp_ldap_admin = EmsUtil.getProperty("ems_ldap_admin");
        prop.ldapAdmin = tmp_ldap_admin != null ? tmp_ldap_admin : "cn=admin,dc=unb,dc=br";
        String tmp_ldap_admin_passwd = EmsUtil.getProperty("ems_ldap_admin_passwd");
        prop.ldapAdminPasswd = tmp_ldap_admin_passwd != null ? tmp_ldap_admin_passwd : "123456";
        String tmp_msg_timeout = EmsUtil.getProperty("ems_msg_timeout");
        if (tmp_msg_timeout != null) {
            try {
                prop.msg_timeout = Integer.parseInt(tmp_msg_timeout);
            }
            catch (NumberFormatException e) {
                prop.msg_timeout = 60000;
            }
        } else {
            prop.msg_timeout = 60000;
        }
        if ((tmp_postUpdateTimeout = EmsUtil.getProperty("ems_post_update_timeout")) != null) {
            try {
                prop.postUpdateTimeout = Integer.parseInt(tmp_postUpdateTimeout);
                if (prop.postUpdateTimeout < 15000) {
                    prop.postUpdateTimeout += 5000;
                }
            }
            catch (NumberFormatException e) {
                prop.postUpdateTimeout = 30000;
            }
        } else {
            prop.postUpdateTimeout = 30000;
        }
        prop.pidfile = EmsUtil.getProperty("ems_pidfile");
        prop.pidfileWatchdogTimer = EmsUtil.getPropertyAsInt("ems_pidfile_watchdog_timer", 30000);
        prop.logfile = EmsUtil.getProperty("ems_logfile");
        prop.daemon_service = EmsUtil.getProperty("ems_daemon_service");
        prop.daemon_id = EmsUtil.getProperty("ems_daemon_id");
        return prop;
    }

    public static void sendTextMail(String to, String subject, String content, String[] attachment) {
        MailSenderInfo mailInfo = new MailSenderInfo();
        mailInfo.setMailServerHost(EmsUtil.properties.smtp);
        mailInfo.setMailServerPort(Integer.toString(EmsUtil.properties.smtpPort));
        mailInfo.setValidate(true);
        mailInfo.setUserName(EmsUtil.properties.smtpFrom);
        mailInfo.setPassword(EmsUtil.properties.smtpPasswd);
        mailInfo.setFromAddress(EmsUtil.properties.smtpFrom);
        mailInfo.setToAddress(to);
        mailInfo.setSubject(subject);
        mailInfo.setContent(content);
        if (attachment != null && attachment.length != 0) {
            mailInfo.setAttachFileNames(attachment);
        } else {
            mailInfo.setWithAttachment(false);
        }
        MyAuthenticator authenticator = null;
        Properties pro = mailInfo.getProperties();
        if (mailInfo.isValidate()) {
            authenticator = new MyAuthenticator(mailInfo.getUserName(), mailInfo.getPassword());
        }
        Session sendMailSession = Session.getDefaultInstance((Properties)pro, authenticator);
        try {
            MimeMessage mailMessage = new MimeMessage(sendMailSession);
            InternetAddress from = new InternetAddress(mailInfo.getFromAddress());
            mailMessage.setFrom((Address)from);
            InternetAddress addr = new InternetAddress(mailInfo.getToAddress());
            mailMessage.setRecipient(Message.RecipientType.TO, (Address)addr);
            mailMessage.setSubject(mailInfo.getSubject());
            mailMessage.setSentDate(new Date());
            String mailContent = mailInfo.getContent();
            mailMessage.setText(mailContent);
            MimeMultipart multipart = new MimeMultipart();
            if (mailInfo.isWithAttachment()) {
                for (int i = 0; i < mailInfo.getAttachFileNames().length; ++i) {
                    FileDataSource source = new FileDataSource(mailInfo.getAttachFileNames()[i]);
                    MimeBodyPart bodyPart = new MimeBodyPart();
                    bodyPart.setDataHandler(new DataHandler((DataSource)source));
                    String[] ss = mailInfo.getAttachFileNames()[i].split("/");
                    bodyPart.setFileName(ss[ss.length - 1]);
                    multipart.addBodyPart((BodyPart)bodyPart);
                }
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setContent((Object)mailInfo.getContent(), "text/html");
                multipart.addBodyPart((BodyPart)bodyPart);
                mailMessage.setContent((Multipart)multipart);
            }
            Transport.send((Message)mailMessage);
        }
        catch (MessagingException ex) {
            throw new EmsValidationException("N\u00e3o foi poss\u00edvel enviar e-mail para " + to + ". Erro interno: " + ex.getMessage());
        }
    }

    private static void sendHtmlMail(String to, String subject, String content, String[] attachment) {
        MailSenderInfo mailInfo = new MailSenderInfo();
        mailInfo.setMailServerHost(EmsUtil.properties.smtp);
        mailInfo.setMailServerPort(Integer.toString(EmsUtil.properties.smtpPort));
        mailInfo.setValidate(true);
        mailInfo.setUserName(EmsUtil.properties.smtpFrom);
        mailInfo.setPassword(EmsUtil.properties.smtpPasswd);
        mailInfo.setFromAddress(EmsUtil.properties.smtpFrom);
        mailInfo.setToAddress(to);
        mailInfo.setSubject(subject);
        mailInfo.setContent(content);
        if (attachment != null && attachment.length != 0) {
            mailInfo.setAttachFileNames(attachment);
        } else {
            mailInfo.setWithAttachment(false);
        }
        MyAuthenticator authenticator = null;
        Properties pro = mailInfo.getProperties();
        if (mailInfo.isValidate()) {
            authenticator = new MyAuthenticator(mailInfo.getUserName(), mailInfo.getPassword());
        }
        Session sendMailSession = Session.getDefaultInstance((Properties)pro, authenticator);
        try {
            MimeMessage mailMessage = new MimeMessage(sendMailSession);
            InternetAddress from = new InternetAddress(mailInfo.getFromAddress());
            mailMessage.setFrom((Address)from);
            InternetAddress addr = new InternetAddress(mailInfo.getToAddress());
            mailMessage.setRecipient(Message.RecipientType.TO, (Address)addr);
            mailMessage.setSubject(mailInfo.getSubject());
            mailMessage.setSentDate(new Date());
            MimeMultipart mainPart = new MimeMultipart();
            MimeBodyPart html = new MimeBodyPart();
            html.setContent((Object)mailInfo.getContent(), "text/html; charset=utf-8");
            mainPart.addBodyPart((BodyPart)html);
            mailMessage.setContent((Multipart)mainPart);
            MimeBodyPart bodyPart = new MimeBodyPart();
            MimeMultipart multipart = new MimeMultipart();
            if (mailInfo.getAttachFileNames().length != 0) {
                FileDataSource source = new FileDataSource(mailInfo.getAttachFileNames()[0]);
                bodyPart.setDataHandler(new DataHandler((DataSource)source));
                bodyPart.setFileName(mailInfo.getAttachFileNames()[0]);
                multipart.addBodyPart((BodyPart)bodyPart);
            }
            mailMessage.setContent((Multipart)multipart);
            Transport.send((Message)mailMessage);
        }
        catch (MessagingException ex) {
            throw new EmsValidationException("N\u00e3o foi poss\u00edvel enviar e-mail para " + to + ". Erro interno: " + ex.getMessage());
        }
    }

    public static String toSHA1(String value) {
        if (value != null) {
            return new String(messageDigestSHA1.digest(value.getBytes()));
        }
        return "";
    }

    public static String toBase64(String value) {
        if (value != null) {
            return base64Encoder.encodeToString(value.getBytes());
        }
        return "";
    }

    public static EmsFilterStatement parseSqlNativeFilter(String filter) {
        if (filter != null && filter.length() > 5) {
            try {
                StringBuilder where = null;
                Map filtro_obj = null;
                boolean useAnd = false;
                filtro_obj = EmsUtil.fromJson(filter, HashMap.class);
                where = new StringBuilder(" where ");
                for (String field : filtro_obj.keySet()) {
                    String sqlOperator;
                    String fieldOperator;
                    String fieldName;
                    String[] field_defs;
                    int field_len;
                    if (useAnd) {
                        where.append(" and ");
                    }
                    if ((field_len = (field_defs = field.split("__")).length) == 1) {
                        fieldName = field;
                        fieldOperator = "=";
                        sqlOperator = "=";
                    } else if (field_len == 2) {
                        fieldName = field_defs[0];
                        fieldOperator = field_defs[1];
                        sqlOperator = EmsUtil.fieldOperatorToSqlOperator(fieldOperator);
                    } else {
                        throw new EmsValidationException("Campo de pesquisa " + field + " inv\u00e1lido.");
                    }
                    if (field_len == 2) {
                        if (fieldOperator.equals("isnull")) {
                            boolean fieldBoolean = EmsUtil.parseAsBoolean(filtro_obj.get(field));
                            if (fieldBoolean) {
                                where.append(fieldName).append(" is null ");
                            } else {
                                where.append(fieldName).append(" is not null ");
                            }
                        } else if (fieldOperator.equals("icontains") || fieldOperator.equals("ilike")) {
                            fieldName = String.format("lower(this.%s)", fieldName);
                            where.append(fieldName).append(sqlOperator).append("?");
                        } else {
                            fieldName = String.format("this.%s", fieldName);
                            where.append(fieldName).append(sqlOperator).append("?");
                        }
                    } else {
                        fieldName = String.format("this.%s", fieldName);
                        where.append(fieldName).append(sqlOperator).append("?");
                    }
                    useAnd = true;
                }
                return new EmsFilterStatement(where, filtro_obj);
            }
            catch (Exception e) {
                throw new EmsValidationException("Filtro da pesquisa inv\u00e1lido. Erro interno: " + e.getMessage());
            }
        }
        return null;
    }

    public static String encrypt(String cleartext) throws Exception {
        byte[] rawKey = EmsUtil.getRawKey(seed.getBytes());
        byte[] result = EmsUtil.encrypt(rawKey, cleartext.getBytes());
        return EmsUtil.toHex(result);
    }

    public static String decrypt(String encrypted) throws Exception {
        byte[] rawKey = EmsUtil.getRawKey(seed.getBytes());
        byte[] enc = EmsUtil.toByte(encrypted);
        byte[] result = EmsUtil.decrypt(rawKey, enc);
        return new String(result);
    }

    private static byte[] getRawKey(byte[] seed) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        sr.setSeed(seed);
        kgen.init(128, sr);
        SecretKey skey = kgen.generateKey();
        byte[] raw = skey.getEncoded();
        return raw;
    }

    private static byte[] encrypt(byte[] raw, byte[] clear) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, skeySpec);
        byte[] encrypted = cipher.doFinal(clear);
        return encrypted;
    }

    private static byte[] decrypt(byte[] raw, byte[] encrypted) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, skeySpec);
        byte[] decrypted = cipher.doFinal(encrypted);
        return decrypted;
    }

    public static String toHex(String txt) {
        return EmsUtil.toHex(txt.getBytes());
    }

    public static String fromHex(String hex) {
        return new String(EmsUtil.toByte(hex));
    }

    public static byte[] toByte(String hexString) {
        int len = hexString.length() / 2;
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            result[i] = Integer.valueOf(hexString.substring(2 * i, 2 * i + 2), 16).byteValue();
        }
        return result;
    }

    public static String toHex(byte[] buf) {
        if (buf == null) {
            return "";
        }
        StringBuffer result = new StringBuffer(2 * buf.length);
        for (int i = 0; i < buf.length; ++i) {
            EmsUtil.appendHex(result, buf[i]);
        }
        return result.toString();
    }

    private static void appendHex(StringBuffer sb, byte b) {
        sb.append(HEX.charAt(b >> 4 & 0xF)).append(HEX.charAt(b & 0xF));
    }

    public static byte[] toSHA1(byte[] convertme) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return md.digest(convertme);
    }

    public static String encode64(String str) {
        String strenc = "";
        try {
            Base64.Encoder enc = Base64.getEncoder();
            strenc = new String(enc.encode(str.getBytes("UTF-8")));
        }
        catch (Exception e) {
            System.out.println("Exception");
        }
        return strenc;
    }

    public static String decode64(String str) {
        String strdec = "";
        try {
            Base64.Decoder dec = Base64.getDecoder();
            strdec = new String(dec.decode(str.getBytes("UTF-8")));
        }
        catch (Exception e) {
            System.out.println("Exception");
        }
        return strdec;
    }

    public static String formatarString(String texto, String mascara) throws ParseException {
        MaskFormatter mf = new MaskFormatter(mascara);
        mf.setValueContainsLiteralCharacters(false);
        return mf.valueToString(texto);
    }

    private static ByteArrayOutputStream readFully(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return baos;
    }

    public static String readFullyAsString(InputStream inputStream, String encoding) throws IOException {
        return EmsUtil.readFully(inputStream).toString(encoding);
    }

    public static void executeCommand(String command, boolean imprimeSaida) throws IOException {
        boolean isLinuxOS = EmsUtil.isLinuxOS();
        ArrayList<String> commands = new ArrayList<String>();
        if (isLinuxOS) {
            commands.add("/bin/bash");
            commands.add("-c");
        } else {
            commands.add("cmd.exe /c ");
            command = command.replace("java", "java.exe");
        }
        commands.add(command);
        BufferedReader br = null;
        try {
            if (isLinuxOS) {
                ProcessBuilder p = new ProcessBuilder(commands);
                Process process = p.start();
                if (imprimeSaida) {
                    String line;
                    InputStream is = process.getInputStream();
                    InputStreamReader isr = new InputStreamReader(is);
                    br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        System.out.println(line);
                    }
                }
            } else {
                String cmd = EmsUtil.join(commands, " ");
                Runtime.getRuntime().exec(cmd);
            }
        }
        catch (IOException ioe) {
            logger.info(ioe.getMessage());
            throw ioe;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                logger.info(ex.getMessage());
            }
        }
    }

    public static void removePidFile(String fileNamePid) {
        try {
            File arquivo = new File(fileNamePid);
            if (arquivo.exists()) {
                arquivo.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getMeuPid() {
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }

    public static void addShutdownHook(String fileNamePid) {
        Runtime.getRuntime().addShutdownHook(new Thread(fileNamePid){

            @Override
            public void run() {
                EmsUtil.removePidFile(this.getName());
                logger.info(String.format("%s finalizado.", this.getName()));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer lePid(String fileNamePidProcesso) throws NumberFormatException, IOException {
        try (BufferedReader reader = null;){
            Integer pid;
            reader = new BufferedReader(new FileReader(fileNamePidProcesso));
            Integer n = pid = Integer.valueOf(Integer.parseInt(reader.readLine()));
            return n;
        }
    }

    public static String getMeuIp() {
        Enumeration<NetworkInterface> nis = null;
        try {
            nis = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            logger.info(String.format("Erro ao obter IP. Motivo: %s", e.getMessage()));
        }
        if (nis != null) {
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                Enumeration<InetAddress> ias = ni.getInetAddresses();
                while (ias.hasMoreElements()) {
                    InetAddress ia = ias.nextElement();
                    if (!ia.getHostAddress().contains("164.41")) continue;
                    return ia.getHostAddress();
                }
            }
        }
        return "";
    }

    public static void kill(Integer pid, boolean force) {
        try {
            if (EmsUtil.isLinuxOS()) {
                String cmd = force ? String.format("kill -9 %d", pid) : String.format("kill %d", pid);
                EmsUtil.executeCommand(cmd, false);
            } else {
                String line;
                String pid_str = pid.toString();
                Process p = Runtime.getRuntime().exec("tasklist.exe /fo csv /nh");
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = input.readLine()) != null) {
                    String[] args;
                    if (line.trim().equals("") || !(args = line.split("\",\""))[1].equals(pid_str)) continue;
                    Runtime.getRuntime().exec(String.format("taskkill /PID %d", pid));
                    return;
                }
                input.close();
            }
        }
        catch (Exception err) {
            logger.info(String.format("Erro ao matar processo %d", pid));
        }
    }

    public static boolean isLinuxOS() {
        boolean isLinuxOS = System.getProperty("os.name").toLowerCase().contains("linux");
        return isLinuxOS;
    }

    public static String join(String[] list, String conjunction) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String item : list) {
            if (first) {
                first = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(ArrayList<String> list, String conjunction) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String item : list) {
            if (first) {
                first = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String getProperty(String p) {
        if (p != null && !p.isEmpty()) {
            String result;
            if (properties != null) {
                String[] c = EmsUtil.properties.daemon_params;
                if ((p.equals("erlangms.java_thread_pool") || p.equals("ems_thread_pool")) && c.containsKey("erlangms.java_thread_pool")) {
                    return c.get("erlangms.java_thread_pool").toString();
                }
                if ((p.equals("erlangms.host") || p.equals("ems_host")) && c.containsKey("erlangms.host")) {
                    return (String)c.get("erlangms.host");
                }
                if ((p.equals("erlangms.url") || p.equals("ems_bus_url")) && c.containsKey("erlangms.url")) {
                    return (String)c.get("erlangms.url");
                }
                if ((p.equals("erlangms.user") || p.equals("ems_user")) && c.containsKey("erlangms.user")) {
                    return (String)c.get("erlangms.user");
                }
                if ((p.equals("erlangms.password") || p.equals("ems_password")) && c.containsKey("erlangms.password")) {
                    return (String)c.get("erlangms.password");
                }
                if ((p.equals("erlangms.smtp.password") || p.equals("ems_smtp_passwd")) && c.containsKey("erlangms.smtp.password")) {
                    return (String)c.get("erlangms.smtp.password");
                }
                if ((p.equals("erlangms.smtp.from") || p.equals("ems_smtp_from")) && c.containsKey("erlangms.smtp.from")) {
                    return (String)c.get("erlangms.smtp.from");
                }
                if ((p.equals("erlangms.smtp.port") || p.equals("ems_smtp_port")) && c.containsKey("erlangms.smtp.port")) {
                    return c.get("erlangms.smtp.port").toString();
                }
                if ((p.equals("erlangms.smtp.mail") || p.equals("ems_smtp")) && c.containsKey("erlangms.smtp.mail")) {
                    return (String)c.get("erlangms.smtp.mail");
                }
                if ((p.equals("erlangms.environment") || p.equals("ems_environment")) && c.containsKey("erlangms.environment")) {
                    return (String)c.get("erlangms.environment");
                }
                if ((p.equals("erlangms.node") || p.equals("ems_node")) && c.containsKey("erlangms.node")) {
                    return (String)c.get("erlangms.node");
                }
                if ((p.equals("erlangms.cookie") || p.equals("ems_cookie")) && c.containsKey("erlangms.cookie")) {
                    return (String)c.get("erlangms.cookie");
                }
                if ((p.equals("erlangms.max_thread_pool_by_agent") || p.equals("ems_max_thread_pool_by_agent")) && c.containsKey("erlangms.max_thread_pool_by_agent")) {
                    return (String)c.get("erlangms.max_thread_pool_by_agent");
                }
                if ((p.equals("erlangms.debug") || p.equals("ems_debug")) && c.containsKey("erlangms.debug")) {
                    return c.get("erlangms.debug").toString();
                }
                if ((p.equals("erlangms.ldap.passwd") || p.equals("ems_ldap_admin_passwd")) && c.containsKey("erlangms.ldap.passwd")) {
                    return (String)c.get("erlangms.ldap.passwd");
                }
                if ((p.equals("erlangms.ldap.admin") || p.equals("ems_ldap_admin")) && c.containsKey("erlangms.ldap.admin")) {
                    return (String)c.get("erlangms.ldap.admin");
                }
                if ((p.equals("erlangms.ldap.url") || p.equals("ems_ldap_url")) && c.containsKey("erlangms.ldap.url")) {
                    return (String)c.get("erlangms.ldap.url");
                }
                if ((p.equals("erlangms.msg_timeout") || p.equals("ems_msg_timeout")) && c.containsKey("erlangms.msg_timeout")) {
                    return c.get("erlangms.msg_timeout").toString();
                }
                if ((p.equals("erlangms.post_update_timeout") || p.equals("ems_post_update_timeout")) && c.containsKey("erlangms.post_update_timeout")) {
                    return c.get("erlangms.post_update_timeout").toString();
                }
                if ((p.equals("erlangms.daemon_id") || p.equals("ems_daemon_id")) && c.containsKey("erlangms.daemon_id")) {
                    return (String)c.get("erlangms.daemon_id");
                }
                if ((p.equals("erlangms.daemon_service") || p.equals("ems_daemon_service")) && c.containsKey("erlangms.daemon_service")) {
                    return (String)c.get("erlangms.daemon_service");
                }
                if ((p.equals("erlangms.logfile") || p.equals("ems_logfile")) && c.containsKey("erlangms.logfile")) {
                    return (String)c.get("erlangms.logfile");
                }
                if ((p.equals("erlangms.pidfile") || p.equals("ems_pidfile")) && c.containsKey("erlangms.pidfile")) {
                    return (String)c.get("erlangms.pidfile");
                }
                if ((p.equals("erlangms.pidfile_watchdog_timer") || p.equals("ems_pidfile_watchdog_timer")) && c.containsKey("erlangms.pidfile_watchdog_timer")) {
                    return c.get("erlangms.pidfile_watchdog_timer").toString();
                }
                if (c.containsKey(p)) {
                    String result2 = c.get(p).toString();
                    return result2 == null || result2.isEmpty() ? "" : result2.trim();
                }
                if ((p.equals("erlangms.service_scan") || p.equals("ems_service_scan")) && c.containsKey("erlangms.service_scan")) {
                    return (String)c.get("erlangms.service_scan");
                }
            }
            if (args != null) {
                try {
                    for (String prop : args) {
                        int posEq = prop.indexOf("=");
                        if (posEq != -1) {
                            String key = prop.substring(1, posEq);
                            if (key.startsWith("-D")) {
                                key = key.substring(2);
                            }
                            if (key.startsWith("-")) {
                                key = key.substring(1);
                            }
                            if (key.startsWith("-")) {
                                key = key.substring(1);
                            }
                            if (!key.equalsIgnoreCase(p) && !key.equalsIgnoreCase("D" + p)) continue;
                            return prop.substring(posEq + 1).trim();
                        }
                        if (!prop.equalsIgnoreCase(p)) continue;
                        return prop.trim();
                    }
                }
                catch (Exception e) {
                    return null;
                }
            }
            if ((result = System.getProperty(p)) != null) {
                if (result.trim().isEmpty()) {
                    return null;
                }
                return result;
            }
            return null;
        }
        return null;
    }

    public static String getProperty(String property, String defaultValue) {
        String result = EmsUtil.getProperty(property);
        return result == null || result.isEmpty() ? defaultValue : result;
    }

    public static Integer getPropertyAsInt(String property) {
        try {
            return Integer.parseInt(EmsUtil.getProperty(property));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Integer getPropertyAsInt(String property, Integer defaultValue) {
        try {
            return Integer.parseInt(EmsUtil.getProperty(property));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static void setArgs(String[] args) {
        EmsUtil.args = args;
        properties = EmsUtil.getProperties();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String createPidFile(String fileNamePid, boolean deleteIfExists) throws Exception {
        if (fileNamePid == null) throw new Exception("Par\u00e2metro fileNamePid \u00e9 inv\u00e1lido para EmsUtil.createPidFile.");
        if (fileNamePid.isEmpty()) throw new Exception("Par\u00e2metro fileNamePid \u00e9 inv\u00e1lido para EmsUtil.createPidFile.");
        File arq = new File(fileNamePid);
        if (arq.exists()) {
            System.out.println(String.format("Aten\u00e7\u00e3o: O arquivo de pid %s j\u00e1 existia.", fileNamePid));
            if (deleteIfExists) {
                arq.delete();
            }
        }
        try (FileWriter fw = new FileWriter(arq);){
            fw.write(EmsUtil.getMeuPid());
            fw.flush();
            String string = fileNamePid;
            return string;
        }
        catch (IOException e) {
            throw new Exception("N\u00e3o foi poss\u00edvel criar o arquivo de pid " + fileNamePid + ". Motivo: " + e.getMessage());
        }
    }

    public static void addUpdatePidFileHook(String fileNamePid, EntityManager serviceContext, Integer watchdogTimer) {
        logger.info("Adicionando um hook para atualizar o arquivo de pid " + fileNamePid + " a cada " + String.valueOf(watchdogTimer) + "ms.");
        class UpdatePidFileThead
        extends Thread {
            private String fileNamePid = null;
            private Integer watchdogTimer = null;

            public UpdatePidFileThead(String fileNamePid, EntityManager serviceContext, Integer watchdogTimer) {
                this.fileNamePid = fileNamePid;
                this.watchdogTimer = watchdogTimer;
                this.setPriority(5);
            }

            @Override
            public void run() {
                String pidStr = EmsUtil.getMeuPid();
                while (this.isAlive()) {
                    try {
                        Thread.sleep(this.watchdogTimer.intValue());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.isAlive()) continue;
                    try {
                        try {
                            FileWriter arq = new FileWriter(this.fileNamePid);
                            Throwable throwable = null;
                            try {
                                arq.write(pidStr);
                                arq.flush();
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (arq == null) continue;
                                if (throwable != null) {
                                    try {
                                        arq.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                arq.close();
                            }
                        }
                        catch (Exception e) {
                            throw new Exception("Erro na grava\u00e7\u00e3o do arquivo de pid.");
                        }
                    }
                    catch (Exception e) {
                        logger.info("Aten\u00e7\u00e3o: N\u00e3o foi poss\u00edvel atualizar o arquivo de pid " + this.fileNamePid + ". Motivo: " + e.getMessage());
                    }
                }
            }
        }
        new UpdatePidFileThead(fileNamePid, serviceContext, watchdogTimer).start();
    }

    public static void addMonitorPidFileHook(String fileNamePid, Integer watchdogTimer) {
        logger.info("Adicionando um hook para monitorar o arquivo de pid " + fileNamePid + " a cada " + String.valueOf(watchdogTimer) + "ms.");
        class UpdatePidFileThead
        extends Thread {
            private String fileNamePid = null;
            private Integer watchdogTimer = 60000;

            public UpdatePidFileThead(String fileNamePid, Integer watchdogTimer) {
                this.fileNamePid = fileNamePid;
                this.watchdogTimer = watchdogTimer;
                this.setPriority(1);
            }

            @Override
            public void run() {
                int numeroTentativas = 1;
                while (this.isAlive()) {
                    try {
                        Thread.sleep(this.watchdogTimer.intValue());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.isAlive()) continue;
                    try {
                        File arq = new File(this.fileNamePid);
                        if (!arq.exists()) {
                            throw new Exception("O arquivo de pid " + this.fileNamePid + " n\u00e3o foi encontrado.");
                        }
                        long tempoDecorrido = System.currentTimeMillis() - arq.lastModified();
                        long diffTempo = tempoDecorrido - (long)this.watchdogTimer.intValue();
                        if (diffTempo > (long)this.watchdogTimer.intValue()) {
                            throw new Exception("O arquivo de pid " + this.fileNamePid + " est\u00e1 desatualizado h\u00e1 mais de " + String.valueOf(diffTempo) + "ms.");
                        }
                        numeroTentativas = 1;
                    }
                    catch (Exception e) {
                        if (numeroTentativas > 3) {
                            logger.info("Fatal: O processo ser\u00e1 encerrado pois est\u00e1 travado. Erro interno: " + e.getMessage());
                            EmsUtil.removePidFile(this.fileNamePid);
                            System.exit(1);
                        } else {
                            logger.info("Aten\u00e7\u00e3o: O processo parece estar travado (Tentativa: " + String.valueOf(numeroTentativas) + "). Erro interno: " + e.getMessage());
                        }
                        ++numeroTentativas;
                    }
                }
            }
        }
        new UpdatePidFileThead(fileNamePid, watchdogTimer).start();
    }

    static {
        doubleFormatter = NumberFormat.getInstance(Locale.US);
        doubleFormatter.setMaximumFractionDigits(2);
        doubleFormatter.setMinimumFractionDigits(2);
        try {
            messageDigestSHA1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        base64Encoder = Base64.getEncoder();
        gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new SerializeStrategy()}).setDateFormat("dd/MM/yyyy").registerTypeAdapter(BigDecimal.class, (Object)new JsonSerializer<BigDecimal>(){

            public JsonElement serialize(BigDecimal value, Type arg1, JsonSerializationContext arg2) {
                String result = doubleFormatter.format(value);
                return new JsonPrimitive(result);
            }
        }).registerTypeAdapter(Double.class, (Object)new JsonSerializer<Double>(){

            public JsonElement serialize(Double src, Type typeOfSrc, JsonSerializationContext context) {
                if (src == (double)src.longValue()) {
                    return new JsonPrimitive((Number)src.longValue());
                }
                return new JsonPrimitive((Number)src);
            }
        }).registerTypeAdapter(String.class, (Object)new JsonSerializer<String>(){

            public JsonElement serialize(String value, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(value.trim());
            }
        }).registerTypeAdapter(Integer.class, (Object)new JsonSerializer<Integer>(){

            public JsonElement serialize(Integer value, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive((Number)value);
            }
        }).registerTypeAdapter(Float.class, (Object)new JsonSerializer<Float>(){

            public JsonElement serialize(Float value, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive((Number)value);
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date value, Type typeOfSrc, JsonSerializationContext context) {
                if (value.getHours() == 0 && value.getMinutes() == 0) {
                    return new JsonPrimitive(dateFormatDDMMYYYY.format(value));
                }
                if (value.getSeconds() == 0) {
                    return new JsonPrimitive(dateFormatDDMMYYYY_HHmm.format(value));
                }
                return new JsonPrimitive(dateFormatDDMMYYYY_HHmmss.format(value));
            }
        }).registerTypeAdapter(Timestamp.class, (Object)new JsonSerializer<Timestamp>(){

            public JsonElement serialize(Timestamp value, Type typeOfSrc, JsonSerializationContext context) {
                if (value.getHours() == 0 && value.getMinutes() == 0) {
                    return new JsonPrimitive(dateFormatDDMMYYYY.format(value));
                }
                if (value.getSeconds() == 0) {
                    return new JsonPrimitive(dateFormatDDMMYYYY_HHmm.format(value));
                }
                return new JsonPrimitive(dateFormatDDMMYYYY_HHmmss.format(value));
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                String value = json.getAsString();
                String m_erro = "N\u00e3o \u00e9 uma data v\u00e1lida.";
                try {
                    int len_value = value.length();
                    if (len_value >= 6 && len_value <= 10) {
                        return dateFormatDDMMYYYY.parse(value);
                    }
                    if (len_value == 16) {
                        return dateFormatDDMMYYYY_HHmm.parse(value);
                    }
                    if (len_value == 19) {
                        return dateFormatDDMMYYYY_HHmmss.parse(value);
                    }
                    throw new EmsValidationException("N\u00e3o \u00e9 uma data v\u00e1lida.");
                }
                catch (ParseException e) {
                    throw new EmsValidationException("N\u00e3o \u00e9 uma data v\u00e1lida.");
                }
            }
        }).registerTypeAdapter(Timestamp.class, (Object)new JsonDeserializer<Timestamp>(){

            public Timestamp deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                String value = json.getAsString();
                String m_erro = "N\u00e3o \u00e9 uma data v\u00e1lida";
                try {
                    int len_value = value.length();
                    if (len_value >= 6 && len_value <= 10) {
                        return new Timestamp(dateFormatDDMMYYYY.parse(value).getTime());
                    }
                    if (len_value == 16) {
                        return new Timestamp(dateFormatDDMMYYYY_HHmm.parse(value).getTime());
                    }
                    if (len_value == 19) {
                        return new Timestamp(dateFormatDDMMYYYY_HHmmss.parse(value).getTime());
                    }
                    throw new EmsValidationException("N\u00e3o \u00e9 uma data v\u00e1lida");
                }
                catch (ParseException e) {
                    throw new EmsValidationException("N\u00e3o \u00e9 uma data v\u00e1lida");
                }
            }
        }).registerTypeAdapterFactory(HibernateProxyTypeAdapter.FACTORY).registerTypeAdapter(Boolean.class, (Object)new JsonDeserializer<Boolean>(){

            public Boolean deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                String value = json.getAsString();
                if (value.equalsIgnoreCase("true")) {
                    return true;
                }
                if (value.equalsIgnoreCase("false")) {
                    return false;
                }
                if (value.equalsIgnoreCase("1")) {
                    return true;
                }
                if (value.equalsIgnoreCase("0")) {
                    return false;
                }
                if (value.equalsIgnoreCase("sim")) {
                    return true;
                }
                if (value.equalsIgnoreCase("1.0")) {
                    return true;
                }
                if (value.equalsIgnoreCase("yes")) {
                    return true;
                }
                return false;
            }
        }).create();
        gson2 = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new SerializeStrategy()}).setDateFormat("dd/MM/yyyy").registerTypeAdapter(BigDecimal.class, (Object)new JsonSerializer<BigDecimal>(){

            public JsonElement serialize(BigDecimal value, Type arg1, JsonSerializationContext arg2) {
                String result = doubleFormatter.format(value);
                return new JsonPrimitive(result);
            }
        }).registerTypeAdapter(Double.class, (Object)new JsonSerializer<Double>(){

            public JsonElement serialize(Double src, Type typeOfSrc, JsonSerializationContext context) {
                if (src == (double)src.longValue()) {
                    return new JsonPrimitive((Number)src.longValue());
                }
                return new JsonPrimitive((Number)src);
            }
        }).registerTypeAdapter(String.class, (Object)new JsonSerializer<String>(){

            public JsonElement serialize(String value, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(value.trim());
            }
        }).registerTypeAdapter(Integer.class, (Object)new JsonSerializer<Integer>(){

            public JsonElement serialize(Integer value, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive((Number)value);
            }
        }).registerTypeAdapter(Float.class, (Object)new JsonSerializer<Float>(){

            public JsonElement serialize(Float value, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive((Number)value);
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date value, Type typeOfSrc, JsonSerializationContext context) {
                if (value.getHours() == 0 && value.getMinutes() == 0) {
                    return new JsonPrimitive(dateFormatDDMMYYYY.format(value));
                }
                if (value.getSeconds() == 0) {
                    return new JsonPrimitive(dateFormatDDMMYYYY_HHmm.format(value));
                }
                return new JsonPrimitive(dateFormatDDMMYYYY_HHmmss.format(value));
            }
        }).registerTypeAdapter(Timestamp.class, (Object)new JsonSerializer<Timestamp>(){

            public JsonElement serialize(Timestamp value, Type typeOfSrc, JsonSerializationContext context) {
                if (value.getHours() == 0 && value.getMinutes() == 0) {
                    return new JsonPrimitive(dateFormatDDMMYYYY.format(value));
                }
                if (value.getSeconds() == 0) {
                    return new JsonPrimitive(dateFormatDDMMYYYY_HHmm.format(value));
                }
                return new JsonPrimitive(dateFormatDDMMYYYY_HHmmss.format(value));
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                String value = json.getAsString();
                String m_erro = "N\u00e3o \u00e9 uma data v\u00e1lida.";
                try {
                    int len_value = value.length();
                    if (len_value >= 6 && len_value <= 10) {
                        return dateFormatDDMMYYYY.parse(value);
                    }
                    if (len_value == 16) {
                        return dateFormatDDMMYYYY_HHmm.parse(value);
                    }
                    if (len_value == 19) {
                        return dateFormatDDMMYYYY_HHmmss.parse(value);
                    }
                    throw new EmsValidationException("N\u00e3o \u00e9 uma data v\u00e1lida.");
                }
                catch (ParseException e) {
                    throw new EmsValidationException("N\u00e3o \u00e9 uma data v\u00e1lida.");
                }
            }
        }).registerTypeAdapter(Timestamp.class, (Object)new JsonDeserializer<Timestamp>(){

            public Timestamp deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                String value = json.getAsString();
                String m_erro = "N\u00e3o \u00e9 uma data v\u00e1lida.";
                try {
                    int len_value = value.length();
                    if (len_value >= 6 && len_value <= 10) {
                        return new Timestamp(dateFormatDDMMYYYY.parse(value).getTime());
                    }
                    if (len_value == 16) {
                        return new Timestamp(dateFormatDDMMYYYY_HHmm.parse(value).getTime());
                    }
                    if (len_value == 19) {
                        return new Timestamp(dateFormatDDMMYYYY_HHmmss.parse(value).getTime());
                    }
                    throw new EmsValidationException("N\u00e3o \u00e9 uma data v\u00e1lida.");
                }
                catch (ParseException e) {
                    throw new EmsValidationException("N\u00e3o \u00e9 uma data v\u00e1lida.");
                }
            }
        }).registerTypeAdapter(Boolean.class, (Object)new JsonDeserializer<Boolean>(){

            public Boolean deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                String value = json.getAsString();
                if (value.equalsIgnoreCase("true")) {
                    return true;
                }
                if (value.equalsIgnoreCase("false")) {
                    return false;
                }
                if (value.equalsIgnoreCase("1")) {
                    return true;
                }
                if (value.equalsIgnoreCase("0")) {
                    return false;
                }
                if (value.equalsIgnoreCase("sim")) {
                    return true;
                }
                if (value.equalsIgnoreCase("1.0")) {
                    return true;
                }
                if (value.equalsIgnoreCase("yes")) {
                    return true;
                }
                return false;
            }
        }).create();
        properties = EmsUtil.getProperties();
    }

    public static class EmsFilterStatement {
        StringBuilder where = null;
        Map<String, Object> filtro_obj = null;

        public EmsFilterStatement(StringBuilder where, Map<String, Object> filtro_obj) {
            this.where = where;
            this.filtro_obj = filtro_obj;
        }
    }

    private static class MailSenderInfo {
        private String mailServerHost;
        private String mailServerPort = "25";
        private String fromAddress;
        private String toAddress;
        private String userName;
        private String password;
        private boolean validate = false;
        private String subject;
        private String content;
        private String[] attachFileNames = new String[0];
        private boolean withAttachment = true;

        private MailSenderInfo() {
        }

        public boolean isWithAttachment() {
            return this.withAttachment;
        }

        public void setWithAttachment(boolean withAttachment) {
            this.withAttachment = withAttachment;
        }

        public Properties getProperties() {
            Properties p = new Properties();
            p.put("mail.smtp.host", this.mailServerHost);
            p.put("mail.smtp.port", this.mailServerPort);
            p.put("mail.smtp.auth", this.validate ? "true" : "false");
            return p;
        }

        public void setMailServerHost(String mailServerHost) {
            this.mailServerHost = mailServerHost;
        }

        public void setMailServerPort(String mailServerPort) {
            this.mailServerPort = mailServerPort;
        }

        public String getFromAddress() {
            return this.fromAddress;
        }

        public void setFromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
        }

        public String getToAddress() {
            return this.toAddress;
        }

        public void setToAddress(String toAddress) {
            this.toAddress = toAddress;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean isValidate() {
            return this.validate;
        }

        public void setValidate(boolean validate) {
            this.validate = validate;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String[] getAttachFileNames() {
            return this.attachFileNames;
        }

        public void setAttachFileNames(String[] attachFileNames) {
            this.attachFileNames = attachFileNames;
        }
    }

    private static class MyAuthenticator
    extends Authenticator {
        private String userName = null;
        private String password = null;

        public MyAuthenticator(String username, String password) {
            this.userName = username;
            this.password = password;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.userName, this.password);
        }
    }

    public static class EmsProperties {
        public int maxThreadPool;
        public String ems_bus_node1;
        public String cookie;
        public String ESB_URL;
        public String hostName;
        public String nodeName;
        public String nodeUser;
        public String nodePasswd;
        public String authorizationHeaderName;
        public String authorizationHeaderValue;
        public Map<String, Object> daemon_params;
        public String daemon_params_encode;
        public boolean debug;
        public int msg_timeout = 60000;
        public String environment = "desenv";
        public boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
        public boolean isLinux = System.getProperty("os.name").toLowerCase().indexOf("nux") >= 0;
        public boolean isMac = System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
        public int pidfileWatchdogTimer = 30000;
        public String pidfile;
        public String logfile;
        public String daemon_service;
        public String daemon_id;
        public int smtpPort;
        public String smtp;
        public String smtpFrom;
        public String smtpPasswd;
        public String ldapUrl;
        public String ldapAdmin;
        public String ldapAdminPasswd;
        public int postUpdateTimeout;
        public String service_scan = "br.unb";
    }

    public static class HibernateProxyTypeAdapter
    extends TypeAdapter<HibernateProxy> {
        public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                return HibernateProxy.class.isAssignableFrom(type.getRawType()) ? new HibernateProxyTypeAdapter(gson) : null;
            }
        };
        private final Gson context;

        private HibernateProxyTypeAdapter(Gson context) {
            this.context = context;
        }

        public HibernateProxy read(JsonReader in) throws IOException {
            throw new UnsupportedOperationException("Not supported");
        }

        public void write(JsonWriter out, HibernateProxy value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            try {
                Class baseType = Hibernate.getClass((Object)value);
                TypeAdapter delegate = this.context.getAdapter(TypeToken.get((Class)baseType));
                Object unproxiedValue = value.getHibernateLazyInitializer().getImplementation();
                delegate.write(out, unproxiedValue);
            }
            catch (Exception e) {
                out.nullValue();
            }
        }
    }

    private static class SerializeStrategy
    implements ExclusionStrategy {
        private SerializeStrategy() {
        }

        public boolean shouldSkipClass(Class<?> c) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes f) {
            OneToOne oneToOne = (OneToOne)f.getAnnotation(OneToOne.class);
            if (oneToOne != null && oneToOne.fetch() == FetchType.EAGER) {
                return false;
            }
            return f.getDeclaredType() == List.class || f.getAnnotation(OneToMany.class) != null || f.getAnnotation(JoinTable.class) != null || f.getAnnotation(ManyToMany.class) != null;
        }
    }
}

