/*
 * Decompiled with CFR 0.152.
 */
package br.erlangms;

import br.erlangms.EmsUtil;
import br.erlangms.EmsValidationException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class EmsServiceStream {
    private String from_url = null;
    private Map<String, Object> queries = new HashMap<String, Object>();
    private String response = null;

    public EmsServiceStream from(String url) {
        if (url == null || url.isEmpty()) {
            throw new EmsValidationException("Par\u00e2metro do m\u00e9todo EmsServiceStream.from(final String url) n\u00e3o pode ser nulo.");
        }
        this.from_url = url;
        return this;
    }

    public EmsServiceStream setParameter(Integer value) {
        if (value == null) {
            throw new EmsValidationException("Par\u00e2metro value do EmsServiceStream.setParameter n\u00e3o pode ser nulo.");
        }
        this.from_url = this.from_url.replaceFirst(":id", value.toString());
        return this;
    }

    public EmsServiceStream setQuery(String key, Object value) {
        this.queries.put(key, value);
        return this;
    }

    public EmsServiceStream request() {
        String restUrl = EmsUtil.properties.ESB_URL + this.from_url;
        URL url = null;
        try {
            url = new URL(restUrl);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new EmsValidationException("EmsServiceStream n\u00e3o conseguiu criar a url " + restUrl);
        }
        URLConnection con = null;
        try {
            con = url.openConnection();
            con.setRequestProperty(EmsUtil.properties.authorizationHeaderName, EmsUtil.properties.authorizationHeaderValue);
            con.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new EmsValidationException("EmsServiceStream n\u00e3o conseguiu criar a conex\u00e3o da url " + restUrl);
        }
        try {
            this.response = EmsUtil.readFullyAsString(con.getInputStream(), "UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new EmsValidationException("EmsServiceStream n\u00e3o conseguiu ler o response da url " + restUrl);
        }
        return this;
    }

    public <T> List<T> toList(Class<T> classOfModel) {
        return EmsUtil.fromListJson(this.response.toString(), classOfModel, null);
    }

    public List<Object> toList() {
        return EmsUtil.fromJson(this.response.toString(), List.class);
    }

    public <T> T getObject(Class<T> classOfModel) {
        return EmsUtil.fromJson(this.response, classOfModel);
    }

    public Object getObject() {
        return this.response;
    }

    static {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSL");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        try {
            sc.init(null, trustAllCerts, new SecureRandom());
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }
}

