/*
 * Decompiled with CFR 0.152.
 */
package br.erlangms;

import br.erlangms.EmsNotFoundException;
import br.erlangms.EmsUtil;
import br.erlangms.EmsValidationException;
import br.erlangms.IEmsRequest;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.persistence.Column;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Id;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.AliasedTupleSubsetResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.jinq.jpa.JPAJinqStream;
import org.jinq.jpa.JinqJPAStreamProvider;

public abstract class EmsRepository<Model>
implements Serializable {
    private static final long serialVersionUID = 4246028326643284073L;
    private static final Logger logger = EmsUtil.logger;
    private Class<Model> classOfModel = null;
    private EntityManager entityManager = null;
    private EntityManagerFactory entityManagerFactory = null;
    private Field idField = null;
    private String idFieldName = null;
    private Column idFieldColumn = null;
    private List<String> cachedNamedQuery = new ArrayList<String>();
    private List<String> cachedNativeNamedQuery = new ArrayList<String>();
    private boolean hasContraints = false;
    private Table tableAnnotation = null;
    private UniqueConstraint[] tableContrains = null;
    private List<Field> fieldsConstraints = null;
    private List<Field> fields = null;
    private String[] fieldNames = null;
    private String NAMED_QUERY_DELETE = null;
    private String NAMED_QUERY_EXISTS = null;
    private String NAMED_QUERY_CHECK_CONTRAINTS_ON_INSERT = null;
    private String NAMED_QUERY_CHECK_CONTRAINTS_ON_UPDATE = null;
    private String prefixFindNamedQuery = null;

    public abstract Class<Model> getClassOfModel();

    public abstract EntityManager getEntityManager();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostConstruct
    private void postConstruct() {
        this.classOfModel = this.getClassOfModel();
        if (this.classOfModel == null) throw new EmsValidationException("N\u00e3o foi implementado getClassOfModel() para a classe " + this.getClass().getSimpleName());
        this.prefixFindNamedQuery = this.classOfModel.getSimpleName() + "_";
        this.entityManager = this.getEntityManager();
        if (this.entityManager == null) throw new EmsValidationException("N\u00e3o foi implementado getEntityManager() para a classe " + this.getClass().getSimpleName());
        this.entityManagerFactory = this.entityManager.getEntityManagerFactory();
        this.idField = EmsUtil.findFieldByAnnotation(this.classOfModel, Id.class);
        if (this.idField == null) throw new EmsValidationException("O modelo " + this.classOfModel.getSimpleName() + " n\u00e3o possui nenhum campo com a anota\u00e7\u00e3o @Id.");
        this.idFieldName = this.idField.getName();
        this.tableAnnotation = this.classOfModel.getAnnotation(Table.class);
        this.idFieldColumn = this.idField.getAnnotation(Column.class);
        if (this.tableAnnotation != null) {
            this.tableContrains = this.tableAnnotation.uniqueConstraints();
        }
        this.fieldsConstraints = EmsUtil.getFieldsWithUniqueConstraint(this.classOfModel);
        this.fields = EmsUtil.getFieldsFromModel(this.classOfModel);
        this.fieldNames = new String[this.fields.size()];
        for (int i = 0; i < this.fields.size(); ++i) {
            Field f = this.fields.get(i);
            f.setAccessible(true);
            this.fieldNames[i] = f.getName();
        }
        if (this.tableAnnotation == null) return;
        this.doCreateCachedNamedQueries();
    }

    public JPAJinqStream<Model> getStreams() {
        JinqJPAStreamProvider streams = new JinqJPAStreamProvider(this.entityManager.getMetamodel());
        return streams.streamAll(this.entityManager, this.classOfModel);
    }

    public <T> JPAJinqStream<T> getStreams(Class<T> classOfModel) {
        if (classOfModel != null) {
            JinqJPAStreamProvider streams = new JinqJPAStreamProvider(this.entityManager.getMetamodel());
            return streams.streamAll(this.entityManager, classOfModel);
        }
        throw new EmsValidationException("Par\u00e2metro classOfModel n\u00e3o pode ser null para EsRepository.getStreams.");
    }

    public List<Map<String, Object>> findAsMap(IEmsRequest request) {
        if (request != null) {
            String filter = request.getQuery("filter");
            String fields = request.getQuery("fields");
            int limit = request.getQueryAsInt("limit", 100);
            int offset = request.getQueryAsInt("offset", 0);
            String sort = request.getQuery("sort");
            return this.findAsMap(filter, fields, limit, offset, sort);
        }
        throw new EmsValidationException("Par\u00e2metro request n\u00e3o pode ser null para EsRepository.findAsMap.");
    }

    public List<Map<String, Object>> findAsMap(String filter, String fields, int limit, int offset, String sort) {
        Query query = this.parseQuery(filter, fields, limit, offset, sort, null);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        org.hibernate.Query q = (org.hibernate.Query)query.unwrap(org.hibernate.Query.class);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List result = q.list();
        return result;
    }

    public List<Map<String, Object>> findAsMap(String sql) {
        if (sql != null && !sql.isEmpty()) {
            String namedQuery = this.prefixFindNamedQuery + EmsUtil.toBase64(EmsUtil.toSHA1(sql));
            Query query = this.createNativeNamedQuery(namedQuery, sql, null);
            org.hibernate.Query q = (org.hibernate.Query)query.unwrap(org.hibernate.Query.class);
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List result = q.list();
            return result;
        }
        throw new EmsValidationException("Par\u00e2metro sql n\u00e3o pode ser null para EmsRepository.find.");
    }

    public List<Map<String, Object>> findAsMap(String sql, String filter, String fields, int limit, int offset, String sort) {
        String namedQuery;
        Query query = null;
        StringBuilder field_smnt = null;
        EmsUtil.EmsFilterStatement where = null;
        StringBuilder sort_smnt = null;
        if (limit <= 0 || limit > 999999999) {
            throw new EmsValidationException("Par\u00e2metro limit da pesquisa fora do intervalo permitido. Deve ser maior que zero e menor ou igual que 999999999");
        }
        if (offset < 0 || offset >= 999999999) {
            throw new EmsValidationException("Par\u00e2metro offset da pesquisa fora do intervalo permitido. Deve ser maior que zero e menor que 999999999");
        }
        if (filter == null) {
            filter = "";
        }
        if (fields == null) {
            fields = "";
        }
        if (sort == null) {
            sort = "";
        }
        if (!this.cachedNativeNamedQuery.contains(namedQuery = this.prefixFindNamedQuery + EmsUtil.toBase64(EmsUtil.toSHA1(sql + filter + fields + sort)))) {
            where = EmsUtil.parseSqlNativeFilter(filter);
            if (fields != null && !fields.isEmpty()) {
                try {
                    field_smnt = new StringBuilder();
                    String[] field_list = fields.split(",");
                    boolean useVirgula = false;
                    for (String field_name : field_list) {
                        if (useVirgula) {
                            field_smnt.append(",");
                        }
                        if (field_name.equals("pk")) {
                            field_smnt.append("this.").append(this.idField.getName());
                        } else {
                            field_smnt.append("this.").append(field_name);
                        }
                        useVirgula = true;
                    }
                }
                catch (Exception e) {
                    throw new EmsValidationException("Lista de campos da pesquisa inv\u00e1lido. Erro interno: " + e.getMessage());
                }
            }
            if (sort != null && !sort.isEmpty()) {
                try {
                    boolean useVirgula = false;
                    sort_smnt = new StringBuilder(" order by");
                    String[] sort_list = sort.split(",");
                    String sort_field = null;
                    for (String s : sort_list) {
                        if (useVirgula) {
                            sort_smnt.append(",");
                        }
                        if (s.startsWith("-")) {
                            sort_field = s.substring(1);
                            if (sort_field.equals("pk")) {
                                sort_field = this.idField.getName();
                            }
                            sort_smnt.append(" this.").append(sort_field).append(" desc");
                        } else {
                            sort_field = s;
                            if (sort_field.equals("pk")) {
                                sort_field = this.idField.getName();
                            }
                            sort_smnt.append(" this.").append(sort_field);
                        }
                        useVirgula = true;
                    }
                }
                catch (Exception e) {
                    throw new EmsValidationException("Sort da pesquisa inv\u00e1lido. Erro interno: " + e.getMessage());
                }
            }
            try {
                StringBuilder sqlBuilder = new StringBuilder("select ").append(field_smnt == null ? "*" : field_smnt).append(" from (").append(sql).append(") this ");
                if (where != null) {
                    sqlBuilder.append(where.where.toString());
                }
                if (sort_smnt != null) {
                    sqlBuilder.append(sort_smnt.toString());
                }
                String sqlCommand = sqlBuilder.toString();
                query = this.createNativeNamedQuery(namedQuery, sqlCommand, null);
            }
            catch (Exception e) {
                throw new EmsValidationException("N\u00e3o foi poss\u00edvel criar a query da pesquisa. Erro interno: " + e.getMessage());
            }
        }
        query = this.getNamedQuery(namedQuery);
        where = EmsUtil.parseSqlNativeFilter(filter);
        if (where != null) {
            EmsUtil.setQueryParameterFromMap(query, where.filtro_obj);
        }
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        org.hibernate.Query q = (org.hibernate.Query)query.unwrap(org.hibernate.Query.class);
        q.setResultTransformer((ResultTransformer)EmsAliasToEntityMapResultTransformer.INSTANCE);
        List result = q.list();
        return result;
    }

    public List<Map<String, Object>> findAsMap(String sql, String filter, String fields, String sort) {
        String namedQuery;
        Query query = null;
        StringBuilder field_smnt = null;
        EmsUtil.EmsFilterStatement where = null;
        StringBuilder sort_smnt = null;
        if (filter == null) {
            filter = "";
        }
        if (fields == null) {
            fields = "";
        }
        if (sort == null) {
            sort = "";
        }
        if (!this.cachedNativeNamedQuery.contains(namedQuery = this.prefixFindNamedQuery + EmsUtil.toBase64(EmsUtil.toSHA1(sql + filter + fields + sort)))) {
            where = EmsUtil.parseSqlNativeFilter(filter);
            if (fields != null && !fields.isEmpty()) {
                try {
                    field_smnt = new StringBuilder();
                    String[] field_list = fields.split(",");
                    boolean useVirgula = false;
                    for (String field_name : field_list) {
                        if (useVirgula) {
                            field_smnt.append(",");
                        }
                        if (field_name.equals("pk")) {
                            field_smnt.append("this.").append(this.idField.getName());
                        } else {
                            field_smnt.append("this.").append(field_name);
                        }
                        useVirgula = true;
                    }
                }
                catch (Exception e) {
                    throw new EmsValidationException("Lista de campos da pesquisa inv\u00e1lido. Erro interno: " + e.getMessage());
                }
            }
            if (sort != null && !sort.isEmpty()) {
                try {
                    boolean useVirgula = false;
                    sort_smnt = new StringBuilder(" order by");
                    String[] sort_list = sort.split(",");
                    String sort_field = null;
                    for (String s : sort_list) {
                        if (useVirgula) {
                            sort_smnt.append(",");
                        }
                        if (s.startsWith("-")) {
                            sort_field = s.substring(1);
                            if (sort_field.equals("pk")) {
                                sort_field = this.idField.getName();
                            }
                            sort_smnt.append(" this.").append(sort_field).append(" desc");
                        } else {
                            sort_field = s;
                            if (sort_field.equals("pk")) {
                                sort_field = this.idField.getName();
                            }
                            sort_smnt.append(" this.").append(sort_field);
                        }
                        useVirgula = true;
                    }
                }
                catch (Exception e) {
                    throw new EmsValidationException("Sort da pesquisa inv\u00e1lido. Erro interno: " + e.getMessage());
                }
            }
            try {
                StringBuilder sqlBuilder = new StringBuilder("select ").append(field_smnt == null ? "*" : field_smnt).append(" from (").append(sql).append(") this ");
                if (where != null) {
                    sqlBuilder.append(where.where.toString());
                }
                if (sort_smnt != null) {
                    sqlBuilder.append(sort_smnt.toString());
                }
                String sqlCommand = sqlBuilder.toString();
                query = this.createNativeNamedQuery(namedQuery, sqlCommand, null);
            }
            catch (Exception e) {
                throw new EmsValidationException("N\u00e3o foi poss\u00edvel criar a query da pesquisa. Erro interno: " + e.getMessage());
            }
        }
        query = this.getNamedQuery(namedQuery);
        where = EmsUtil.parseSqlNativeFilter(filter);
        if (where != null) {
            EmsUtil.setQueryParameterFromMap(query, where.filtro_obj);
        }
        org.hibernate.Query q = (org.hibernate.Query)query.unwrap(org.hibernate.Query.class);
        q.setResultTransformer((ResultTransformer)EmsAliasToEntityMapResultTransformer.INSTANCE);
        List result = q.list();
        return result;
    }

    public List<Model> find(String filter, String fields, int limit, int offset, String sort) {
        Query query = this.parseQuery(filter, fields, limit, offset, sort, null);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        List result = query.getResultList();
        return result;
    }

    public List<Model> find(IEmsRequest request) {
        if (request != null) {
            String filter = request.getQuery("filter");
            String fields = request.getQuery("fields");
            int limit = request.getQueryAsInt("limit", 100);
            int offset = request.getQueryAsInt("offset", 0);
            String sort = request.getQuery("sort");
            return this.find(filter, fields, limit, offset, sort);
        }
        throw new EmsValidationException("Par\u00e2metro request n\u00e3o pode ser null para EsRepository.find.");
    }

    public List<Model> find(String filter, String fields, int limit, int offset, String sort, Object owner) {
        String new_filter = null;
        String fieldName = null;
        if (owner == null) {
            throw new EmsValidationException("Par\u00e2metro owner n\u00e3o pode ser nulo para EmsRepository.find.");
        }
        Integer idOwner = EmsUtil.getIdFromObject(owner);
        fieldName = "id" + owner.getClass().getSimpleName();
        if (filter != null) {
            Map<String, Integer> filtro_obj = new HashMap();
            filtro_obj = EmsUtil.fromJson(filter, HashMap.class);
            filtro_obj.put(fieldName, idOwner);
            new_filter = EmsUtil.toJson(filtro_obj);
            return this.find(new_filter, fields, limit, offset, sort);
        }
        throw new EmsValidationException("Par\u00e2metro filter n\u00e3o pode ser nulo para EmsRepository.find.");
    }

    public List<Model> find(Map<String, Object> filter, String fields, int limit, int offset, String sort) {
        if (filter != null && !filter.isEmpty()) {
            String filterJson = EmsUtil.toJson(filter);
            return this.find(filterJson, fields, limit, offset, sort);
        }
        throw new EmsValidationException("Par\u00e2metro filter n\u00e3o pode ser nulo para EmsRepository.find.");
    }

    public Model findById(IEmsRequest request) {
        if (request != null) {
            Integer id = request.getParamAsInt("id");
            if (id != null && id >= 0) {
                Object obj = this.entityManager.find(this.classOfModel, (Object)id);
                if (obj == null) {
                    throw new EmsNotFoundException(this.classOfModel.getSimpleName() + " n\u00e3o encontrado: " + id.toString());
                }
                return (Model)obj;
            }
            throw new EmsValidationException("Par\u00e2metro id n\u00e3o pode ser null para EmsRepository.findById.");
        }
        throw new EmsValidationException("Par\u00e2metro request n\u00e3o pode ser null para EsRepository.find.");
    }

    public Model findById(Integer id) {
        if (id != null && id >= 0) {
            Object obj = this.entityManager.find(this.classOfModel, (Object)id);
            if (obj == null) {
                throw new EmsNotFoundException(this.classOfModel.getSimpleName() + " n\u00e3o encontrado: " + id.toString());
            }
            return (Model)obj;
        }
        throw new EmsValidationException("Par\u00e2metro id n\u00e3o pode ser null para EmsRepository.findById.");
    }

    public List<Model> findByField(Field field, Object value) {
        if (field != null) {
            String fieldName = field.getName();
            String sqlFindByField = "select this from " + this.classOfModel.getSimpleName() + " this" + " where this." + field.getName() + "=:pField";
            return this.createNamedQuery(this.classOfModel.getSimpleName() + ".findBy" + fieldName, sqlFindByField).setParameter("pField", value).getResultList();
        }
        throw new EmsValidationException("Par\u00e2metro field n\u00e3o pode ser null para EmsRepository.findByField.");
    }

    public List<Model> findByField(String fieldName, Object value) {
        if (fieldName != null) {
            Field field = this.getField(fieldName);
            return this.findByField(field, value);
        }
        throw new EmsValidationException("Par\u00e2metro fieldName n\u00e3o pode ser null para EmsRepository.findByField.");
    }

    public Model findFirstByField(Field field, Object value) {
        if (field != null) {
            String fieldName = field.getName();
            String nameOfClass = this.classOfModel.getSimpleName();
            String sqlFindByField = "select this from " + nameOfClass + " this " + " where this." + fieldName + "=:pField";
            try {
                return (Model)this.createNamedQuery(nameOfClass + ".findBy" + fieldName, sqlFindByField).setParameter("pField", value).setMaxResults(1).getSingleResult();
            }
            catch (NoResultException e) {
                throw new EmsNotFoundException(nameOfClass + " n\u00e3o encontrado pelo campo " + fieldName);
            }
        }
        throw new EmsValidationException("Par\u00e2metro field n\u00e3o pode ser null para EmsRepository.findFirstByField.");
    }

    public Model findFirstByField(String fieldName, Object value) {
        if (fieldName != null) {
            Field field = this.getField(fieldName);
            return this.findFirstByField(field, value);
        }
        throw new EmsValidationException("Par\u00e2metro fieldName n\u00e3o pode ser null para EmsRepository.findByField.");
    }

    public boolean exists(Map<String, Object> filter_map) {
        if (filter_map != null) {
            boolean anyMatch = false;
            Query query = null;
            String fieldName = null;
            String filter = null;
            ArrayList<String> listFunction = new ArrayList<String>();
            if (!filter_map.isEmpty()) {
                Iterator<String> iterator = filter_map.keySet().iterator();
                if (iterator.hasNext()) {
                    String field;
                    fieldName = field = iterator.next();
                }
            } else {
                throw new EmsValidationException("\u00c9 necess\u00e1rio informar filter_map para EmsRepository.exists.");
            }
            listFunction.add(0, "count");
            listFunction.add(1, fieldName);
            filter = EmsUtil.toJson(filter_map);
            query = this.parseQuery(filter, null, 1, 0, null, listFunction);
            long result = (Long)query.getSingleResult();
            if (result >= 1L) {
                anyMatch = true;
            }
            return anyMatch;
        }
        throw new EmsValidationException("filer_map n\u00e3o pode ser null para EmsRepository.exists.");
    }

    public boolean exists(Integer id) {
        if (id != null && id >= 0) {
            try {
                this.getNamedQuery(this.NAMED_QUERY_EXISTS).setParameter("pId", (Object)id).getSingleResult();
                return true;
            }
            catch (NoResultException e) {
                return false;
            }
            catch (NonUniqueResultException e) {
                return true;
            }
        }
        throw new EmsValidationException("Par\u00e2metro id do objeto n\u00e3o pode ser null para EmsRepository.exists.");
    }

    public <T> T findById(Class<T> classOfModel, Integer id) {
        if (classOfModel != null && id != null && id >= 0) {
            Object obj = this.entityManager.find(classOfModel, (Object)id);
            if (obj == null) {
                throw new EmsNotFoundException(classOfModel.getSimpleName() + " n\u00e3o encontrado: " + id.toString());
            }
            return (T)obj;
        }
        throw new EmsValidationException("Par\u00e2metros classOfModel e id n\u00e3o podem ser null para EmsRepository.findById.");
    }

    public Model update(Model obj) {
        return this.update(obj, true);
    }

    public Model update(Model obj, boolean flush) {
        if (obj != null) {
            Integer idValue = EmsUtil.getIdFromObject(obj);
            if (idValue != null && idValue >= 0) {
                if (this.hasContraints) {
                    this.checkConstraints(obj, false);
                }
            } else {
                throw new EmsValidationException("N\u00e3o \u00e9 poss\u00edvel atualizar objeto sem id em EmsRepository.update.");
            }
            this.entityManager.merge(obj);
            if (flush) {
                this.entityManager.flush();
            }
            return obj;
        }
        throw new EmsValidationException("Par\u00e2metro obj n\u00e3o pode ser null para EmsRepository.update.");
    }

    public Model insert(Model obj) {
        return this.insert(obj, true);
    }

    public Model insert(Model obj, boolean flush) {
        if (obj != null) {
            if (this.getIdFromObject(obj) != null) {
                throw new EmsValidationException("N\u00e3o \u00e9 poss\u00edvel incluir objeto que j\u00e1 possui identificador.");
            }
            if (this.hasContraints) {
                this.checkConstraints(obj, true);
            }
            this.entityManager.persist(obj);
            if (flush) {
                this.entityManager.flush();
            }
            return obj;
        }
        throw new EmsValidationException("Par\u00e2metro obj n\u00e3o pode ser null para EmsRepository.insert.");
    }

    private void checkConstraints(Model obj, boolean isInsert) {
        Query query = null;
        query = isInsert ? this.getNamedQuery(this.NAMED_QUERY_CHECK_CONTRAINTS_ON_INSERT) : this.getNamedQuery(this.NAMED_QUERY_CHECK_CONTRAINTS_ON_UPDATE);
        for (Parameter p : query.getParameters()) {
            String paramName = p.getName();
            Field field = null;
            try {
                for (int i = 0; i < this.fields.size() && !(field = this.fields.get(i)).getAnnotation(Column.class).name().equals(paramName); ++i) {
                }
                Object value = field.get(obj);
                query.setParameter(paramName, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                throw new EmsValidationException("N\u00e3o \u00e9 poss\u00edvel verificar as constraints do objeto " + this.classOfModel.getSimpleName() + ". Erro interno: " + e.getMessage());
            }
        }
        try {
            query.getSingleResult();
        }
        catch (NoResultException e) {
            return;
        }
        catch (Exception e) {
            throw new EmsValidationException("N\u00e3o \u00e9 poss\u00edvel verificar as constraints do objeto " + this.classOfModel.getSimpleName() + ". Erro interno: " + e.getMessage());
        }
        throw new EmsValidationException("Registro duplicado, verifique.");
    }

    public Model insertOrUpdate(Model obj) {
        return this.insertOrUpdate(obj, true);
    }

    public Model insertOrUpdate(Model obj, boolean flush) {
        if (obj != null) {
            Integer idValue = EmsUtil.getIdFromObject(obj);
            if (idValue != null && idValue >= 0) {
                if (this.hasContraints) {
                    this.checkConstraints(obj, false);
                }
                this.entityManager.merge(obj);
            } else {
                if (this.hasContraints) {
                    this.checkConstraints(obj, true);
                }
                this.entityManager.persist(obj);
            }
            if (flush) {
                this.entityManager.flush();
            }
            return obj;
        }
        throw new EmsValidationException("Par\u00e2metro obj n\u00e3o pode ser null para EmsRepository.insertOrUpdate.");
    }

    public boolean delete(Integer id) {
        if (id != null && id >= 0) {
            return this.getNamedQuery(this.NAMED_QUERY_DELETE).setParameter("pId", (Object)id).executeUpdate() > 0;
        }
        throw new EmsValidationException("Par\u00e2metro id deve ser maior que zero para EmsRepository.delete.");
    }

    public <T> boolean delete(Class<T> classOfModel, Integer id) {
        if (classOfModel != null && id != null && id >= 0) {
            Field field = EmsUtil.findFieldByAnnotation(classOfModel, Id.class);
            if (field == null) {
                throw new EmsValidationException(classOfModel.getSimpleName() + " n\u00e3o possui campo id.");
            }
            String idFieldName = field.getName();
            String sql = "delete from " + classOfModel.getSimpleName() + " where " + idFieldName + "=:pId";
            String namedQuery = classOfModel.getSimpleName() + ".EmsRepository.delete";
            return this.createNamedQuery(namedQuery, sql).setParameter("pId", (Object)id).executeUpdate() > 0;
        }
        throw new EmsValidationException("Par\u00e2metros classOfModel e id do m\u00e9todo EmsRepository.delete n\u00e3o podem ser null");
    }

    protected void createCachedNamedQueries() {
    }

    public Query parseQuery(String filter, String fields, int limit, int offset, String sort, List<String> listFunction) {
        Query query = null;
        StringBuilder field_smnt = null;
        StringBuilder where = null;
        StringBuilder sort_smnt = null;
        String sqlFunction = null;
        Map filtro_obj = null;
        String simpleNameOfModel = this.classOfModel.getSimpleName();
        if (limit <= 0 || limit > 999999999) {
            throw new EmsValidationException("Par\u00e2metro limit da pesquisa fora do intervalo permitido. Deve ser maior que zero e menor ou igual que 999999999");
        }
        if (offset < 0 || offset >= 999999999) {
            throw new EmsValidationException("Par\u00e2metro offset da pesquisa fora do intervalo permitido. Deve ser maior que zero e menor que 999999999");
        }
        if (filter != null && filter.length() > 5) {
            try {
                boolean useAnd = false;
                filtro_obj = EmsUtil.fromJson(filter, HashMap.class);
                where = new StringBuilder("where ");
                int p = 1;
                for (String field : filtro_obj.keySet()) {
                    String sqlOperator;
                    String fieldOperator;
                    String fieldName;
                    String[] field_defs;
                    int field_len;
                    if (useAnd) {
                        where.append(" and ");
                    }
                    if ((field_len = (field_defs = field.split("__")).length) == 1) {
                        fieldName = field;
                        fieldOperator = "=";
                        sqlOperator = "=";
                    } else if (field_len == 2) {
                        fieldName = field_defs[0];
                        fieldOperator = field_defs[1];
                        sqlOperator = EmsUtil.fieldOperatorToSqlOperator(fieldOperator);
                    } else {
                        throw new EmsValidationException("Campo de pesquisa " + field + " inv\u00e1lido.");
                    }
                    if (fieldName.equals("pk")) {
                        fieldName = this.idField.getName();
                    } else {
                        this.getField(fieldName);
                    }
                    if (field_len == 2) {
                        if (fieldOperator.equals("isnull")) {
                            boolean fieldBoolean = EmsUtil.parseAsBoolean(filtro_obj.get(field));
                            if (fieldBoolean) {
                                where.append(fieldName).append(" is null ");
                            } else {
                                where.append(fieldName).append(" is not null ");
                            }
                        } else if (fieldOperator.equals("icontains") || fieldOperator.equals("ilike")) {
                            fieldName = String.format("lower(this.%s)", fieldName);
                            where.append(fieldName).append(sqlOperator).append("?").append(p++);
                        } else if (fieldOperator.equals("in")) {
                            fieldName = String.format("this.%s", fieldName);
                            where.append(fieldName).append(sqlOperator).append("?").append(p++);
                        } else {
                            fieldName = String.format("this.%s", fieldName);
                            where.append(fieldName).append(sqlOperator).append("?").append(p++);
                            System.out.println(where.toString());
                        }
                    } else {
                        fieldName = String.format("this.%s", fieldName);
                        where.append(fieldName).append(sqlOperator).append("?").append(p++);
                    }
                    useAnd = true;
                }
            }
            catch (Exception e) {
                throw new EmsValidationException("Filtro da pesquisa inv\u00e1lido. Erro interno: " + e.getMessage());
            }
        }
        if (fields != null && !fields.isEmpty()) {
            try {
                field_smnt = new StringBuilder();
                String[] field_list = fields.split(",");
                boolean useVirgula = false;
                for (String field_name : field_list) {
                    if (useVirgula) {
                        field_smnt.append(",");
                    }
                    if (field_name.equals("pk")) {
                        field_smnt.append("this.").append(this.idField.getName());
                    } else {
                        field_smnt.append("this.").append(field_name);
                    }
                    useVirgula = true;
                }
            }
            catch (Exception e) {
                throw new EmsValidationException("Lista de campos da pesquisa inv\u00e1lido. Erro interno: " + e.getMessage());
            }
        }
        if (sort != null && !sort.isEmpty()) {
            try {
                boolean useVirgula = false;
                sort_smnt = new StringBuilder(" order by");
                String[] sort_list = sort.split(",");
                String sort_field = null;
                for (String s : sort_list) {
                    if (useVirgula) {
                        sort_smnt.append(",");
                    }
                    if (s.startsWith("-")) {
                        sort_field = s.substring(1);
                        if (sort_field.equals("pk")) {
                            sort_field = this.idField.getName();
                        }
                        sort_smnt.append(" this.").append(sort_field).append(" desc");
                    } else {
                        sort_field = s;
                        if (sort_field.equals("pk")) {
                            sort_field = this.idField.getName();
                        }
                        sort_smnt.append(" this.").append(sort_field);
                    }
                    useVirgula = true;
                }
            }
            catch (Exception e) {
                throw new EmsValidationException("Sort da pesquisa inv\u00e1lido. Erro interno: " + e.getMessage());
            }
        }
        if (listFunction != null && !listFunction.isEmpty()) {
            sqlFunction = EmsUtil.listFunctionToSqlFunction(listFunction);
        }
        try {
            StringBuilder sqlBuilder = listFunction == null ? new StringBuilder("select ").append(field_smnt == null ? "this" : field_smnt.toString()).append(" from ").append(simpleNameOfModel).append(" this ") : new StringBuilder("select ").append(sqlFunction).append(" from ").append(simpleNameOfModel).append(" this ");
            if (where != null) {
                sqlBuilder.append(where.toString());
            }
            if (sort_smnt != null) {
                sqlBuilder.append(sort_smnt.toString());
            }
            String sql = sqlBuilder.toString();
            query = this.createNamedQuery(sql, sql);
        }
        catch (Exception e) {
            throw new EmsValidationException("N\u00e3o foi poss\u00edvel criar a query da pesquisa. Erro interno: " + e.getMessage());
        }
        if (where != null) {
            EmsUtil.setQueryParameterFromMap(query, filtro_obj);
        }
        return query;
    }

    protected Query createNamedQuery(String namedQuery, String sql) {
        Query query = null;
        if (this.cachedNamedQuery.contains(namedQuery)) {
            query = this.entityManager.createNamedQuery(namedQuery);
        } else {
            this.cachedNamedQuery.add(namedQuery);
            try {
                query = this.entityManager.createQuery(sql);
            }
            catch (Exception e) {
                throw new EmsValidationException("N\u00e3o foi poss\u00edvel criar namedQuery " + namedQuery + " para o sql \"" + sql + "\" no m\u00e9todo EmsRepository.createNamedQuery. Erro interno: " + e.getMessage());
            }
            this.entityManagerFactory.addNamedQuery(namedQuery, query);
            logger.info("Build named query: " + namedQuery);
            logger.info("\tSQL: " + sql);
        }
        return query;
    }

    protected <T> Query createNativeNamedQuery(String namedQuery, String sql, Class<T> resultClass) {
        Query query = null;
        if (this.cachedNativeNamedQuery.contains(namedQuery)) {
            query = this.entityManager.createNamedQuery(namedQuery);
        } else {
            this.cachedNativeNamedQuery.add(namedQuery);
            query = resultClass == null ? this.entityManager.createNativeQuery(sql) : this.entityManager.createNativeQuery(sql, resultClass);
            this.entityManagerFactory.addNamedQuery(namedQuery, query);
            logger.info("Build native named query: " + namedQuery);
            logger.info("\tSQL: " + sql);
        }
        return query;
    }

    protected Query getNamedQuery(String namedQuery) {
        return this.entityManager.createNamedQuery(namedQuery);
    }

    private void doCreateCachedNamedQueries() {
        String nameOfModel = this.classOfModel.getName();
        String simpleNameOfModel = this.classOfModel.getSimpleName();
        this.NAMED_QUERY_DELETE = nameOfModel + ".delete";
        String sqlDelete = "delete from " + simpleNameOfModel + " where " + this.idFieldName + "=:pId";
        this.createNamedQuery(this.NAMED_QUERY_DELETE, sqlDelete);
        this.NAMED_QUERY_EXISTS = nameOfModel + ".exists";
        String sqlExists = "select 1 from " + simpleNameOfModel + " where " + this.idFieldName + "=:pId";
        this.createNamedQuery(this.NAMED_QUERY_EXISTS, sqlExists);
        String sqlQueryConstraintInsert = this.createSqlForConstraintCheck(true);
        boolean bl = this.hasContraints = sqlQueryConstraintInsert != null;
        if (this.hasContraints) {
            this.NAMED_QUERY_CHECK_CONTRAINTS_ON_INSERT = nameOfModel + ".checkConstraintInsert";
            this.createNativeNamedQuery(this.NAMED_QUERY_CHECK_CONTRAINTS_ON_INSERT, sqlQueryConstraintInsert, null);
            String sqlQueryConstraintUpdate = this.createSqlForConstraintCheck(false);
            this.NAMED_QUERY_CHECK_CONTRAINTS_ON_UPDATE = nameOfModel + ".checkConstraintUpdate";
            this.createNativeNamedQuery(this.NAMED_QUERY_CHECK_CONTRAINTS_ON_UPDATE, sqlQueryConstraintUpdate, null);
        }
        this.createCachedNamedQueries();
    }

    private String createSqlForConstraintCheck(boolean isInsert) {
        boolean hasContraints;
        int tableConstraintsCount = this.tableContrains.length;
        int fieldConstraintsCount = this.fieldsConstraints.size();
        boolean bl = hasContraints = this.tableContrains.length > 0 || fieldConstraintsCount > 0;
        if (hasContraints) {
            int i;
            StringBuilder sql = new StringBuilder();
            sql.append("select top(1) 1 ").append("from ").append(this.tableAnnotation.name()).append(" this where ");
            if (!isInsert) {
                String idFieldColumnName = this.idFieldColumn.name();
                sql.append(idFieldColumnName).append("!=:").append(idFieldColumnName).append(" and (");
            }
            for (i = 0; i < tableConstraintsCount; ++i) {
                UniqueConstraint c = this.tableContrains[i];
                String[] columnNames = c.columnNames();
                int columnNamesCount = columnNames.length;
                sql.append("(");
                for (int j = 0; j < columnNamesCount; ++j) {
                    String f = columnNames[j];
                    sql.append("this.").append(f).append("=:").append(f);
                    if (j + 1 >= columnNamesCount) continue;
                    sql.append(" and ");
                }
                sql.append(")");
                if (i + 1 >= tableConstraintsCount) continue;
                sql.append(" or ");
            }
            if (fieldConstraintsCount > 0) {
                if (tableConstraintsCount > 0) {
                    sql.append(" or (");
                } else {
                    sql.append("(");
                }
                for (i = 0; i < fieldConstraintsCount; ++i) {
                    Field field = this.fieldsConstraints.get(i);
                    String f = field.getAnnotation(Column.class).name();
                    sql.append("this.").append(f).append("=:").append(f);
                    if (i + 1 >= fieldConstraintsCount) continue;
                    sql.append(" or ");
                }
                sql.append(")");
            }
            if (!isInsert) {
                sql.append(")");
            }
            return sql.toString();
        }
        return null;
    }

    protected Field getField(String fieldName) {
        for (Field field : this.fields) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        throw new EmsValidationException(this.classOfModel.getSimpleName() + "." + fieldName + " n\u00e3o existe.");
    }

    protected Integer getIdFromObject(Model obj) {
        try {
            Object id = this.idField.get(obj);
            return (Integer)id;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class EmsAliasToEntityMapResultTransformer
    extends AliasedTupleSubsetResultTransformer {
        private static final long serialVersionUID = 1L;
        public static final EmsAliasToEntityMapResultTransformer INSTANCE = new EmsAliasToEntityMapResultTransformer();

        private EmsAliasToEntityMapResultTransformer() {
        }

        public Object transformTuple(Object[] tuple, String[] aliases) {
            int tupleLengh = tuple.length;
            if (aliases[tupleLengh - 1].startsWith("__")) {
                --tupleLengh;
            }
            HashMap<String, Object> result = new HashMap<String, Object>(tupleLengh);
            for (int i = 0; i < tupleLengh; ++i) {
                String alias = aliases[i];
                if (alias == null) continue;
                result.put(alias, tuple[i]);
            }
            return result;
        }

        public boolean isTransformedValueATupleElement(String[] aliases, int tupleLength) {
            return false;
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

